<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package delizus
 */

get_header('solid'); ?>
    
    <?php if(delizus_get_option('page_header')) { ?>
    <?php 
        $img   = delizus_get_option( 'page_header_bg' ) ? delizus_get_option( 'page_header_bg' ) : ''; 
        $subt  = delizus_get_option('sub_title') ? delizus_get_option('sub_title') : esc_html__('Latest From Us', 'delizus');
    ?>
    <!-- subheader -->
        <section id="subheader" data-stellar-background-ratio=".3" style="background-image: url(<?php echo esc_url($img); ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <h1><?php printf( esc_html__( 'Search Results for: %s', 'delizus' ), get_search_query() ); ?></h1>
                        <h2><span><?php echo esc_html($subt); ?></span></h2>
                    </div>
                </div>
            </div>
        </section>
        <!-- subheader close -->
    <?php } ?>
    <!-- Main Content -->
    <div id="content" class="<?php echo esc_attr( delizus_get_option('blog_layout') ); ?>">
        <div class="container">
            <div class="row">
                <div class="col-md-9">
                    <ul class="blog-list">
                    <?php if( have_posts() ) : ?>
                        <?php 
                            while (have_posts()) : the_post();
                                get_template_part( 'content', get_post_format() ) ;
                            endwhile;
                        ?>
                    <?php // If no content, include the "No posts found" template.
                        else : ?>
                                                       
                            <h2 class="page-title"><?php esc_html_e( 'Nothing Found', 'delizus' ); ?></h2>
                            
                            <div class="page-content">
                                <p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'delizus' ); ?></p>
                                <div class="widget_search">
                                    <?php get_search_form(); ?>
                                </div>
                            </div><!-- .page-content -->
                    <?php endif; ?>
                    </ul>
                    <div class="text-center">
                        <?php echo delizus_pagination(); ?>    
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="sidebar">
                        <?php get_sidebar();?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

<?php get_footer(); ?>