<?php

/**
 * Register meta boxes
 *
 * @since 1.0
 *
 * @param array $meta_boxes
 *
 * @return array
 */

function delizus_register_meta_boxes( $meta_boxes ) {

	$prefix = '_cmb_';
	$meta_boxes[] = array(

		'id'       => 'format_detail',

		'title'    => esc_html__( 'Format Details', 'delizus' ),

		'pages'    => array( 'post' ),

		'context'  => 'normal',

		'priority' => 'high',

		'autosave' => true,

		'fields'   => array(

			array(

				'name'             => esc_html__( 'Image', 'delizus' ),

				'id'               => $prefix . 'image',

				'type'             => 'image_advanced',

				'class'            => 'image',

				'max_file_uploads' => 1,

			),

			array(

				'name'  => esc_html__( 'Gallery', 'delizus' ),

				'id'    => $prefix . 'images',

				'type'  => 'image_advanced',

				'class' => 'gallery',

			),			

			array(

				'name'  => esc_html__( 'Audio', 'delizus' ),

				'id'    => $prefix . 'link_audio',

				'type'  => 'oembed',

				'cols'  => 20,

				'rows'  => 2,

				'class' => 'audio',

				'desc' => 'Ex: https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/139083759',

			),

			array(

				'name'  => esc_html__( 'Video', 'delizus' ),

				'id'    => $prefix . 'link_video',

				'type'  => 'oembed',

				'cols'  => 20,

				'rows'  => 2,

				'class' => 'video',

				'desc' => 'Example: <b>https://player.vimeo.com/video/112734492</b>',

			),			

		),

	);

	$meta_boxes[] = array(
		'id'       => 'menu_settings',
		'title'    => esc_html__( 'Menu Settings', 'delizus' ),
		'pages'    => array( 'menu' ),
		'context'  => 'normal',
		'priority' => 'high',
		'autosave' => true,
		'fields'   => array(
            array(
                'name' => 'Menu Price',
                'id'   => $prefix . 'price',
                'type' => 'text',
            ),
		),

	);


	$meta_boxes[] = array(
		'id'         => 'event_settings',
		'title'      => 'Event Extra Options',
		'pages'      => array( 'event' ), // Post type
		'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
                'name' => 'Date',
                'id'   => $prefix . 'event_date',
                'type' => 'date',
            ),
            array(
                'name' => 'Time',
                'id'   => $prefix . 'event_time',
                'type' => 'text',
            ),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'page_settings',
		'title'      => 'Page Settings',
		'pages'      => array( 'page', 'post', 'menu', 'event' ), // Post type
		'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
                'name' => 'Background Page Header',
                'id'   => $prefix . 'bg_header',
                'type' => 'image_advanced',
                'max_file_uploads' => 1,
            ),
            array(
                'name' => 'Subtitle',
                'id'   => $prefix . 'subtext',
                'type' => 'textarea',
            ),
		)
	);
	

	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'delizus_register_meta_boxes' );

