<?php
/**
 * Delizus theme customizer
 *
 * @package Delizus
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Delizus_Customize {
	/**
	 * Customize settings
	 *
	 * @var array
	 */
	protected $config = array();

	/**
	 * The class constructor
	 *
	 * @param array $config
	 */
	public function __construct( $config ) {
		$this->config = $config;

		if ( ! class_exists( 'Kirki' ) ) {
			return;
		}

		$this->register();
	}

	/**
	 * Register settings
	 */
	public function register() {
		/**
		 * Add the theme configuration
		 */
		if ( ! empty( $this->config['theme'] ) ) {
			Kirki::add_config(
				$this->config['theme'], array(
					'capability'  => 'edit_theme_options',
					'option_type' => 'theme_mod',
				)
			);
		}

		/**
		 * Add panels
		 */
		if ( ! empty( $this->config['panels'] ) ) {
			foreach ( $this->config['panels'] as $panel => $settings ) {
				Kirki::add_panel( $panel, $settings );
			}
		}

		/**
		 * Add sections
		 */
		if ( ! empty( $this->config['sections'] ) ) {
			foreach ( $this->config['sections'] as $section => $settings ) {
				Kirki::add_section( $section, $settings );
			}
		}

		/**
		 * Add fields
		 */
		if ( ! empty( $this->config['theme'] ) && ! empty( $this->config['fields'] ) ) {
			foreach ( $this->config['fields'] as $name => $settings ) {
				if ( ! isset( $settings['settings'] ) ) {
					$settings['settings'] = $name;
				}

				Kirki::add_field( $this->config['theme'], $settings );
			}
		}
	}

	/**
	 * Get config ID
	 *
	 * @return string
	 */
	public function get_theme() {
		return $this->config['theme'];
	}

	/**
	 * Get customize setting value
	 *
	 * @param string $name
	 *
	 * @return bool|string
	 */
	public function get_option( $name ) {
		if ( ! isset( $this->config['fields'][$name] ) ) {
			return false;
		}

		$default = isset( $this->config['fields'][$name]['default'] ) ? $this->config['fields'][$name]['default'] : false;

		return get_theme_mod( $name, $default );
	}
}

/**
 * This is a short hand function for getting setting value from customizer
 *
 * @param string $name
 *
 * @return bool|string
 */
function delizus_get_option( $name ) {
	global $delizus_customize;

	if ( empty( $delizus_customize ) ) {
		return false;
	}

	if ( class_exists( 'Kirki' ) ) {
		$value = Kirki::get_option( $delizus_customize->get_theme(), $name );
	} else {
		$value = $delizus_customize->get_option( $name );
	}

	return apply_filters( 'delizus_get_option', $value, $name );
}

/**
 * Move some default sections to `general` panel that registered by theme
 *
 * @param object $wp_customize
 */
function delizus_customize_modify( $wp_customize ) {
	$wp_customize->get_section( 'title_tagline' )->panel     = 'general';
	$wp_customize->get_section( 'static_front_page' )->panel = 'general';
}

add_action( 'customize_register', 'delizus_customize_modify' );

/**
 * Customizer configuration
 */
$delizus_customize = new Delizus_Customize(
	array(
		'theme'    => 'delizus',

		'panels'   => array(
			'general' => array(
				'priority' => 10,
				'title'    => esc_html__( 'General', 'delizus' ),
			),
			'header'  => array(
				'priority' => 11,
				'title'    => esc_html__( 'Header', 'delizus' ),
			),
			'socials'  => array(
				'priority' => 210,
				'title'    => esc_html__( 'Socials', 'delizus' ),
			),
		),

		'sections' => array(

			// Panel Header
			'top_header'      => array(
				'title'       => esc_html__( 'Top Header', 'delizus' ),
				'description' => '',
				'priority'    => 10,
				'capability'  => 'edit_theme_options',
				'panel'       => 'header',
			),
			'header'      => array(
				'title'       => esc_html__( 'Navigation', 'delizus' ),
				'description' => '',
				'priority'    => 10,
				'capability'  => 'edit_theme_options',
				'panel'       => 'header',
			),
			'logo'        => array(
				'title'       => esc_html__( 'Site Logo', 'delizus' ),
				'description' => '',
				'priority'    => 50,
				'capability'  => 'edit_theme_options',
				'panel'       => 'header',
			),
			'page_header' => array(
				'title'       => esc_html__( 'Page Header', 'delizus' ),
				'description' => '',
				'priority'    => 15,
				'capability'  => 'edit_theme_options',
			),

			// Panel Socials
			'socials'      => array(
				'title'       => esc_html__( 'Socials', 'delizus' ),
				'description' => '',
				'priority'    => 220,
				'capability'  => 'edit_theme_options',
			),

			
			// Panel Content
			'content'     => array(
				'title'       => esc_html__( 'Blog', 'delizus' ),
				'description' => '',
				'priority'    => 240,
				'capability'  => 'edit_theme_options',
			),

			// Panel Projects
			'project'     => array(
				'title'       => esc_html__( 'Portfolio', 'delizus' ),
				'description' => '',
				'priority'    => 240,
				'capability'  => 'edit_theme_options',
			),

			// Panel Shop
			'shop'     => array(
				'title'       => esc_html__( 'Shop', 'delizus' ),
				'description' => '',
				'priority'    => 240,
				'capability'  => 'edit_theme_options',
			),

			// Panel Footer
			'footer'     => array(
				'title'       => esc_html__( 'Footer', 'delizus' ),
				'description' => '',
				'priority'    => 240,
				'capability'  => 'edit_theme_options',
			),

			// 404
			'error'     => array(
				'title'       => esc_html__( '404 Error', 'delizus' ),
				'description' => '',
				'priority'    => 245,
				'capability'  => 'edit_theme_options',
			),

			// Coming Soon
			'csoon'     => array(
				'title'       => esc_html__( 'Coming Soon', 'delizus' ),
				'description' => '',
				'priority'    => 245,
				'capability'  => 'edit_theme_options',
			),

			// Panel Styling
			'styling'     => array(
				'title'       => esc_html__( 'Miscellaneous', 'delizus' ),
				'description' => '',
				'priority'    => 250,
				'capability'  => 'edit_theme_options',
			),
		),

		'fields'   => array(
			
			//Top Header
			'top_header' => array(
				'type'     => 'toggle',
				'label'    => esc_html__( 'Enable Top Header', 'delizus' ),
				'section'  => 'top_header',
				'default'  => '0',
				'priority' => 10,
			),
			'bg_top'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Background', 'delizus' ),
				'section'  => 'top_header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
				 	array(
					  	'setting'  => 'top_header',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'color_top'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Text', 'delizus' ),
				'section'  => 'top_header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
				 	array(
					  	'setting'  => 'top_header',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'top_info'     => array(
				'type'     => 'repeater',
				'label'    => esc_html__( 'Top Infomation', 'delizus' ),
				'section'  => 'top_header',
				'priority' => 10,
				'default'  => array(),
				'fields'   => array(
					'icon' => array(
						'type'        => 'text',
						'label'       => esc_html__( 'Icon Class', 'delizus' ),
						'description' => esc_html__( 'This will be the icon: http://fontawesome.io/icons/', 'delizus' ),
						'default'     => '',
					),
					'details' => array(
						'type'        => 'textarea',
						'label'       => esc_html__( 'Details', 'delizus' ),
						'description' => esc_html__( 'This will be the details', 'delizus' ),
						'default'     => '',
					),
				),
				'active_callback' => array(
					array(
					  	'setting'  => 'top_header',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'socials'     => array(
				'type'     => 'repeater',
				'label'    => esc_html__( 'Socials', 'delizus' ),
				'section'  => 'top_header',
				'priority' => 10,
				'default'  => array(),
				'fields'   => array(
					'icon' => array(
						'type'        => 'text',
						'label'       => esc_html__( 'Icon Class', 'delizus' ),
						'description' => esc_html__( 'This will be the social icon: http://fontawesome.io/icons/', 'delizus' ),
						'default'     => '',
					),
					'link' => array(
						'type'        => 'text',
						'label'       => esc_html__( 'Link URL', 'delizus' ),
						'description' => esc_html__( 'This will be the social link', 'delizus' ),
						'default'     => '',
					),
				),
				'active_callback' => array(
					array(
					  	'setting'  => 'top_header',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			

			// Header layout
			'sticky'     => array(
				'type'     => 'toggle',
				'label'    => esc_html__( 'Sticky Header', 'delizus' ),
				'section'  => 'header',
				'default'  => '1',
				'priority' => 10,
			),
			'header_layout'  => array(
				'type'     => 'select',
				'label'    => esc_html__( 'Header Style', 'delizus' ),
				'section'  => 'header',
				'default'  => '1',
				'priority' => 10,
				'choices'  => array(
					'1' 	=> esc_html__( 'Header Transparent', 'delizus' ),
					'2' 	=> esc_html__( 'Header Dark', 'delizus' ),
					'3' 	=> esc_html__( 'Header Light', 'delizus' ),
					'4' 	=> esc_html__( 'Custom Color', 'delizus' ),
				),
			),
			'bg_menu'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Background Main Menu', 'delizus' ),
				'section'  => 'header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
				 	array(
					  	'setting'  => 'header_layout',
					  	'operator' => '==',
					  	'value'    => 4,
				 	),
				),
			),
			'color_menu'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Text Menu', 'delizus' ),
				'section'  => 'header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
				 	array(
					  	'setting'  => 'header_layout',
					  	'operator' => '==',
					  	'value'    => 4,
				 	),
				),
			),
			'color_hover'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Text Menu Hover', 'delizus' ),
				'section'  => 'header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
				 	array(
					  	'setting'  => 'header_layout',
					  	'operator' => '==',
					  	'value'    => 4,
				 	),
				),
			),
			'bg_smenu'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Background Scroll Menu', 'delizus' ),
				'section'  => 'header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
				 	array(
					  	'setting'  => 'sticky',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				 	array(
					  	'setting'  => 'header_layout',
					  	'operator' => '==',
					  	'value'    => 4,
				 	),
				),
			),
			'color_smenu'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Text Scroll Menu', 'delizus' ),
				'section'  => 'header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'sticky',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				 	array(
					  	'setting'  => 'header_layout',
					  	'operator' => '==',
					  	'value'    => 4,
				 	),
				),
			),
			'color_shover'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Text Scroll Menu Hover', 'delizus' ),
				'section'  => 'header',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'sticky',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				 	array(
					  	'setting'  => 'header_layout',
					  	'operator' => '==',
					  	'value'    => 4,
				 	),
				),
			),
			'sepe_list'    => array(
				'type'     => 'select',
				'label'    => esc_html__( 'Seperator', 'delizus' ),
				'section'  => 'header',
				'default'  => 'line-separator',
				'priority' => 10,
				'choices'  => array(
					'no-separator' 	 	=> esc_html__( 'None', 'delizus' ),
					'line-separator' 	=> esc_html__( 'Line', 'delizus' ),
					'circle-separator'  => esc_html__( 'Circle', 'delizus' ),
					'dotted-separator' 	=> esc_html__( 'Dotted', 'delizus' ),
					'plus-separator' 	=> esc_html__( 'Plus', 'delizus' ),
					'strip-separator' 	=> esc_html__( 'Strip', 'delizus' ),
				),
			),
			'sticky'     => array(
				'type'     => 'toggle',
				'label'    => esc_html__( 'Sticky Header', 'delizus' ),
				'section'  => 'header',
				'default'  => '1',
				'priority' => 10,
			),
			'cus_font'     => array(
				'type'     => 'toggle',
				'label'    => esc_html__( 'Custom Font Menu', 'delizus' ),
				'section'  => 'header',
				'default'  => '0',
				'priority' => 12,
			),
			'menu_font'     => array(
				'type'     => 'typography',
				'label'    => esc_html__( 'Menu Font', 'delizus' ),
				'section'  => 'header',
				'priority' => 12,
				'default'     => array(
					'font-family'    => 'Montserrat',
					'variant'        => 'bold',
					'font-size'      => '11px',
					'letter-spacing' => '2',
					'text-transform' => 'uppercase',
				),
				'active_callback' => array(
				 	array(
					  	'setting'  => 'cus_font',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),			

			// Logo
			'logo'           => array(
				'type'     => 'image',
				'label'    => esc_html__( 'Logo', 'delizus' ),
				'section'  => 'logo',
				'default'  => '',
				'priority' => 10,
			),
			'logo_width'     => array(
				'type'     => 'number',
				'label'    => esc_html__( 'Logo Width', 'delizus' ),
				'section'  => 'logo',
				'default'  => '',
				'priority' => 10,
			),
			'logo_height'    => array(
				'type'     => 'number',
				'label'    => esc_html__( 'Logo Height', 'delizus' ),
				'section'  => 'logo',
				'default'  => '',
				'priority' => 10,
			),
			'logo_position'  => array(
				'type'     => 'spacing',
				'label'    => esc_html__( 'Logo Margin', 'delizus' ),
				'section'  => 'logo',
				'priority' => 10,
				'default'  => array(
					'top'    => '0',
					'bottom' => '0',
					'left'   => '0',
					'right'  => '0',
				),
			),

			'logo_2'           => array(
				'type'     => 'image',
				'label'    => esc_html__( 'Logo Scroll', 'delizus' ),
				'section'  => 'logo',
				'default'  => '',
				'priority' => 10,
			),
			'logo_2_width'     => array(
				'type'     => 'number',
				'label'    => esc_html__( 'Logo Scroll Width', 'delizus' ),
				'section'  => 'logo',
				'default'  => '',
				'priority' => 10,
			),
			'logo_2_height'    => array(
				'type'     => 'number',
				'label'    => esc_html__( 'Logo Scroll Height', 'delizus' ),
				'section'  => 'logo',
				'default'  => '',
				'priority' => 10,
			),
			'logo_2_position'  => array(
				'type'     => 'spacing',
				'label'    => esc_html__( 'Logo Scroll Margin', 'delizus' ),
				'section'  => 'logo',
				'priority' => 10,
				'default'  => array(
					'top'    => '0',
					'bottom' => '0',
					'left'   => '0',
					'right'  => '0',
				),
			),
			

			// Page Header
			'page_header'    => array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Page Header', 'delizus' ),
				'description' => esc_html__( 'Enable to show page header on whole site', 'delizus' ),
				'section'     => 'page_header',
				'default'     => '1',
				'priority'    => 10,
			),
			
			'page_header_bg' => array(
				'type'        => 'image',
				'label'       => esc_html__( 'Background Image', 'delizus' ),
				'description' => esc_html__( 'Upload a page header background image', 'delizus' ),
				'section'     => 'page_header',
				'default'     => '',
				'priority'    => 10,
				'active_callback' => array(
				 	array(
					  	'setting'  => 'page_header',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),

			// Content
			'blog_layout'  => array(
				'type'     => 'radio-image',
				'label'    => esc_html__( 'Blog List Layout', 'delizus' ),
				'section'  => 'content',
				'default'  => 'default',
				'priority' => 10,
				'choices'  => array(
					'default' 	=> get_template_directory_uri() . '/framework/admin/images/right.png',
					'left-bar' 	=> get_template_directory_uri() . '/framework/admin/images/left.png',
					'no-bar' 	=> get_template_directory_uri() . '/framework/admin/images/full.png',
				),
			),
			'post_layout'  => array(
				'type'     => 'radio-image',
				'label'    => esc_html__( 'Single Blog Layout', 'delizus' ),
				'section'  => 'content',
				'default'  => 'default',
				'priority' => 10,
				'choices'  => array(
					'default' 	=> get_template_directory_uri() . '/framework/admin/images/right.png',
					'left-bar' 	=> get_template_directory_uri() . '/framework/admin/images/left.png',
					'no-bar' 	=> get_template_directory_uri() . '/framework/admin/images/full.png',
				),
			),
			'excerpt_length' => array(
				'type'    => 'number',
				'label'   => esc_html__( 'Excerpt Length', 'delizus' ),
				'section' => 'content',
				'default' => 50,
				'choices' => array(
					'min'  => 0,
					'max'  => 100,
					'step' => 1,
				),
			),
			'sub_title' => array(
				'type'    		=> 'text',
				'label'   		=> esc_html__( 'Sub Title Blog', 'delizus' ),
				'section' 		=> 'content',
				'default' 		=> '',
				'priority'    	=> 12,
			),
			'title_single' => array(
				'type'    		=> 'text',
				'label'   		=> esc_html__( 'Title Header Single', 'delizus' ),
				'section' 		=> 'content',
				'default' 		=> '',
				'priority'    	=> 12,
			),			
			'read_more' => array(
				'type'    		=> 'text',
				'label'   		=> esc_html__( 'Read More Button', 'delizus' ),
				'section' 		=> 'content',
				'default' 		=> '',
				'priority'    	=> 12,
			),

			//Shop
			/*'page_header_shop' => array(
				'type'        => 'image',
				'label'       => esc_html__( 'Background Image', 'delizus' ),
				'description' => esc_html__( 'Upload a page header background image', 'delizus' ),
				'section'     => 'shop',
				'default'     => '',
				'priority'    => 10,
			),
			'shop_layout'  => array(
				'type'     => 'radio-image',
				'label'    => esc_html__( 'Shop Layout', 'delizus' ),
				'section'  => 'shop',
				'default'  => 'default',
				'priority' => 10,
				'choices'  => array(
					'default' 	=> get_template_directory_uri() . '/framework/admin/images/right.png',
					'left-bar' 	=> get_template_directory_uri() . '/framework/admin/images/left.png',
					'no-bar' 	=> get_template_directory_uri() . '/framework/admin/images/full.png',
				),
			),
			'col_shop'     => array(
				'type'     => 'select',
				'label'    => esc_html__( 'Number Columns', 'delizus' ),
				'description' => esc_html__( 'Store column count for displaying the grid', 'delizus' ),
				'section'  => 'shop',
				'default'  => '3',
				'priority' => 10,
				'choices'  => array(
					'2' 	 => esc_html__( '2 Columns', 'delizus' ),
					'3' 	 => esc_html__( '3 Columns', 'delizus' ),
					'4'  	 => esc_html__( '4 Columns', 'delizus' ),
				),
			),
			'per_shop' => array(
				'type'    		=> 'number',
				'label'   		=> esc_html__( 'Products Per Page', 'delizus' ),
				'section' 		=> 'shop',
				'default' 		=> '12',
				'priority'    	=> 12
			),*/

			//Footer
			'w_footer'     => array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Footer Widget', 'delizus' ),
				'section'     => 'footer',
				'default'     => '0',
				'priority'    => 10,
			),
			'bg_footer'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Background Color Footer', 'delizus' ),
				'section'  => 'footer',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'w_footer',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'color_footer'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Text Footer', 'delizus' ),
				'section'  => 'footer',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'w_footer',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'color_ftitle'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Title Widget', 'delizus' ),
				'section'  => 'footer',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'w_footer',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'bfooter'     => array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Footer Bottom', 'delizus' ),
				'section'     => 'footer',
				'default'     => '1',
				'priority'    => 10,
			),
			'bg_bottom'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Background Bottom Footer', 'delizus' ),
				'section'  => 'footer',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'bfooter',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'color_bottom' => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Color Text Footer', 'delizus' ),
				'section'  => 'footer',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'bfooter',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'padd_footer'  => array(
				'type'     => 'number',
				'label'    => esc_html__( 'Padding Top/Bottom', 'delizus' ),
				'section'  => 'footer',
				'default'  => '80px',
				'priority' => 10,
			),
			'f_socials'     => array(
				'type'     => 'repeater',
				'label'    => esc_html__( 'Socials', 'delizus' ),
				'section'  => 'footer',
				'priority' => 10,
				'default'  => array(),
				'fields'   => array(
					'icon' => array(
						'type'        => 'text',
						'label'       => esc_html__( 'Icon Class', 'delizus' ),
						'description' => esc_html__( 'This will be the social icon: http://fontawesome.io/icons/', 'delizus' ),
						'default'     => '',
					),
					'link' => array(
						'type'        => 'text',
						'label'       => esc_html__( 'Link URL', 'delizus' ),
						'description' => esc_html__( 'This will be the social link', 'delizus' ),
						'default'     => '',
					),
				),
				'active_callback' => array(
					array(
					  	'setting'  => 'bfooter',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'logo_footer'  => array(
				'type'     => 'image',
				'label'    => esc_html__( 'Logo Footer', 'delizus' ),
				'section'  => 'footer',
				'default'  => '',
				'priority' => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'bfooter',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),
			'copy_right'      => array(
				'type'        => 'code',
				'label'       => esc_html__( 'Copy Right Text', 'delizus' ),
				'section'     => 'footer',
				'default'     => '',
				'priority'    => 10,
				'active_callback' => array(
					array(
					  	'setting'  => 'bfooter',
					  	'operator' => '==',
					  	'value'    => 1,
				 	),
				),
			),

			// 404
			'h_error'      => array(
				'type'     => 'number',
				'label'    => esc_html__( 'Height', 'delizus' ),
				'section'  => 'error',
				'default'  => '750',
				'priority' => 10,
			),
			'bgi_error'    => array(
				'type'     => 'image',
				'label'    => esc_html__( 'Background Image', 'delizus' ),
				'section'  => 'error',
				'default'  => '',
				'priority' => 10,
			),
			'bgc_error'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Background Color', 'delizus' ),
				'section'  => 'error',
				'default'  => '',
				'priority' => 10,
			),
			'c_error'      => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Text Color', 'delizus' ),
				'section'  => 'error',
				'default'  => '',
				'priority' => 10,
			),
			

			//Styling
			'preload'     => array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Preloader', 'delizus' ),
				'section'     => 'styling',
				'default'     => '1',
				'priority'    => 10,
			),
			'dark_color'      => array(
				'type'        => 'toggle',
				'label'       => esc_html__( 'Dark Style', 'delizus' ),
				'section'     => 'styling',
				'default'     => '0',
				'priority'    => 10,
			),
			'api_map'      => array(
				'type'     => 'text',
				'label'    => esc_html__( 'API Google Map', 'decades' ),
				'section'  => 'styling',
				'default'  => 'AIzaSyAvpnlHRidMIU374bKM5-sx8ruc01OvDjI',
				'priority' => 10,
			),
			'main_color'    => array(
				'type'     => 'color',
				'label'    => esc_html__( 'Primary Color', 'delizus' ),
				'section'  => 'styling',
				'default'  => '#ca8e46',
				'priority' => 10,
			),
			'custom_css'     => array(
				'type'        => 'code',
				'label'       => esc_html__( 'Custom Code', 'delizus' ),
				'description' => esc_html__( 'Add more js, css, html... code here.', 'delizus' ),
				'section'     => 'styling',
				'default'     => '',
				'priority'    => 10,
			),
		),
	)
);