<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.7.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product, $woocommerce_loop;
// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}
// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}
// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}
// Increase loop count
$woocommerce_loop['loop']++;
// Extra post classes
$classes = array();
if ( 0 === ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 === $woocommerce_loop['columns'] ) {
	$classes[] = 'first1';
}
if ( 0 === $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
	$classes[] = 'last1';
}
$meta = _WSH()->get_meta('_bunch_layout_settings', get_option( 'woocommerce_shop_page_id' ));
$meta1 = _WSH()->get_meta('_bunch_header_settings', get_option( 'woocommerce_shop_page_id' ));
$layout = decorators_set( $meta, 'layout', 'left' );
$layout = decorators_set( $_GET, 'layout' ) ? $_GET['layout'] : $layout; 
if(decorators_set($_GET, 'layout_style')) $layout = decorators_set($_GET, 'layout_style'); else
$layout = decorators_set( $meta, 'layout', 'left' );
$sidebar = decorators_set( $meta, 'sidebar', 'blog-sidebar' );

$layout = ($layout) ? $layout : 'right';
$sidebar = ($sidebar) ? $sidebar : 'blog-sidebar';

if( !$layout || $layout == 'full' || decorators_set($_GET, 'layout_style')=='full' ) $classes[] = 'col-lg-3 col-md-4 col-sm-6 col-xs-12 default-shop-item product-column'; else $classes[] = 'col-lg-4 col-md-6 col-sm-6 col-xs-12 default-shop-item product-column'; 

?>
<div <?php post_class( $classes ); ?>>
	<div class="inner-box">
	<?php
	/**
	 * woocommerce_before_shop_loop_item hook.
	 *
	 * @hooked woocommerce_template_loop_product_link_open - 10
	 */
	//do_action( 'woocommerce_before_shop_loop_item' );
	/**
	 * woocommerce_before_shop_loop_item_title hook.
	 *
	 * @hooked woocommerce_show_product_loop_sale_flash - 10
	 * @hooked woocommerce_template_loop_product_thumbnail - 10
	 */?>
	 <figure class="image-box"><?php woocommerce_template_loop_product_thumbnail();?></figure>
	<?php do_action( 'woocommerce_before_shop_loop_item_title' );
	/**
	 * woocommerce_shop_loop_item_title hook.
	 *
	 * @hooked woocommerce_template_loop_product_title - 10
	 */
	//do_action( 'woocommerce_shop_loop_item_title' );
	/**
	 * woocommerce_after_shop_loop_item_title hook.
	 *
	 * @hooked woocommerce_template_loop_rating - 5
	 * @hooked woocommerce_template_loop_price - 10
	 */
	do_action( 'woocommerce_after_shop_loop_item_title' );?>
		
		<div class="lower-content">
            <h3><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php the_title();?></a></h3>
            <div class="rating"><?php woocommerce_template_loop_rating(); ?></div>
            <div class="item-price"><?php woocommerce_template_loop_price();?></div>
            <div class="links-box">
            	<?php 
					$post_thumbnail_id = get_post_thumbnail_id($post->ID);
					$post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
				?>
                <a class="cart-btn" href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php esc_html_e('Add to Cart', 'decorators');?></a>
                <a class="zoom-btn lightbox-image" href="<?php echo esc_url($post_thumbnail_url);?>" title="<?php esc_html_e('Image Caption Here', 'decorators');?>"><span class="fa fa-search-plus" title="<?php esc_html_e('Quick View', 'decorators');?>"></span></a>
                <a class="add-to-favorite" href="<?php echo esc_url(get_permalink(get_the_id()));?>" title="<?php esc_html_e('Add to Favourite', 'decorators');?>"><span class="fa fa-link"></span></a>
            </div>
        </div>
		
	<?php
	/**
	 * woocommerce_after_shop_loop_item hook.
	 *
	 * @hooked woocommerce_template_loop_product_link_close - 5
	 * @hooked woocommerce_template_loop_add_to_cart - 10
	 */
	//do_action( 'woocommerce_after_shop_loop_item' );
	?>
    </div>
</div>
