<?php
ob_start() ;?>

<!--Pricing Section-->
<section class="pricing-section">
    <div class="auto-container">
        
        <div class="sec-title medium">
            <h2><?php echo wp_kses_post($title);?></h2>
            <div class="desc-text"><?php echo wp_kses_post($text);?></div>
        </div>
        
        <div class="row clearfix">
            <?php $skills_array = (array)json_decode(urldecode($pricing_table));
				if( $skills_array && is_array($skills_array) ): 
				foreach( (array)$skills_array as $value ):
			?>
            <!--Pricing Column-->
            <div class="pricing-column col-lg-3 col-md-4 col-sm-6 col-xs-12">
                <div class="inner-box">
                    <div class="plan-title"><?php echo wp_kses_post(decorators_set( $value, 'title' )); ?></div>
                    <div class="price-header"><span class="price"><sup><?php echo wp_kses_post(decorators_set( $value, 'currency' )); ?></sup> <?php echo wp_kses_post(decorators_set( $value, 'price' )); ?></span> <sub><?php esc_html_e('/', 'decorators');?> <?php echo wp_kses_post(decorators_set( $value, 'duration' )); ?></sub></div>
                    <div class="lower-content">
                        <ul class="spec-list">
                            <?php $fearures = explode("\n",decorators_set($value, 'feature_str'));?>
							<?php foreach($fearures as $feature):?>
                                <li><?php echo wp_kses_post($feature ); ?></li>
                            <?php endforeach;?>
                        </ul>
                        
                        <a href="<?php echo esc_url(decorators_set($value, 'btn_link'));?>" class="theme-btn btn-style-two"><?php echo wp_kses_post(decorators_set($value, 'btn_text'));?></a>
                    </div>
                </div>
            </div>
            <?php endforeach; endif;?>
        </div>
    </div>
</section>

<?php
	$output = ob_get_contents(); 
   ob_end_clean(); 
   return $output ; ?>
   