<?php
///----Blog widgets---

/// Recent Posts 
class Bunch_Recent_Post extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Recent_Post', /* Name */esc_html__('Decorators Recent Posts','decorators'), array( 'description' => esc_html__('Show the recent posts', 'decorators' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
        <!-- Recent Posts -->
        <div class="recent-posts">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
		
			<?php $query_string = 'posts_per_page='.$instance['number'];
            if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
            query_posts( $query_string ); 
            
            $this->posts();
            wp_reset_query();
            ?>
            
        </div>
        
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Latest News', 'decorators');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'decorators'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'decorators'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<!-- Title -->
			<?php while( have_posts() ): the_post(); ?>
            <div class="post">
                <figure class="post-thumb"><?php the_post_thumbnail('decorators_65x65');?><a href="<?php echo esc_url(get_permalink(get_the_id()));?>" class="overlay-link"><span class="flaticon-plus-1"></span></a></figure>
                <h4><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php echo wp_kses_post(decorators_trim(get_the_title(), '6'));?></a></h4>
                <div class="post-meta"><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) )); ?>"><span class="fa fa-user"></span> <?php the_author(); ?></a> <a href="#"><span class="fa fa-eye"></span> 31 Views</a></div>
            </div>
            <?php endwhile; ?>
        
        <?php endif;
    }
}

/// Recent Posts 
class Bunch_Recent_Footer_Posts extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Recent_Footer_Posts', /* Name */esc_html__('Decorators Footer Recent Posts','decorators'), array( 'description' => esc_html__('Show the recent posts', 'decorators' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
		
        <!-- Recent Posts -->
        <div class="posts-widget">
            <div class="posts">
                <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            
                <?php $query_string = 'posts_per_page='.$instance['number'];
                if( $instance['cat'] ) $query_string .= '&cat='.$instance['cat'];
                query_posts( $query_string ); 
                
                $this->posts();
                wp_reset_query();
                ?>
                
            </div>
        </div>
		<?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Latest News', 'decorators');
		$number = ( $instance ) ? esc_attr($instance['number']) : 3;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title: ', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('No. of Posts:', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
       
    	<p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'decorators'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'decorators'), 'selected'=>$cat, 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<!-- Title -->
			<?php while( have_posts() ): the_post(); ?>
            <div class="post">
                <figure class="post-thumb"><?php the_post_thumbnail('decorators_60x60');?><a href="<?php echo esc_url(get_permalink(get_the_id()));?>" class="overlay-link"><span class="flaticon-plus-1"></span></a></figure>
                <div class="desc-text"><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php echo wp_kses_post(decorators_trim(get_the_title(), '8'));?></a></div>
                <div class="time"><span class="fa fa-clock-o"></span> <?php the_time('M d, Y'); ?></div>
            </div>
            <?php endwhile; ?>
        
        <?php endif;
    }
}

///----footer widgets---
//About Us
class Bunch_About_us extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_About_us', /* Name */esc_html__('Decorators About Us','decorators'), array( 'description' => esc_html__('Show the information about company', 'decorators' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		echo wp_kses_post($before_widget);?>
      		
			<!--Footer Column-->
            <div class="about-widget">
                <div class="footer-logo"><figure><a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo wp_kses_post($instance['logo_image']); ?>" alt="<?php esc_attr_e('image', 'decorators');?>"></a></figure></div>
                <div class="widget-content">
                    <div class="text"><?php echo wp_kses_post($instance['content']); ?></div>
                    <ul class="contact-info">
                        <li><span class="icon fa fa-map-marker"></span><?php echo nl2br(wp_kses_post($instance['address'])); ?></li>
                        <li><span class="icon fa fa-phone"></span><?php echo nl2br(wp_kses_post($instance['phone'])); ?></li>
                        <li><span class="icon fa fa-envelope-o"></span><?php echo sanitize_email($instance['email']); ?></li>
                    </ul>
                </div>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;

		$instance['logo_image'] = strip_tags($new_instance['logo_image']);
		$instance['content'] = $new_instance['content'];
		$instance['address'] = $new_instance['address'];
		$instance['phone'] = $new_instance['phone'];
		$instance['email'] = $new_instance['email'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$logo_image = ($instance) ? esc_attr($instance['logo_image']) : 'http://asianitbd.com/wp/decorators/wp-content/themes/decorators/images/logo-4.png';
		$content = ($instance) ? esc_attr($instance['content']) : '';
		$address = ( $instance ) ? esc_attr($instance['address']) : 'Rock St 12, Newyork City, USA';
		$phone = ( $instance ) ? esc_attr($instance['phone']) : '(526) 236-895-4732';
		$email = ( $instance ) ? esc_attr($instance['email']) : 'Decoratorssuport@gmail.com';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('logo_image')); ?>"><?php esc_html_e('Logo Image:', 'decorators'); ?></label>
            <input placeholder="<?php esc_html_e('logo link here', 'decorators');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('logo_image')); ?>" name="<?php echo esc_attr($this->get_field_name('logo_image')); ?>" type="text" value="<?php echo esc_attr($logo_image); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('content')); ?>"><?php esc_html_e('Content:', 'decorators'); ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('content')); ?>" name="<?php echo esc_attr($this->get_field_name('content')); ?>" ><?php echo wp_kses_post($content); ?></textarea>
        </p>  
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address:', 'decorators'); ?></label>
            <input placeholder="<?php esc_html_e('Address', 'decorators');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" type="text" value="<?php echo esc_attr($address); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone:', 'decorators'); ?></label>
            <input placeholder="<?php esc_html_e('Phone', 'decorators');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>" type="text" value="<?php echo esc_attr($phone); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email:', 'decorators'); ?></label>
            <input placeholder="<?php esc_html_e('Email', 'decorators');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" type="text" value="<?php echo esc_attr($email); ?>" />
        </p>   
                
		<?php 
	}
	
}

/// Recent Tags & Works 
class Bunch_tags_work extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_tags_work', /* Name */esc_html__('Decorators Tags & Works Widget','decorators'), array( 'description' => esc_html__('Show the Tags & Works', 'decorators' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title1 = apply_filters( 'widget_title', $instance['title1'] );
		$title2 = apply_filters( 'widget_title', $instance['title2'] );
		
		echo wp_kses_post($before_widget); ?>
		
        
        <div class="tags-widget">
            <?php echo wp_kses_post($before_title.$title1.$after_title); ?>
            <div class="widget-content">
                <ul class="tags-list">
                    <li><?php the_tags(); ?></li>
                </ul>
            </div>
        </div>
        <br/>
        <div class="gallery-widget">
            <?php echo wp_kses_post($before_title.$title2.$after_title); ?>
            <div class="gallery-widget-carousel">
            	
            	<?php 
				$args = array('post_type' => 'bunch_portfolio', 'showposts'=>$instance['number']);
				if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'portfolio_category','field' => 'id','terms' => (array)$instance['cat']));
				query_posts($args); 
					
					$this->posts();
					wp_reset_query();
				?>
                
            </div>
        </div>
		
        <?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title1'] = strip_tags($new_instance['title1']);
		$instance['title2'] = strip_tags($new_instance['title2']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title1 = ( $instance ) ? esc_attr($instance['title1']) : esc_html__('Popular Tags', 'decorators');
		$title2 = ( $instance ) ? esc_attr($instance['title2']) : esc_html__('Recent Works', 'decorators');
		$number = ( $instance ) ? esc_attr($instance['number']) : 12;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
			
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title1')); ?>"><?php esc_html_e('Tags Title: ', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title1')); ?>" name="<?php echo esc_attr($this->get_field_name('title1')); ?>" type="text" value="<?php echo esc_attr( $title1 ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title2')); ?>"><?php esc_html_e('Works Title: ', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title2')); ?>" name="<?php echo esc_attr($this->get_field_name('title2')); ?>" type="text" value="<?php echo esc_attr( $title2 ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts: ', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'decorators'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'decorators'), 'selected'=>$cat, 'taxonomy' => 'portfolio_category', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<!-- Title -->
            <?php while( have_posts() ): the_post(); ?>
            <?php 
                $post_thumbnail_id = get_post_thumbnail_id($post->ID);
                $post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
            ?>
            <div class="item">
                <figure class="post-thumb"><?php the_post_thumbnail('decorators_80x65', array('class' => 'img-responsive'));?><a href="<?php echo esc_url(get_permalink(get_the_id()));?>" class="overlay-link"><span class="fa fa-link"></span></a></figure>
            </div>
            <?php endwhile; ?>
                
        <?php endif;
    }
}

/// Recent Services
class Bunch_servies extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_servies', /* Name */esc_html__('Decorators Services Sidebar','decorators'), array( 'description' => esc_html__('Show the Services Sidebar', 'decorators' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		
		echo wp_kses_post($before_widget); ?>
		
        <div class="styled-nav">
            <nav class="nav-outer">
            	<ul>
					<?php 
                    $args = array('post_type' => 'bunch_services', 'showposts'=>$instance['number']);
                    if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'services_category','field' => 'id','terms' => (array)$instance['cat']));
                    query_posts($args); 
                        
                        $this->posts();
                        wp_reset_query();
                    ?>
                </ul>
            </nav>
        </div>
		
        <?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$number = ( $instance ) ? esc_attr($instance['number']) : 6;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
		
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts: ', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'decorators'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'decorators'), 'selected'=>$cat, 'taxonomy' => 'portfolio_category', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<!-- Title -->
            <?php while( have_posts() ): the_post(); ?>
            <li><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php the_title(); ?></a></li>
            <?php endwhile; ?>
                
        <?php endif;
    }
}

/// Our Brochures
class Bunch_Brochures extends WP_Widget
{
	
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Brochures', /* Name */esc_html__('Decorators Our Brochures','decorators'), array( 'description' => esc_html__('Show the info Our Brochures', 'decorators' )) );
	}

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget);?>
      		
            <!--Our Brochures-->
            <div class="downloads">
            	<?php echo wp_kses_post($before_title.$title.$after_title); ?>
                <ul>
                    <li><a href="<?php echo esc_url($instance['pdf']); ?>"><span class="icon fa fa-file-pdf-o"></span> <?php esc_html_e('Download.Pdf', 'decorators'); ?></a></li>
                    <li><a href="<?php echo esc_url($instance['word']); ?>"><span class="icon fa fa-file-word-o"></span> <?php esc_html_e('Download.Doc', 'decorators'); ?></a></li>
                </ul>
            </div>
            
		<?php
		
		echo wp_kses_post($after_widget);
	}
	
	
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = $new_instance['title'];
		$instance['pdf'] = $new_instance['pdf'];
		$instance['word'] = $new_instance['word'];

		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Our Brochures', 'decorators');
		$pdf = ( $instance ) ? esc_attr($instance['pdf']) : '#';
		$word = ($instance) ? esc_attr($instance['word']) : '#';
		?>
        
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('pdf')); ?>"><?php esc_html_e('PDF Link:', 'decorators'); ?></label>
            <input placeholder="<?php esc_html_e('PDF link here', 'decorators');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('pdf')); ?>" name="<?php echo esc_attr($this->get_field_name('pdf')); ?>" type="text" value="<?php echo esc_attr($pdf); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('word')); ?>"><?php esc_html_e('Work Doc Link:', 'decorators'); ?></label>
            <input placeholder="<?php esc_html_e('Word link here', 'decorators');?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('word')); ?>" name="<?php echo esc_attr($this->get_field_name('word')); ?>" type="text" value="<?php echo esc_attr($word); ?>" />
        </p>
                
		<?php 
	}
	
}

/// Testimonials
class Bunch_Testimonials_Sidebar extends WP_Widget
{
	/** constructor */
	function __construct()
	{
		parent::__construct( /* Base ID */'Bunch_Testimonials_Sidebar', /* Name */esc_html__('Decorators Testimonials Sidebar','decorators'), array( 'description' => esc_html__('Show the Testimonials Sidebar', 'decorators' )) );
	}
 

	/** @see WP_Widget::widget */
	function widget($args, $instance)
	{
		extract( $args );
		$title = apply_filters( 'widget_title', $instance['title'] );
		
		echo wp_kses_post($before_widget); ?>
        
        <div class="widget sidebar-widget testimonials">
            <?php echo wp_kses_post($before_title.$title.$after_title); ?>
            <div class="single-item-carousel">
                
                <!--Slide Item-->
                <?php 
				$args = array('post_type' => 'bunch_testimonials', 'showposts'=>$instance['number']);
				if( $instance['cat'] ) $args['tax_query'] = array(array('taxonomy' => 'testimonials_category','field' => 'id','terms' => (array)$instance['cat']));
				query_posts($args); 
					
					$this->posts();
					wp_reset_query();
				?>
                
            </div>
        </div>
		
        <?php echo wp_kses_post($after_widget);
	}
 
 
	/** @see WP_Widget::update */
	function update($new_instance, $old_instance)
	{
		$instance = $old_instance;
		
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = $new_instance['number'];
		$instance['cat'] = $new_instance['cat'];
		
		return $instance;
	}

	/** @see WP_Widget::form */
	function form($instance)
	{
		$title = ( $instance ) ? esc_attr($instance['title']) : esc_html__('Testimonials', 'decorators');
		$number = ( $instance ) ? esc_attr($instance['number']) : 6;
		$cat = ( $instance ) ? esc_attr($instance['cat']) : '';?>
		
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts: ', 'decorators'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo esc_attr( $number ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('cat')); ?>"><?php esc_html_e('Category', 'decorators'); ?></label>
            <?php wp_dropdown_categories( array('show_option_all'=>esc_html__('All Categories', 'decorators'), 'selected'=>$cat, 'taxonomy' => 'portfolio_category', 'class'=>'widefat', 'name'=>$this->get_field_name('cat')) ); ?>
        </p>
            
		<?php 
	}
	
	function posts()
	{
		
		if( have_posts() ):?>
        
           	<!-- Title -->
            <?php while( have_posts() ): the_post();
			$testimonials_meta = _WSH()->get_meta();
			?>
            <?php 
                $post_thumbnail_id = get_post_thumbnail_id($post->ID);
                $post_thumbnail_url = wp_get_attachment_url( $post_thumbnail_id );
            ?>
            <div class="slide-item">
                <div class="upper-content">
                    <div class="text"><?php echo wp_kses_post(decorators_trim(get_the_content(), 150));?></div>
                </div>
                <div class="testi-info">
                    <figure class="author-thumb img-circle"><?php the_post_thumbnail('decorators_75x75', array('class' => 'img-responsive img-circle'));?></figure>
                    <h4><?php the_title(); ?> - <span class="designation"><?php echo wp_kses_post(decorators_set($testimonials_meta, 'designation')); ?></span> </h4>
                </div>
            </div>
            <?php endwhile; ?>
                
        <?php endif;
    }
}
