<?php $options = _WSH()->option();
	decorators_bunch_global_variable();
	$icon_href = (decorators_set( $options, 'site_favicon' )) ? decorators_set( $options, 'site_favicon' ) : get_template_directory_uri().'/images/favicon.ico';
 ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		 <!-- Basic -->
	    <meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
		<!-- Favcon -->
		<?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ):?>
			<link rel="shortcut icon" type="image/png" href="<?php echo esc_url($icon_href);?>">
		<?php endif;?>
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
	
    <div class="page-wrapper<?php if(decorators_set($options, 'boxed')) echo ' boxed';?>">
 	
    <!-- Preloader -->
    <div class="preloader"></div>
 	 
    <!-- Main Header-->
    <header class="main-header">
    	<!-- Header Top -->
        <?php if( decorators_set($options, 'show_topbar') ):?>
    	<div class="header-top">
        	<div class="auto-container">
            	<div class="row clearfix">
                    
                    <!--Top Left-->
                    <div class="top-left pull-left">
                    	<?php if(decorators_set($options, 'lang_switcher')): ?>
                            <div id="polyglotLanguageSwitcher">
                                <?php do_action('wpml_add_language_selector'); ?>
                            </div>
                        <?php endif;?>
                    </div>
                    
                    <!--Top Right-->
                    <div class="top-right pull-right">
                    
                    	<?php if(decorators_set($options, 'show_social_icons')):?>
						<?php if($socials = decorators_set(decorators_set($options, 'social_media'), 'social_media')): //decorators_set_printr($socials);?>
                        <div class="social-icon">
                            <?php foreach($socials as $key => $value):
								if(decorators_set($value, 'tocopy')) continue;
							?>
							<a href="<?php echo esc_url(decorators_set($value, 'social_link'));?>"><span class="fa <?php echo esc_attr(decorators_set($value, 'social_icon'));?>"></span></a>
							<?php endforeach;?>
                        </div>
                        <?php endif;?>
                        <?php endif;?>
                        
                    	<ul>
                        	<?php if(decorators_set($options, 'email')):?><li><span class="fa fa-envelope-o"></span><?php echo sanitize_email(decorators_set($options, 'email'));?></li><?php endif;?>
                            <?php if(decorators_set($options, 'phone')):?><li><span class="fa fa-phone"></span><?php esc_html_e('Toll Free:', 'decorators');?> <?php echo nl2br(wp_kses_post(decorators_set($options, 'phone')));?></li><?php endif;?>
                            <?php if(decorators_set($options, 'opening_hours')):?><li><span class="fa fa-clock-o"></span><?php echo esc_attr(decorators_set($options, 'opening_hours'));?></li><?php endif;?>
                        </ul>
                        
                    </div>
                    
                </div>
                
            </div>
        </div>
        <?php endif;?>
        <!-- Header Top End -->
        
        <!-- Main Box -->
    	<div class="main-box">
        	<div class="auto-container">
            	<div class="outer-container clearfix">
                    <!--Logo Box-->
                    <div class="logo-box">
                        <?php if(decorators_set($options, 'logo_image')):?>
                            <div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(decorators_set($options, 'logo_image'));?>" alt="<?php esc_attr_e('image', 'decorators');?>" title="<?php esc_html_e('Logo', 'decorators');?>"></a></div>
                        <?php else:?>
                            <div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(get_template_directory_uri().'/images/logo.png');?>" alt="<?php esc_html_e('Logo', 'decorators');?>"></a></div>
                        <?php endif;?>
                    </div>
                    
                    <!--Nav Outer-->
                    <div class="nav-outer clearfix">
                        <!-- Main Menu -->
                        <nav class="main-menu">
                            <div class="navbar-header">
                                <!-- Toggle Button -->    	
                                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                <span class="icon-bar"></span>
                                </button>
                            </div>
                            
                            <div class="navbar-collapse collapse clearfix">
                                <ul class="navigation clearfix">
                                    <?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
										'container_class'=>'navbar-collapse collapse navbar-right',
										'menu_class'=>'nav navbar-nav',
										'fallback_cb'=>false, 
										'items_wrap' => '%3$s', 
										'container'=>false,
										'walker'=> new Bunch_Bootstrap_walker()  
									) ); ?>
                                    
                                 </ul>
                            </div>
                        </nav><!-- Main Menu End-->
                        
                    </div><!--Nav Outer End-->
                    
                    <!-- Hidden Nav Toggler -->
                    <div class="nav-toggler">
                    <button class="hidden-bar-opener"><span class="icon fa fa-bars"></span></button>
                    </div><!-- / Hidden Nav Toggler -->
                    
                    <!--Search Btn-->
                    <?php if( function_exists( 'WC' ) ):
   					global $woocommerce; ?>
                    <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="cart-btn-outer"><div class="icon"><span class="flaticon-shopping-bag"></span><span class="count"><?php echo wp_kses_post($woocommerce->cart->get_cart_contents_count()); ?></span></div></a>
                    <?php endif;?>
                    <div class="header-search-icon search-box-btn"><span class="flaticon-search"></span></div>
                    
            	</div>    
            </div>
        </div>
    
    </header>
    <!--End Main Header -->
    
    <!-- Hidden Navigation Bar -->
    <section class="hidden-bar right-align">
        
        <div class="hidden-bar-closer">
            <button class="btn"><i class="fa fa-close"></i></button>
        </div>
        
        <!-- Hidden Bar Wrapper -->
        <div class="hidden-bar-wrapper">
        
            <!-- .logo -->
            <div class="logo text-center">
                <?php if(decorators_set($options, 'logo_image_2')):?>
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(decorators_set($options, 'logo_image_2'));?>" alt="<?php esc_attr_e('image', 'decorators');?>" title="<?php esc_html_e('Ecomanic', 'decorators');?>"></a>
                <?php else:?>
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><img src="<?php echo esc_url(get_template_directory_uri().'/images/logo-2.png');?>" alt="<?php esc_html_e('Ecomanic', 'decorators');?>"></a>
                <?php endif;?>			
            </div><!-- /.logo -->
            
            <!-- .Side-menu -->
            <div class="side-menu">
            <!-- .navigation -->
                <ul class="navigation">
                    <?php wp_nav_menu( array( 'theme_location' => 'main_menu', 'container_id' => 'navbar-collapse-1',
						'container_class'=>'navbar-collapse collapse navbar-right',
						'menu_class'=>'nav navbar-nav',
						'fallback_cb'=>false, 
						'items_wrap' => '%3$s', 
						'container'=>false,
						'walker'=> new Bunch_Bootstrap_walker()  
					) ); ?>
                </ul>
            </div><!-- /.Side-menu -->
        	
			<?php if(decorators_set($options, 'show_social_icons')):?>
            <?php if($socials = decorators_set(decorators_set($options, 'social_media'), 'social_media')): //decorators_set_printr($socials);?>
            <div class="social-icons">
                <ul>
                    <?php foreach($socials as $key => $value):
						if(decorators_set($value, 'tocopy')) continue;
					?>
					<li><a href="<?php echo esc_url(decorators_set($value, 'social_link'));?>"><i class="fa <?php echo esc_attr(decorators_set($value, 'social_icon'));?>"></i></a></li>
					<?php endforeach;?>
                </ul>
            </div>
        	<?php endif;?>
            <?php endif;?>
            
        </div><!-- / Hidden Bar Wrapper -->
    </section>
    <!-- / Hidden Bar -->