<!--News Style One / Boxed-->
<div class="news-style-one boxed">
    <div class="inner-box">
        <?php if ( has_post_thumbnail() ):?>
        <figure class="image-box">
        	<?php the_post_thumbnail('decorators_1170x475');?>
            <a class="overlay-link" href="<?php echo esc_url(get_permalink(get_the_id()));?>">
            <span class="icon flaticon-plus-1"></span>
            </a>
        </figure>
        <?php endif;?>
        <div class="content">
            <h3><a href="<?php echo esc_url(get_permalink(get_the_id()));?>"><?php the_title();?></a></h3>
            <ul class="post-meta clearfix">
                <li><a href="<?php echo esc_url(get_month_link(get_the_date('Y'), get_the_date('m'))); ?>"><span class="icon fa fa-clock-o"></span> <?php the_time('M d, Y'); ?></a></li>
                <?php $like = get_post_meta( get_the_id(), '_jolly_like_it', true ); ?>
                <li><a href="javascript:void(0);" class="jolly_like_it"  data-id="<?php the_ID(); ?>"><span class="icon fa fa-eye"></span> <?php echo (int)$like;?> <?php esc_html_e(' Views', 'decorators');?></a></li>
                <li><a href="<?php echo esc_url(get_permalink(get_the_id()).'#comment');?>"><span class="icon fa fa-comments"></span> <?php comments_number( '0 comment', '1 comment', '% comments' ); ?></a></li>
            </ul>
            <div class="text"><?php the_excerpt();?> </div>
            <div class="author-info">
                <figure class="author-thumb"><?php echo get_avatar( get_the_author_meta(get_the_id()));?></figure>
                <h4><?php the_author();?></h4>
            </div>
        </div>
    </div>
</div>