<?php
$config = concho_kirki_config();

concho_Kirki::add_section( 'dt_site_layout_section', array(
	'title' => esc_html__( 'Site Layout', 'concho' ),
	'priority' => 20
) );

	# site-layout
	concho_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'site-layout',
		'label'    => esc_html__( 'Site Layout', 'concho' ),
		'section'  => 'dt_site_layout_section',
		'default'  => concho_defaults('site-layout'),
		'choices' => array(
			'boxed' =>  CONCHO_THEME_URI.'/kirki/assets/images/site-layout/boxed.png',
			'wide' => CONCHO_THEME_URI.'/kirki/assets/images/site-layout/wide.png',
		)
	));

	# site-boxed-layout
	concho_Kirki::add_field( $config, array(
		'type'     => 'switch',
		'settings' => 'site-boxed-layout',
		'label'    => esc_html__( 'Customize Boxed Layout?', 'concho' ),
		'section'  => 'dt_site_layout_section',
		'default'  => '1',
		'choices'  => array(
			'on'  => esc_attr__( 'Yes', 'concho' ),
			'off' => esc_attr__( 'No', 'concho' )
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
		)			
	));

	# body-bg-type
	concho_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-type',
		'label'    => esc_html__( 'Background Type', 'concho' ),
		'section'  => 'dt_site_layout_section',
		'multiple' => 1,
		'default'  => 'none',
		'choices'  => array(
			'pattern' => esc_attr__( 'Predefined Patterns', 'concho' ),
			'upload' => esc_attr__( 'Set Pattern', 'concho' ),
			'none' => esc_attr__( 'None', 'concho' ),
		),
		'active_callback' => array(
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-pattern
	concho_Kirki::add_field( $config, array(
		'type'     => 'radio-image',
		'settings' => 'body-bg-pattern',
		'label'    => esc_html__( 'Predefined Patterns', 'concho' ),
		'description'    => esc_html__( 'Add Background for body', 'concho' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'choices' => array(
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern1.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern2.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern3.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern4.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern5.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern6.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern7.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern8.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern9.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern10.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern11.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern12.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern13.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern14.jpg',
			CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg'=> CONCHO_THEME_URI.'/kirki/assets/images/site-layout/pattern15.jpg',
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'pattern' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)						
	));

	# body-bg-image
	concho_Kirki::add_field( $config, array(
		'type' => 'image',
		'settings' => 'body-bg-image',
		'label'    => esc_html__( 'Background Image', 'concho' ),
		'description'    => esc_html__( 'Add Background Image for body', 'concho' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-image' )
		),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => '==', 'value' => 'upload' ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-position
	concho_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-position',
		'label'    => esc_html__( 'Background Position', 'concho' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-position' )
		),
		'default' => 'center',
		'multiple' => 1,
		'choices' => concho_image_positions(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload') ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));

	# body-bg-repeat
	concho_Kirki::add_field( $config, array(
		'type' => 'select',
		'settings' => 'body-bg-repeat',
		'label'    => esc_html__( 'Background Repeat', 'concho' ),
		'section'  => 'dt_site_layout_section',
		'output' => array(
			array( 'element' => 'body' , 'property' => 'background-repeat' )
		),
		'default' => 'repeat',
		'multiple' => 1,
		'choices' => concho_image_repeats(),
		'active_callback' => array(
			array( 'setting' => 'body-bg-type', 'operator' => 'contains', 'value' => array( 'pattern', 'upload' ) ),
			array( 'setting' => 'site-layout', 'operator' => '==', 'value' => 'boxed' ),
			array( 'setting' => 'site-boxed-layout', 'operator' => '==', 'value' => '1' )
		)
	));	