<?php
function concho_kirki_config() {
	return 'concho_kirki_config';
}

function concho_defaults( $key = '' ) {
	$defaults = array();

	# site identify
	$defaults['use-custom-logo']    = '1';
	$defaults['custom-logo']        = CONCHO_THEME_URI.'/images/logo.png';
	$defaults['custom-light-logo']  = CONCHO_THEME_URI.'/images/light-logo.png';
	$defaults['site_icon']          = CONCHO_THEME_URI.'/images/favicon.ico';
	$defaults['custom-title-color'] = '#ffffff';

	# site layout
	$defaults['site-layout'] = 'wide';

	# site skin
	$defaults['primary-color']      = '#01cffc';
	$defaults['secondary-color']    = '#b83bfa';
	$defaults['tertiary-color']     = '#9ee4f4';
	$defaults['body-bg-color']      = '#ffffff';
	$defaults['body-content-color'] = '#454545';
	$defaults['body-a-color']       = '#01cffc';
	$defaults['body-a-hover-color'] = '#454545';
	$defaults['footer-content-a-color']       = '#ffffff';
	$defaults['footer-content-a-hover-color'] = '#01cffc';

	# site breadcrumb
	$defaults['customize-breadcrumb-title-typo'] = '1';
	$defaults['breadcrumb-title-typo'] = array( 'font-family' => 'Work Sans',
		'variant' => '500',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '60px',
		'line-height' => '',
		'letter-spacing' => '0.5px',
		'color' => '#f5f5f5',
		'text-align' => 'unset',
		'text-transform' => 'none' );
	$defaults['customize-breadcrumb-typo'] = '0';
	$defaults['breadcrumb-typo'] = array( 'font-family' => 'Open Sans',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '20px',
		'line-height' => '',
		'letter-spacing' => '0',
		'color' => '#333333',
		'text-align' => 'unset',
		'text-transform' => 'none' );

	# site footer
	$defaults['customize-footer-title-typo'] = '1';
	$defaults['footer-title-typo'] = array( 'font-family' => 'Work Sans',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '20px',
		'line-height' => '36px',
		'letter-spacing' => '0',
		'color' => '#ffffff',
		'text-align' => 'left',
		'text-transform' => 'none' );
	$defaults['customize-footer-content-typo'] = '1';
	$defaults['footer-content-typo'] = array( 'font-family' => 'Work Sans',
		'variant' => 'regular',
		'subsets' => array( 'latin-ext' ),
		'font-size' => '14px',
		'line-height' => '24px',
		'letter-spacing' => '0',
		'color' => '#ffffff',
		'text-align' => 'left',
		'text-transform' => 'none' );

	# site typography
	$defaults['customize-body-h1-typo'] = '1';
	$defaults['h1'] = array(
		'font-family' => 'Maven Pro',
		'variant' => 'regular',
		'font-size' => '50px',
		'line-height' => '',
		'letter-spacing' => '0.5px',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h2-typo'] = '1';
	$defaults['h2'] = array(
		'font-family' => 'Maven Pro',
		'variant' => '700',
		'font-size' => '42px',
		'line-height' => '',
		'letter-spacing' => '0.5px',
		'color' => '#2a2a2a',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h3-typo'] = '1';
	$defaults['h3'] = array(
		'font-family' => 'Maven Pro',
		'variant' => '700',
		'font-size' => '32px',
		'line-height' => '',
		'letter-spacing' => '0.5px',
		'color' => '#2a2a2a',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h4-typo'] = '1';
	$defaults['h4'] = array(
		'font-family' => 'Maven Pro',
		'variant' => 'regular',
		'font-size' => '24px',
		'line-height' => '',
		'letter-spacing' => '0.5px',
		'color' => '#2a2a2a',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h5-typo'] = '1';
	$defaults['h5'] = array(
		'font-family' => 'Maven Pro',
		'variant' => 'regular',
		'font-size' => '20px',
		'line-height' => '',
		'letter-spacing' => '0.5px',
		'color' => '#2a2a2a',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-h6-typo'] = '1';
	$defaults['h6'] = array(
		'font-family' => 'Maven Pro',
		'variant' => 'regular',
		'font-size' => '18px',
		'line-height' => '',
		'letter-spacing' => '0.5px',
		'color' => '#000000',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);
	$defaults['customize-body-content-typo'] = '1';
	$defaults['body-content-typo'] = array(
		'font-family' => 'PT Sans',
		'variant' => 'normal',
		'font-size' => '16px',
		'line-height' => '24px',
		'letter-spacing' => '',
		'color' => '#454545',
		'text-align' => 'unset',
		'text-transform' => 'none'
	);

	$defaults['footer-content-a-color'] = '';
	$defaults['footer-content-a-hover-color'] = '';	

	if( !empty( $key ) && array_key_exists( $key, $defaults) ) {
		return $defaults[$key];
	}

	return '';
}

function concho_image_positions() {

	$positions = array( "top left" => esc_attr__('Top Left','concho'),
		"top center"    => esc_attr__('Top Center','concho'),
		"top right"     => esc_attr__('Top Right','concho'),
		"center left"   => esc_attr__('Center Left','concho'),
		"center center" => esc_attr__('Center Center','concho'),
		"center right"  => esc_attr__('Center Right','concho'),
		"bottom left"   => esc_attr__('Bottom Left','concho'),
		"bottom center" => esc_attr__('Bottom Center','concho'),
		"bottom right"  => esc_attr__('Bottom Right','concho'),
	);

	return $positions;
}

function concho_image_repeats() {

	$image_repeats = array( "repeat" => esc_attr__('Repeat','concho'),
		"repeat-x"  => esc_attr__('Repeat in X-axis','concho'),
		"repeat-y"  => esc_attr__('Repeat in Y-axis','concho'),
		"no-repeat" => esc_attr__('No Repeat','concho')
	);

	return $image_repeats;
}

function concho_border_styles() {

	$image_repeats = array(
		"none"	 => esc_attr__('None','concho'),
		"dotted" => esc_attr__('Dotted','concho'),
		"dashed" => esc_attr__('Dashed','concho'),
		"solid"	 => esc_attr__('Solid','concho'),
		"double" => esc_attr__('Double','concho'),
		"groove" => esc_attr__('Groove','concho'),
		"ridge"	 => esc_attr__('Ridge','concho'),
	);

	return $image_repeats;
}

function concho_animations() {

	$animations = array(
		'' 					 => esc_html__('Default','concho'),	
		"bigEntrance"        =>  esc_attr__("bigEntrance",'concho'),
        "bounce"             =>  esc_attr__("bounce",'concho'),
        "bounceIn"           =>  esc_attr__("bounceIn",'concho'),
        "bounceInDown"       =>  esc_attr__("bounceInDown",'concho'),
        "bounceInLeft"       =>  esc_attr__("bounceInLeft",'concho'),
        "bounceInRight"      =>  esc_attr__("bounceInRight",'concho'),
        "bounceInUp"         =>  esc_attr__("bounceInUp",'concho'),
        "bounceOut"          =>  esc_attr__("bounceOut",'concho'),
        "bounceOutDown"      =>  esc_attr__("bounceOutDown",'concho'),
        "bounceOutLeft"      =>  esc_attr__("bounceOutLeft",'concho'),
        "bounceOutRight"     =>  esc_attr__("bounceOutRight",'concho'),
        "bounceOutUp"        =>  esc_attr__("bounceOutUp",'concho'),
        "expandOpen"         =>  esc_attr__("expandOpen",'concho'),
        "expandUp"           =>  esc_attr__("expandUp",'concho'),
        "fadeIn"             =>  esc_attr__("fadeIn",'concho'),
        "fadeInDown"         =>  esc_attr__("fadeInDown",'concho'),
        "fadeInDownBig"      =>  esc_attr__("fadeInDownBig",'concho'),
        "fadeInLeft"         =>  esc_attr__("fadeInLeft",'concho'),
        "fadeInLeftBig"      =>  esc_attr__("fadeInLeftBig",'concho'),
        "fadeInRight"        =>  esc_attr__("fadeInRight",'concho'),
        "fadeInRightBig"     =>  esc_attr__("fadeInRightBig",'concho'),
        "fadeInUp"           =>  esc_attr__("fadeInUp",'concho'),
        "fadeInUpBig"        =>  esc_attr__("fadeInUpBig",'concho'),
        "fadeOut"            =>  esc_attr__("fadeOut",'concho'),
        "fadeOutDownBig"     =>  esc_attr__("fadeOutDownBig",'concho'),
        "fadeOutLeft"        =>  esc_attr__("fadeOutLeft",'concho'),
        "fadeOutLeftBig"     =>  esc_attr__("fadeOutLeftBig",'concho'),
        "fadeOutRight"       =>  esc_attr__("fadeOutRight",'concho'),
        "fadeOutUp"          =>  esc_attr__("fadeOutUp",'concho'),
        "fadeOutUpBig"       =>  esc_attr__("fadeOutUpBig",'concho'),
        "flash"              =>  esc_attr__("flash",'concho'),
        "flip"               =>  esc_attr__("flip",'concho'),
        "flipInX"            =>  esc_attr__("flipInX",'concho'),
        "flipInY"            =>  esc_attr__("flipInY",'concho'),
        "flipOutX"           =>  esc_attr__("flipOutX",'concho'),
        "flipOutY"           =>  esc_attr__("flipOutY",'concho'),
        "floating"           =>  esc_attr__("floating",'concho'),
        "hatch"              =>  esc_attr__("hatch",'concho'),
        "hinge"              =>  esc_attr__("hinge",'concho'),
        "lightSpeedIn"       =>  esc_attr__("lightSpeedIn",'concho'),
        "lightSpeedOut"      =>  esc_attr__("lightSpeedOut",'concho'),
        "pullDown"           =>  esc_attr__("pullDown",'concho'),
        "pullUp"             =>  esc_attr__("pullUp",'concho'),
        "pulse"              =>  esc_attr__("pulse",'concho'),
        "rollIn"             =>  esc_attr__("rollIn",'concho'),
        "rollOut"            =>  esc_attr__("rollOut",'concho'),
        "rotateIn"           =>  esc_attr__("rotateIn",'concho'),
        "rotateInDownLeft"   =>  esc_attr__("rotateInDownLeft",'concho'),
        "rotateInDownRight"  =>  esc_attr__("rotateInDownRight",'concho'),
        "rotateInUpLeft"     =>  esc_attr__("rotateInUpLeft",'concho'),
        "rotateInUpRight"    =>  esc_attr__("rotateInUpRight",'concho'),
        "rotateOut"          =>  esc_attr__("rotateOut",'concho'),
        "rotateOutDownRight" =>  esc_attr__("rotateOutDownRight",'concho'),
        "rotateOutUpLeft"    =>  esc_attr__("rotateOutUpLeft",'concho'),
        "rotateOutUpRight"   =>  esc_attr__("rotateOutUpRight",'concho'),
        "shake"              =>  esc_attr__("shake",'concho'),
        "slideDown"          =>  esc_attr__("slideDown",'concho'),
        "slideExpandUp"      =>  esc_attr__("slideExpandUp",'concho'),
        "slideLeft"          =>  esc_attr__("slideLeft",'concho'),
        "slideRight"         =>  esc_attr__("slideRight",'concho'),
        "slideUp"            =>  esc_attr__("slideUp",'concho'),
        "stretchLeft"        =>  esc_attr__("stretchLeft",'concho'),
        "stretchRight"       =>  esc_attr__("stretchRight",'concho'),
        "swing"              =>  esc_attr__("swing",'concho'),
        "tada"               =>  esc_attr__("tada",'concho'),
        "tossing"            =>  esc_attr__("tossing",'concho'),
        "wobble"             =>  esc_attr__("wobble",'concho'),
        "fadeOutDown"        =>  esc_attr__("fadeOutDown",'concho'),
        "fadeOutRightBig"    =>  esc_attr__("fadeOutRightBig",'concho'),
        "rotateOutDownLeft"  =>  esc_attr__("rotateOutDownLeft",'concho')
    );

	return $animations;
}

function concho_custom_fonts( $standard_fonts ){

	$custom_fonts = array();

	$fonts = cs_get_option('custom_font_fields');
	if( count( $fonts ) > 0 ):
		foreach( $fonts as $font ):
			$custom_fonts[$font['custom_font_name']] = array(
				'label' => $font['custom_font_name'],
				'variants' => array( '100', '100italic', '200', '200italic', '300', '300italic', 'regular', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic' ),
				'stack' => $font['custom_font_name'] . ', sans-serif'
			);
		endforeach;
	endif;

	return array_merge_recursive( $custom_fonts, $standard_fonts );
}
add_filter( 'kirki/fonts/standard_fonts', 'concho_custom_fonts', 20 );