<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$settings           = array(
  'menu_title'      => constant('CONCHO_THEME_NAME').' '.esc_html__('Options', 'concho'),
  'menu_type'       => 'theme', // menu, submenu, options, theme, etc.
  'menu_slug'       => 'cs-framework',
  'ajax_save'       => true,
  'show_reset_all'  => false,
  'framework_title' => constant('CONCHO_THEME_NAME').' '.esc_html__('Admin Panel', 'concho'),
);

// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// FRAMEWORK OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options        = array();

$options[]      = array(
  'name'        => 'general',
  'title'       => esc_html__('General', 'concho'),
  'icon'        => 'fa fa-gears',

  'fields'      => array(

	array(
	  'type'    => 'subheading',
	  'content' => esc_html__( 'General Options', 'concho' ),
	),
	
	array(
		'id'	=> 'header',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Header', 'concho'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_headers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Header', 'concho'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select default header.','concho'),
	),
	
	array(
		'id'	=> 'footer',
		'type'	=> 'select',
		'title'	=> esc_html__('Site Footer', 'concho'),
		'class'	=> 'chosen',
		'options'	=> 'posts',
		'query_args'	=> array(
			'post_type'	=> 'dt_footers',
			'orderby'	=> 'title',
			'order'	=> 'ASC',
			'posts_per_page' => -1
		),
		'default_option'	=> esc_attr__('Select Footer', 'concho'),
		'attributes'	=> array ( 'style'	=> 'width:50%'),
		'info'	=> esc_html__('Select defaultfooter.','concho'),
	),

	array(
	  'id'  	 => 'use-site-loader',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Site Loader', 'concho'),
	  'info'	 => esc_html__('YES! to use site loader.', 'concho'),
	  'default'  => true,
	),	

	array(
	  'id'  	 => 'enable-stylepicker',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Style Picker', 'concho'),
	  'info'	 => esc_html__('YES! to show the style picker.', 'concho'),
	  'default'  => false,	  
	),		

	array(
	  'id'  	 => 'show-pagecomments',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Globally Show Page Comments', 'concho'),
	  'info'	 => esc_html__('YES! to show comments on all the pages. This will globally override your "Allow comments" option under your page "Discussion" settings.', 'concho'),
	  'default'  => false,
	),

	array(
	  'id'  	 => 'showall-pagination',
	  'type'  	 => 'switcher',
	  'title' 	 => esc_html__('Show all pages in Pagination', 'concho'),
	  'info'	 => esc_html__('YES! to show all the pages instead of dots near the current page.', 'concho'),
	  'default'  => false,
	),



	array(
	  'id'      => 'google-map-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Google Map API Key', 'concho'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid google account api key here', 'concho').'</p>',
	),

	array(
	  'id'      => 'mailchimp-key',
	  'type'    => 'text',
	  'title'   => esc_html__('Mailchimp API Key', 'concho'),
	  'after' 	=> '<p class="cs-text-info">'.esc_html__('Put a valid mailchimp account api key here', 'concho').'</p>',
	),

  ),
);

$options[]      = array(
  'name'        => 'layout_options',
  'title'       => esc_html__('Layout Options', 'concho'),
  'icon'        => 'dashicons dashicons-exerpt-view',
  'sections' => array(

	// -----------------------------------------
	// Header Options
	// -----------------------------------------
	array(
	  'name'      => 'breadcrumb_options',
	  'title'     => esc_html__('Breadcrumb Options', 'concho'),
	  'icon'      => 'fa fa-sitemap',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Breadcrumb Options", 'concho' ),
		  ),

		  array(
			'id'  		 => 'show-breadcrumb',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Breadcrumb', 'concho'),
			'info'		 => esc_html__('YES! to display breadcrumb for all pages.', 'concho'),
			'default' 	 => true,
		  ),

		  array(
			'id'           => 'breadcrumb-delimiter',
			'type'         => 'icon',
			'title'        => esc_html__('Breadcrumb Delimiter', 'concho'),
			'info'         => esc_html__('Choose delimiter style to display on breadcrumb section.', 'concho'),
		  ),

		  array(
			'id'           => 'breadcrumb-style',
			'type'         => 'select',
			'title'        => esc_html__('Breadcrumb Style', 'concho'),
			'options'      => array(
			  'default' 							=> esc_html__('Default', 'concho'),
			  'aligncenter'    						=> esc_html__('Align Center', 'concho'),
			  'alignright'  						=> esc_html__('Align Right', 'concho'),
			  'breadcrumb-left'    					=> esc_html__('Left Side Breadcrumb', 'concho'),
			  'breadcrumb-right'     				=> esc_html__('Right Side Breadcrumb', 'concho'),
			  'breadcrumb-top-right-title-center'  	=> esc_html__('Top Right Title Center', 'concho'),
			  'breadcrumb-top-left-title-center'  	=> esc_html__('Top Left Title Center', 'concho'),
			),
			'class'        => 'chosen',
			'default'      => 'default',
			'info'         => esc_html__('Choose alignment style to display on breadcrumb section.', 'concho'),
		  ),

		  array(
			  'id'                 => 'breadcrumb-position',
			  'type'               => 'select',
			  'title'              => esc_html__('Position', 'concho' ),
			  'options'            => array(
				  'header-top-absolute'    => esc_html__('Behind the Header','concho'),
				  'header-top-relative'    => esc_html__('Default','concho'),
			  ),
			  'class'        => 'chosen',
			  'default'      => 'header-top-relative',
			  'info'         => esc_html__('Choose position of breadcrumb section.', 'concho'),
		  ),

		  array(
			'id'    => 'breadcrumb_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'concho'),
			'desc'  => esc_html__('Choose background options for breadcrumb title section.', 'concho')
		  ),

		),
	),

  ),
);

$options[]      = array(
  'name'        => 'allpage_options',
  'title'       => esc_html__('All Page Options', 'concho'),
  'icon'        => 'fa fa-files-o',
  'sections' => array(

	// -----------------------------------------
	// Post Options
	// -----------------------------------------
	array(
	  'name'      => 'post_options',
	  'title'     => esc_html__('Post Options', 'concho'),
	  'icon'      => 'fa fa-file',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Single Post Options", 'concho' ),
		  ),
		
		  array(
			'id'      => 'single-post-authorbox',
			'type'    => 'switcher',
			'title'   => esc_html__('Single Author Box', 'concho'),
			'info'    => esc_html__('YES! to display author box in single blog posts.', 'concho'),
			'default' => false,
		  ),

		  array(
			'id'      => 'single-post-related',
			'type'    => 'switcher',
			'title'   => esc_html__('Single Related Posts', 'concho'),
			'info'    => esc_html__('YES! to display related blog posts in single posts.', 'concho'),
			'default' => false,
		  ),

		  array(
			'id'  		 => 'single-post-navigation',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Single Post Navigation', 'concho'),
			'info'		 => esc_html__('YES! to display post navigation in single posts.', 'concho')
		  ),

		  array(
			'id'  		 => 'single-post-comments',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Posts Comments', 'concho'),
			'info'		 => esc_html__('YES! to display single blog post comments.', 'concho'),
			'default' 	 => true,
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Post Archives Page Layout", 'concho' ),
		  ),

		  array(
			'id'      	 => 'post-archives-page-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Page Layout', 'concho'),
			'options'    => array(
			  'content-full-width'   => CONCHO_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => CONCHO_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'post-archives-page-layout',
			),
		  ),

		  array(
			'id'         => 'show-standard-left-sidebar-for-post-archives',
			'type'       => 'switcher',
			'title'      => esc_html__('Show Standard Left Sidebar', 'concho'),
			'dependency' => array( 'post-archives-page-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
			'default'    => false,
		  ),

		  array(
			'id'  		 => 'show-standard-right-sidebar-for-post-archives',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Show Standard Right Sidebar', 'concho'),
			'dependency' => array( 'post-archives-page-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
			'default'    => false,
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Post Archives Post Layout", 'concho' ),
		  ),

		  array(
			'id'      	   => 'post-archives-post-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Post Layout', 'concho'),
			'options'      => array(
			  'one-column' 		  => CONCHO_THEME_URI . '/cs-framework-override/images/one-column.png',
			  'one-half-column'   => CONCHO_THEME_URI . '/cs-framework-override/images/one-half-column.png',
			  'one-third-column'  => CONCHO_THEME_URI . '/cs-framework-override/images/one-third-column.png',
			  '1-2-2'			  => CONCHO_THEME_URI . '/cs-framework-override/images/1-2-2.png',
			  '1-2-2-1-2-2' 	  => CONCHO_THEME_URI . '/cs-framework-override/images/1-2-2-1-2-2.png',
			  '1-3-3-3'			  => CONCHO_THEME_URI . '/cs-framework-override/images/1-3-3-3.png',
			  '1-3-3-3-1' 		  => CONCHO_THEME_URI . '/cs-framework-override/images/1-3-3-3-1.png',
			),
			'default'      => 'one-half-column',
		  ),

		  array(
			'id'           => 'post-style',
			'type'         => 'select',
			'title'        => esc_html__('Post Style', 'concho'),
			'options'      => array(
			  'blog-default-style' 		=> esc_html__('Default', 'concho'),
			  'entry-date-left'      	=> esc_html__('Date Left', 'concho'),
			  'entry-date-left outer-frame-border'      	=> esc_html__('Date Left Modern', 'concho'),
			  'entry-date-author-left'  => esc_html__('Date and Author Left', 'concho'),
			  'blog-modern-style'       => esc_html__('Modern', 'concho'),
			  'bordered'      			=> esc_html__('Bordered', 'concho'),
			  'classic'      			=> esc_html__('Classic', 'concho'),
			  'entry-overlay-style' 	=> esc_html__('Trendy', 'concho'),
			  'overlap' 				=> esc_html__('Overlap', 'concho'),
			  'entry-center-align'		=> esc_html__('Stripe', 'concho'),
			  'entry-fashion-style'	 	=> esc_html__('Fashion', 'concho'),
			  'entry-minimal-bordered' 	=> esc_html__('Minimal Bordered', 'concho'),
			  'blog-medium-style'       => esc_html__('Medium', 'concho'),
			  'blog-medium-style dt-blog-medium-highlight'     					 => esc_html__('Medium Hightlight', 'concho'),
			  'blog-medium-style dt-blog-medium-highlight dt-sc-skin-highlight'  => esc_html__('Medium Skin Highlight', 'concho'),
			),
			'class'        => 'chosen',
			'default'      => 'blog-default-style',
			'info'         => esc_html__('Choose post style to display post archives pages.', 'concho'),
		  ),

		  array(
			'id'  		 => 'post-archives-enable-excerpt',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Allow Excerpt', 'concho'),
			'info'		 => esc_html__('YES! to allow excerpt', 'concho'),
			'default'    => true,
		  ),

		  array(
			'id'  		 => 'post-archives-excerpt',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Excerpt Length', 'concho'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Put Excerpt Length', 'concho').'</span>',
			'default' 	 => 40,
		  ),

		  array(
			'id'  		 => 'post-archives-enable-readmore',
			'type'  	 => 'switcher',
			'title' 	 => esc_html__('Read More', 'concho'),
			'info'		 => esc_html__('YES! to enable read more button', 'concho'),
			'default'	 => true,
		  ),

		  array(
			'id'  		 => 'post-archives-readmore',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Read More Shortcode', 'concho'),
			'info'		 => esc_html__('Paste any button shortcode here', 'concho'),
			'default'	 => '[dt_sc_button title="'.esc_attr__('Read More','concho').'" size="medium" class="default"]',
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Single Post & Post Archive options", 'concho' ),
		  ),

		  array(
			'id'      => 'post-format-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Post Format Meta', 'concho' ),
			'info'	  => esc_html__('YES! to show post format meta information', 'concho'),
			'default' => false
		  ),

		  array(
			'id'      => 'post-author-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Author Meta', 'concho' ),
			'info'	  => esc_html__('YES! to show post author meta information', 'concho'),
			'default' => false
		  ),

		  array(
			'id'      => 'post-date-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Date Meta', 'concho' ),
			'info'	  => esc_html__('YES! to show post date meta information', 'concho'),
			'default' => true
		  ),

		  array(
			'id'      => 'post-comment-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Comment Meta', 'concho' ),
			'info'	  => esc_html__('YES! to show post comment meta information', 'concho'),
			'default' => false
		  ),

		  array(
			'id'      => 'post-category-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Category Meta', 'concho' ),
			'info'	  => esc_html__('YES! to show post category information', 'concho'),
			'default' => false
		  ),

		  array(
			'id'      => 'post-tag-meta',
			'type'    => 'switcher',
			'title'   => esc_html__('Tag Meta', 'concho' ),
			'info'	  => esc_html__('YES! to show post tag information', 'concho'),
			'default' => false
		  ),

		),
	),

	// -----------------------------------------
	// 404 Options
	// -----------------------------------------
	array(
	  'name'      => '404_options',
	  'title'     => esc_html__('404 Options', 'concho'),
	  'icon'      => 'fa fa-warning',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "404 Message", 'concho' ),
		  ),
		  
		  array(
			'id'      => 'enable-404message',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Message', 'concho' ),
			'info'	  => esc_html__('YES! to enable not-found page message.', 'concho'),
			'default' => true
		  ),

		  array(
			'id'           => 'notfound-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'concho'),
			'options'      => array(
			  'type1' 	   => esc_html__('Modern', 'concho'),
			  'type2'      => esc_html__('Classic', 'concho'),
			  'type4'  	   => esc_html__('Diamond', 'concho'),
			  'type5'      => esc_html__('Shadow', 'concho'),
			  'type6'      => esc_html__('Diamond Alt', 'concho'),
			  'type7'  	   => esc_html__('Stack', 'concho'),
			  'type8'  	   => esc_html__('Minimal', 'concho'),
			),
			'class'        => 'chosen',
			'default'      => 'type6',
			'info'         => esc_html__('Choose the style of not-found template page.', 'concho')
		  ),

		  array(
			'id'      => 'notfound-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('404 Dark BG', 'concho' ),
			'info'    => esc_html__('YES! to use dark bg notfound page for this site.', 'concho'),
			'default' => false,
		  ),

		  array(
			'id'           => 'notfound-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'concho'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'concho'),
			'info'       	 => esc_html__('Choose the page for not-found content.', 'concho')
		  ),
		  
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Background Options", 'concho' ),
		  ),

		  array(
			'id'    => 'notfound_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'concho')
		  ),

		  array(
			'id'  		 => 'notfound-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'concho'),
			'info'		 => esc_html__('Paste custom CSS styles for not found page.', 'concho')
		  ),

		),
	),

	// -----------------------------------------
	// Underconstruction Options
	// -----------------------------------------
	array(
	  'name'      => 'comingsoon_options',
	  'title'     => esc_html__('Under Construction Options', 'concho'),
	  'icon'      => 'fa fa-thumbs-down',

		'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Under Construction", 'concho' ),
		  ),
	
		  array(
			'id'      => 'enable-comingsoon',
			'type'    => 'switcher',
			'title'   => esc_html__('Enable Coming Soon', 'concho' ),
			'info'	  => esc_html__('YES! to check under construction page of your website.', 'concho'),
			'default' => false
		  ),
	
		  array(
			'id'           => 'comingsoon-style',
			'type'         => 'select',
			'title'        => esc_html__('Template Style', 'concho'),
			'options'      => array(
			  'type1' 	   => esc_html__('Diamond', 'concho'),
			  'type2'      => esc_html__('Teaser', 'concho'),
			  'type3'  	   => esc_html__('Minimal', 'concho'),
			  'type4'      => esc_html__('Counter Only', 'concho'),
			  'type5'      => esc_html__('Belt', 'concho'),
			  'type6'  	   => esc_html__('Classic', 'concho'),
			  'type7'  	   => esc_html__('Boxed', 'concho')
			),
			'class'        => 'chosen',
			'default'      => 'type1',
			'info'         => esc_html__('Choose the style of coming soon template.', 'concho'),
		  ),

		  array(
			'id'      => 'uc-darkbg',
			'type'    => 'switcher',
			'title'   => esc_html__('Coming Soon Dark BG', 'concho' ),
			'info'	  => esc_html__('YES! to use dark bg coming soon page for this site.', 'concho'),
			'default' => false,
		  ),

		  array(
			'id'           => 'comingsoon-pageid',
			'type'         => 'select',
			'title'        => esc_html__('Custom Page', 'concho'),
			'options'      => 'pages',
			'class'        => 'chosen',
			'default_option' => esc_html__('Choose the page', 'concho'),
			'info'       	 => esc_html__('Choose the page for comingsoon content.', 'concho')
		  ),

		  array(
			'id'      => 'show-launchdate',
			'type'    => 'switcher',
			'title'   => esc_html__('Show Launch Date', 'concho' ),
			'info'	  => esc_html__('YES! to show launch date text.', 'concho'),
			'default' => false,			
		  ),

		  array(
			'id'      => 'comingsoon-launchdate',
			'type'    => 'text',
			'title'   => esc_html__('Launch Date', 'concho'),
			'attributes' => array( 
			  'placeholder' => '10/30/2016 12:00:00'
			),
			'after' 	=> '<p class="cs-text-info">'.esc_html__('Put Format: 12/30/2016 12:00:00 month/day/year hour:minute:second', 'concho').'</p>',
		  ),

		  array(
			'id'           => 'comingsoon-timezone',
			'type'         => 'select',
			'title'        => esc_html__('UTC Timezone', 'concho'),
			'options'      => array(
			  '-12' => '-12', '-11' => '-11', '-10' => '-10', '-9' => '-9', '-8' => '-8', '-7' => '-7', '-6' => '-6', '-5' => '-5', 
			  '-4' => '-4', '-3' => '-3', '-2' => '-2', '-1' => '-1', '0' => '0', '+1' => '+1', '+2' => '+2', '+3' => '+3', '+4' => '+4',
			  '+5' => '+5', '+6' => '+6', '+7' => '+7', '+8' => '+8', '+9' => '+9', '+10' => '+10', '+11' => '+11', '+12' => '+12'
			),
			'class'        => 'chosen',
			'default'      => '0',
			'info'         => esc_html__('Choose utc timezone, by default UTC:00:00', 'concho'),
		  ),

		  array(
			'id'    => 'comingsoon_background',
			'type'  => 'background',
			'title' => esc_html__('Background', 'concho')
		  ),

		  array(
			'id'  		 => 'comingsoon-bg-style',
			'type'  	 => 'textarea',
			'title' 	 => esc_html__('Custom Styles', 'concho'),
			'info'		 => esc_html__('Paste custom CSS styles for under construction page.', 'concho'),
		  ),

		),
	),

  ),
);

// -----------------------------------------
// Widget area Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'widgetarea_options',
  'title'       => esc_html__('Widget Area', 'concho'),
  'icon'        => 'fa fa-trello',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Widget Area for Sidebar", 'concho' ),
	  ),

	  array(
		'id'      => 'wtitle-style',
		'type'    => 'select',
		'title'   => esc_html__('Sidebar widget Title Style', 'concho'),
		'options' => array(
			'default' => esc_html__('Choose any type', 'concho'),
			'type1'   => esc_html__('Double Border', 'concho'),
			'type2'   => esc_html__('Tooltip', 'concho'),
			'type3'   => esc_html__('Title Top Border', 'concho'),
			'type4'   => esc_html__('Left Border & Pattren', 'concho'),
			'type5'   => esc_html__('Bottom Border', 'concho'),
			'type6'   => esc_html__('Tooltip Border', 'concho'),
			'type7'   => esc_html__('Boxed Modern', 'concho'),
			'type8'   => esc_html__('Elegant Border', 'concho'),
			'type9'   => esc_html__('Needle', 'concho'),
			'type10'  => esc_html__('Ribbon', 'concho'),
			'type11'  => esc_html__('Content Background', 'concho'),
			'type12'  => esc_html__('Classic BG', 'concho'),
			'type13'  => esc_html__('Tiny Boders', 'concho'),
			'type14'  => esc_html__('BG & Border', 'concho'),
			'type15'  => esc_html__('Classic BG Alt', 'concho'),
			'type16'  => esc_html__('Left Border & BG', 'concho'),
			'type17'  => esc_html__('Basic', 'concho'),
			'type18'  => esc_html__('BG & Pattern', 'concho'),
		),
		'class' => 'chosen',
		'info'  => esc_html__('Choose the style of sidebar widget title.', 'concho')
	  ),

	  array(
		'id'              => 'widgetarea-custom',
		'type'            => 'group',
		'title'           => esc_html__('Custom Widget Area', 'concho'),
		'button_title'    => esc_html__('Add New', 'concho'),
		'accordion_title' => esc_html__('Add New Widget Area', 'concho'),
		'fields'          => array(

		  array(
			'id'          => 'widgetarea-custom-name',
			'type'        => 'text',
			'title'       => esc_html__('Name', 'concho'),
		  ),

		)
	  ),

	),
);

// -----------------------------------------
// Woocommerce Options
// -----------------------------------------
if( function_exists( 'is_woocommerce' ) && ! class_exists ( 'DTWooPlugin' ) ){

	$options[]      = array(
	  'name'        => 'woocommerce_options',
	  'title'       => esc_html__('Woocommerce', 'concho'),
	  'icon'        => 'fa fa-shopping-cart',

	  'fields'      => array(

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Woocommerce Shop Page Options", 'concho' ),
		  ),

		  array(
			'id'  		 => 'shop-product-per-page',
			'type'  	 => 'number',
			'title' 	 => esc_html__('Products Per Page', 'concho'),
			'after'		 => '<span class="cs-text-desc">&nbsp;'.esc_html__('Number of products to show in catalog / shop page', 'concho').'</span>',
			'default' 	 => 12,
		  ),

		  array(
			'id'           => 'product-style',
			'type'         => 'select',
			'title'        => esc_html__('Product Style', 'concho'),
			'options'      => array(
			  'woo-type1' 	   => esc_html__('Thick Border', 'concho'),
			  'woo-type4'      => esc_html__('Diamond Icons', 'concho'),
			  'woo-type8' 	   => esc_html__('Modern', 'concho'),
			  'woo-type10' 	   => esc_html__('Easing', 'concho'),
			  'woo-type11' 	   => esc_html__('Boxed', 'concho'),
			  'woo-type12' 	   => esc_html__('Easing Alt', 'concho'),
			  'woo-type13' 	   => esc_html__('Parallel', 'concho'),
			  'woo-type14' 	   => esc_html__('Pointer', 'concho'),
			  'woo-type16' 	   => esc_html__('Stack', 'concho'),
			  'woo-type17' 	   => esc_html__('Bouncy', 'concho'),
			  'woo-type20' 	   => esc_html__('Masked Circle', 'concho'),
			  'woo-type21' 	   => esc_html__('Classic', 'concho')
			),
			'class'        => 'chosen',
			'default' 	   => 'woo-type1',
			'info'         => esc_html__('Choose products style to display shop & archive pages.', 'concho')
		  ),

		  array(
			'id'      	 => 'shop-page-product-layout',
			'type'       => 'image_select',
			'title'      => esc_html__('Product Layout', 'concho'),
			'options'    => array(
				  1   => CONCHO_THEME_URI . '/cs-framework-override/images/one-column.png',
				  2   => CONCHO_THEME_URI . '/cs-framework-override/images/one-half-column.png',
				  3   => CONCHO_THEME_URI . '/cs-framework-override/images/one-third-column.png',
				  4   => CONCHO_THEME_URI . '/cs-framework-override/images/one-fourth-column.png',
			),
			'default'      => 4,
			'attributes'   => array(
			  'data-depend-id' => 'shop-page-product-layout',
			),
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Detail Page Options", 'concho' ),
		  ),

		  array(
			'id'      	   => 'product-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'concho'),
			'options'      => array(
			  'content-full-width'   => CONCHO_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => CONCHO_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'concho'),
			'dependency'   	 => array( 'product-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'concho'),
			'dependency' 	 => array( 'product-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  		 	 => 'enable-related',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Related Products', 'concho'),
			'info'	  		 => esc_html__("YES! to display related products on single product's page.", 'concho')
		  ),

		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Category Page Options", 'concho' ),
		  ),

		  array(
			'id'      	   => 'product-category-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'concho'),
			'options'      => array(
			  'content-full-width'   => CONCHO_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => CONCHO_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-category-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-category-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'concho'),
			'dependency'   	 => array( 'product-category-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-category-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'concho'),
			'dependency' 	 => array( 'product-category-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),
		  
		  array(
			'type'    => 'subheading',
			'content' => esc_html__( "Product Tag Page Options", 'concho' ),
		  ),

		  array(
			'id'      	   => 'product-tag-layout',
			'type'         => 'image_select',
			'title'        => esc_html__('Layout', 'concho'),
			'options'      => array(
			  'content-full-width'   => CONCHO_THEME_URI . '/cs-framework-override/images/without-sidebar.png',
			  'with-left-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/left-sidebar.png',
			  'with-right-sidebar'   => CONCHO_THEME_URI . '/cs-framework-override/images/right-sidebar.png',
			  'with-both-sidebar'    => CONCHO_THEME_URI . '/cs-framework-override/images/both-sidebar.png',
			),
			'default'      => 'content-full-width',
			'attributes'   => array(
			  'data-depend-id' => 'product-tag-layout',
			),
		  ),

		  array(
			'id'  		 	 => 'show-shop-standard-left-sidebar-for-product-tag-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Left Sidebar', 'concho'),
			'dependency'   	 => array( 'product-tag-layout', 'any', 'with-left-sidebar,with-both-sidebar' ),
		  ),

		  array(
			'id'  			 => 'show-shop-standard-right-sidebar-for-product-tag-layout',
			'type'  		 => 'switcher',
			'title' 		 => esc_html__('Show Shop Standard Right Sidebar', 'concho'),
			'dependency' 	 => array( 'product-tag-layout', 'any', 'with-right-sidebar,with-both-sidebar' ),
		  ),

	  ),
	);
}

// -----------------------------------------
// Sociable Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'sociable_options',
  'title'       => esc_html__('Sociable', 'concho'),
  'icon'        => 'fa fa-share-alt-square',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Sociable", 'concho' ),
	  ),

	  array(
		'id'              => 'sociable_fields',
		'type'            => 'group',
		'title'           => esc_html__('Sociable', 'concho'),
		'info'            => esc_html__('Click button to add type of social & url.', 'concho'),
		'button_title'    => esc_html__('Add New Social', 'concho'),
		'accordion_title' => esc_html__('Adding New Social Field', 'concho'),
		'fields'          => array(
		  array(
			'id'          => 'sociable_fields_type',
			'type'        => 'select',
			'title'       => esc_html__('Select Social', 'concho'),
			'options'      => array(
			  'delicious' 	 => esc_html__('Delicious', 'concho'),
			  'deviantart' 	 => esc_html__('Deviantart', 'concho'),
			  'digg' 	  	 => esc_html__('Digg', 'concho'),
			  'dribbble' 	 => esc_html__('Dribbble', 'concho'),
			  'envelope' 	 => esc_html__('Envelope', 'concho'),
			  'facebook' 	 => esc_html__('Facebook', 'concho'),
			  'flickr' 		 => esc_html__('Flickr', 'concho'),
			  'google-plus'  => esc_html__('Google Plus', 'concho'),
			  'gtalk'  		 => esc_html__('GTalk', 'concho'),
			  'instagram'	 => esc_html__('Instagram', 'concho'),
			  'lastfm'	 	 => esc_html__('Lastfm', 'concho'),
			  'linkedin'	 => esc_html__('Linkedin', 'concho'),
			  'myspace'		 => esc_html__('Myspace', 'concho'),
			  'picasa'		 => esc_html__('Picasa', 'concho'),
			  'pinterest'	 => esc_html__('Pinterest', 'concho'),
			  'reddit'		 => esc_html__('Reddit', 'concho'),
			  'rss'		 	 => esc_html__('RSS', 'concho'),
			  'skype'		 => esc_html__('Skype', 'concho'),
			  'stumbleupon'	 => esc_html__('Stumbleupon', 'concho'),
			  'technorati'	 => esc_html__('Technorati', 'concho'),
			  'tumblr'		 => esc_html__('Tumblr', 'concho'),
			  'twitter'		 => esc_html__('Twitter', 'concho'),
			  'viadeo'		 => esc_html__('Viadeo', 'concho'),
			  'vimeo'		 => esc_html__('Vimeo', 'concho'),
			  'yahoo'		 => esc_html__('Yahoo', 'concho'),
			  'youtube'		 => esc_html__('Youtube', 'concho'),
			),
			'class'        => 'chosen',
			'default'      => 'delicious',
		  ),

		  array(
			'id'          => 'sociable_fields_url',
			'type'        => 'text',
			'title'       => esc_html__('Enter URL', 'concho')
		  ),
		)
	  ),

   ),
);

// -----------------------------------------
// Hook Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'hook_options',
  'title'       => esc_html__('Hooks', 'concho'),
  'icon'        => 'fa fa-paperclip',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Top Hook", 'concho' ),
	  ),

	  array(
		'id'      => 'enable-top-hook',
		'type'    => 'switcher',
		'title'   => esc_html__('Enable Top Hook', 'concho'),
		'info'    => esc_html__("YES! to enable top hook.", 'concho'),
		'default' => false,
	  ),

	  array(
		'id'  		 => 'top-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Top Hook', 'concho'),
		'info'		 => esc_html__('Paste your top hook, Executes after the opening &lt;body&gt; tag.', 'concho')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content Before Hook", 'concho' ),
	  ),

	  array(
		'id'      => 'enable-content-before-hook',
		'type'    => 'switcher',
		'title'   => esc_html__('Enable Content Before Hook', 'concho'),
		'info'    => esc_html__("YES! to enable content before hook.", 'concho'),
		'default' => false,		
	  ),

	  array(
		'id'  		 => 'content-before-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content Before Hook', 'concho'),
		'info'		 => esc_html__('Paste your content before hook, Executes before the opening &lt;#primary&gt; tag.', 'concho')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Content After Hook", 'concho' ),
	  ),

	  array(
		'id'      => 'enable-content-after-hook',
		'type'    => 'switcher',
		'title'   => esc_html__('Enable Content After Hook', 'concho'),
		'info'    => esc_html__("YES! to enable content after hook.", 'concho'),
		'default' => false,
	  ),

	  array(
		'id'  		 => 'content-after-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Content After Hook', 'concho'),
		'info'		 => esc_html__('Paste your content after hook, Executes after the closing &lt;/#main&gt; tag.', 'concho')
	  ),

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Bottom Hook", 'concho' ),
	  ),

	  array(
		'id'      => 'enable-bottom-hook',
		'type'    => 'switcher',
		'title'   => esc_html__('Enable Bottom Hook', 'concho'),
		'info'    => esc_html__("YES! to enable bottom hook.", 'concho'),
		'default' => false,
	  ),

	  array(
		'id'  		 => 'bottom-hook',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Bottom Hook', 'concho'),
		'info'		 => esc_html__('Paste your bottom hook, Executes after the closing &lt;/body&gt; tag.', 'concho')
	  ),

	  array(
		'id'  	=> 'enable-analytics-code',
		'type'  => 'switcher',
		'title' => esc_html__('Enable Tracking Code', 'concho'),
		'info'	=> esc_html__("YES! to enable site tracking code.", 'concho')
	  ),

	  array(
		'id'  		 => 'analytics-code',
		'type'  	 => 'textarea',
		'title' 	 => esc_html__('Google Analytics Tracking Code', 'concho'),
		'dependency' => array( 'enable-analytics-code', '==', 'true' ),
		'info'		 => esc_html__('Enter your Google tracking id (UA-XXXXX-X) here. If you want to offer your visitors the option to stop being tracked you can place the shortcode [dt_sc_privacy_google_tracking] somewhere on your site', 'concho')
	  ),


   ),
);

// -----------------------------------------
// Custom Font Options
// -----------------------------------------
$options[]      = array(
  'name'        => 'font_options',
  'title'       => esc_html__('Custom Fonts', 'concho'),
  'icon'        => 'fa fa-font',

  'fields'      => array(

	  array(
		'type'    => 'subheading',
		'content' => esc_html__( "Custom Fonts", 'concho' ),
	  ),

	  array(
		'id'              => 'custom_font_fields',
		'type'            => 'group',
		'title'           => esc_html__('Custom Font', 'concho'),
		'info'            => esc_html__('Click button to add font name & urls.', 'concho'),
		'button_title'    => esc_html__('Add New Font', 'concho'),
		'accordion_title' => esc_html__('Adding New Font Field', 'concho'),
		'fields'          => array(
		  array(
			'id'          => 'custom_font_name',
			'type'        => 'text',
			'title'       => esc_html__('Font Name', 'concho')
		  ),

		  array(
			'id'      => 'custom_font_woof',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff)', 'concho'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff) file here.', 'concho').'</p>',
		  ),

		  array(
			'id'      => 'custom_font_woof2',
			'type'    => 'upload',
			'title'   => esc_html__('Upload File (*.woff2)', 'concho'),
			'after'   => '<p class="cs-text-muted">'.esc_html__('You can upload custom font family (*.woff2) file here.', 'concho').'</p>',
		  )
		)
	  ),

   ),
);

// ------------------------------
// backup                       
// ------------------------------
$options[]   = array(
  'name'     => 'backup_section',
  'title'    => esc_html__('Backup', 'concho'),
  'icon'     => 'fa fa-shield',
  'fields'   => array(

    array(
      'type'    => 'notice',
      'class'   => 'warning',
      'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'concho')
    ),

    array(
      'type'    => 'backup',
    ),

  )
);

// ------------------------------
// license
// ------------------------------
$options[]   = array(
  'name'     => 'theme_version',
  'title'    => constant('CONCHO_THEME_NAME').esc_html__(' Log', 'concho'),
  'icon'     => 'fa fa-info-circle',
  'fields'   => array(

    array(
      'type'    => 'heading',
      'content' => constant('CONCHO_THEME_NAME').esc_html__(' Theme Change Log', 'concho')
    ),
    array(
      'type'    => 'content',
      'content' => '<pre>

2020.02.01 - version 1.3

* Compatible with wordpress 5.3
* Updated: All premium plugins
* Updated: All wordpress theme standards
* Updated: Privacy and Cookies concept

* Fixed: Privacy Button Issue

* Improved: Revisions options added for all custom posts
      
2019.11.13 - version 1.2
* Compatible with wordpress 5.2.4
* Updated: All premium plugins
* Updated: Revisions added to all custom post types
* Updated: Gutenberg editor support for custom post types
* Updated: Link for phone number module
* Updated: Online documentation link, check readme file

* Fixed: Customizer logo option
* Fixed: Google Analytics issue
* Fixed: Mailchimp email client issue
* Fixed: Gutenberg check for old wordpress version
* Fixed: Edit with Visual Composer for portfolio
* Fixed: Header & Footer wpml option
* Fixed: Smooth scrolling in ie 11
* Fixed: Site title color
* Fixed: Privacy popup bg color

* Improved: Single product breadcrumb section
* Improved: Tags taxonomy added for portfolio
* Improved: Woocommerce cart module added with custom class option

* New: Whatsapp Shortcode</pre>
<pre>
2019.03.28 - version 1.1
 * Updated with Optimized Demo Content	  
</pre>
<pre>
2019.03.27 - version 1.0
 * First release!
</pre>',
    ),

  )
);

// ------------------------------
// Seperator
// ------------------------------
$options[] = array(
  'name'   => 'seperator_1',
  'title'  => esc_html__('Plugin Options', 'concho'),
  'icon'   => 'fa fa-plug'
);


CSFramework::instance( $settings, $options );