<?php
/*==============================================================================
/ Related Blog Shortcodes
==============================================================================*/
function bespoke_related_blog($atts){
    /*[related-blog title="Related Post" num="1"]*/
    $html = '';
    
    extract(shortcode_atts(array(
        'title'                 => 'Related Post',
        'num'                   => 1,
        
    ), $atts));
    
    global $post;
    $postid = $post->ID;
    
    if($postid == ''){
        return $html;
    }
    
    $tags = wp_get_post_tags($postid);
    $tag_ids = array();
    foreach($tags as $individual_tag) { $tag_ids[] = $individual_tag->term_id; }
    $argsa = array(
        'tag__in'           => $tag_ids,
        'post__not_in'      => array($postid),
        'posts_per_page'    => $num,
        'ignore_sticky_posts'  => 1
    );
    
    $related = new WP_Query($argsa);
    if($related->have_posts()){
        $html .='<div class="relatedProduct">
            <h3 class="relatedTitle poppins">'.esc_html($title).'</h3>';
            while($related->have_posts()){
                $related->the_post();
                $authorsURL = get_author_posts_url(get_the_author_meta('ID'));
                $terms = get_the_terms(get_the_ID(), 'category');
                $cates = '';
                if(is_array($terms))
                {
                    $c = 1;
                    foreach ( $terms as $term ) 
                    {
                        if(count($terms) == $c)
                        {
                            $cates .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                        }
                        else
                        {
                            $cates .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a> . ';
                        }
                        $c++;
                    }
                }
                $html .='<div class="relatedPost">
                    <div class="journalImgRela">';
                        if(has_post_thumbnail()):
                            $html .= get_the_post_thumbnail(get_the_ID(), 'bespoke_blog_related');
                        else:
                            $html .='<img src="http://placehold.it/370x300" alt="">';
                        endif;
                    $html .='</div>
                    <div class="journalmeta relatedMeta">
                        <a class="jnalDate" href="'.get_the_permalink().'">'.get_the_time('dS M, Y').'</a>'.
                         wp_kses($cates, array('a' => array('href' => array()))).'
                    </div>
                    <div class="j_contentRel">
                        <h3 class="poppins"><a href="'.get_the_permalink().'">'.get_the_title().'</a></h3>
                        <span class="authorName">'.esc_html__('By', 'synergy-creative').' <a href="'.esc_url($authorsURL).'">'.get_the_author().'</a></span>
                    </div>
                </div>';
            }
        $html .='</div>'; 
    }else{
        $html .= '<p>No Related Post Found!</p>';
    }
    wp_reset_postdata();
    
    return $html;
}
add_shortcode('related-blog', 'bespoke_related_blog');