<?php
/**
 * THEME WAR WordPress Framework
 *
 * Copyright (c) 2016, THEME WAR,(http://themewar.com)
 */

add_action( 'init', 'register_portfolio_post_type' );
function register_portfolio_post_type() {
   register_post_type( 'folio',
		array(
			'labels' => array(
				'name'			=> __('Portfolio',"tw"),
				'singular_name' => __('Portfolio',"tw"),
				'add_new'		=> __('Add Portfolio Item',"tw"),
				'add_new_item'	=> __('Add Portfolio Item',"tw"),
				'edit_item'		=> __('Edit Portfolio Item',"tw"),
				'new_item'		=> __('New Portfolio Item',"tw"),
				'not_found'		=> __('No Portfolio Item found',"tw"),
				'not_found_in_trash' => __('No Portfolio Item found in Trash',"tw"),
				'menu_name'		=> __('Portfolio',"tw"),
			),
			'description' => 'Manipulating with our Portfolio',
			'public' => true,
			'show_in_nav_menus' => true,
			'supports' => array(
				'title',
				'thumbnail',
				'editor',
			),
			'show_ui' => true,
			'show_in_menu' => true,
			'menu_position' => 35,
			'has_archive' => true,
                        'menu_icon' => 'dashicons-portfolio',
			'query_var' => true,
			'rewrite' => array('slug' => 'folio'),
			'capability_type' => 'post',
			'map_meta_cap'=>true
			
		)
	);
	
	add_custom_taxonomies_portfolio();
	flush_rewrite_rules(false);
}
function add_custom_taxonomies_portfolio() {
	register_taxonomy('folio_cat', 'folio', array(
		'hierarchical' => true,
		'labels' => array(
			'name' => _x( 'Portfolio', 'taxonomy general name',"tw" ),
			'singular_name' => _x( 'Portfolio', 'taxonomy singular name' ,"tw"),
			'search_items' =>  __( 'Search Locations' ,"tw"),
			'all_items' => __( 'All Portfolio' ,"tw"),
			'parent_item' => __( 'Parent Location' ,"tw"),
			'parent_item_colon' => __( 'Parent Location:' ,"tw"),
			'edit_item' => __( 'Edit Location' ,"tw"),
			'update_item' => __( 'Update Portfolio' ,"tw"),
			'add_new_item' => __( 'Add New Portfolio' ,"tw"),
			'new_item_name' => __( 'New Portfolio' ,"tw"),
			'menu_name' => __( 'Portfolio Catagory' ,"tw"),
		),
		'rewrite' => array(
			'slug' => 'folio_cat', 
			'with_front' => false, 
			'hierarchical' => true 
		)
		
	));
}