<?php
/*
Plugin Name: Bespoke Assistance
Plugin URI: http://themewar.com
Description: Bespoke assistance. All Custome Post Type generator.
Version: 1.0
Author: Themewar
Author URI: http://themewar.com 
Text Domain: themewar
*/
// ============================================================================================
// Enables theme custom post types, and Shortcodes
// --------------------------------------------------------------------------------------------
global $custom_post_type, $shortcodes;
$custom_post_type = array('portfolio');
$shortcodes = array('releatedblog');


//===================================
// Generate Custom Post type
//===================================
if(isset($custom_post_type) && !empty($custom_post_type))
{
    foreach($custom_post_type as $key => $val)
    {
        $cup_name = $val;
        require plugin_dir_path( __FILE__ ).'custome_post_types/'.$cup_name.'.php';
    }
}

//===================================
// Generate Shortcodes
//===================================
if(isset($shortcodes) && !empty($shortcodes))
{
    foreach($shortcodes as $key => $val)
    {
        $short_name = $val;
        require plugin_dir_path( __FILE__ ).'shortcodes/'.$short_name.'.php';
    }
}

//===================================
// Enqueue Plugin Front JS
//===================================
add_action('wp_enqueue_scripts', 'bespoke_assistance_enqueue_fontend_js', 10);
function bespoke_assistance_enqueue_fontend_js(){
    wp_enqueue_script('bespoke-assistance', plugin_dir_url(__FILE__).'assets/js/bespoke_assistance_js.js', array('jquery'), '', true);
    wp_localize_script( 'bespoke-assistance', 'bespoke_assistance_ajax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
}


/*=================================
// Upvote Post Comments AJAX
======================================= */
add_action( 'wp_ajax_upvote_comment_posts', 'bespoke_assistance_ajax_upvote_comment_posts' );
add_action( 'wp_ajax_nopriv_upvote_comment_posts', 'bespoke_assistance_ajax_upvote_comment_posts' );

/*=================================
// Upvote Post Comments AJAX
======================================= */
function bespoke_assistance_ajax_upvote_comment_posts()
{
    $comentID = $_POST['comentID'];
    $count_key = 'upvotes';
    $count = get_comment_meta( $comentID, $count_key, true );
    if($count == '')
    {
        $count = 1;
        delete_comment_meta( $comentID, $count_key );
        add_comment_meta( $comentID, $count_key, 1 );
    }
    else
    {
        $count += 1;
        update_comment_meta( $comentID, $count_key, $count );
    }
    echo esc_html($count);
    
    die();
}

/*=================================
// Comment Upvote Shortcode
======================================= */
function bespoke_upvote_shortcode($atts){
    extract(
        shortcode_atts(
            array(
                'comment_id' => ''
            ),
            $atts
        )
    );

    $html = '';
    if($comment_id != ''){
        $upvote = (get_comment_meta( $comment_id, 'upvotes', true ) != '') ? get_comment_meta( $comment_id, 'upvotes', true ) : 0;
        $html .= '<a href="'.esc_attr($comment_id).'" class="upvote" id="upv_'. esc_attr($comment_id).'">'.esc_html__('Upvote', 'bespoke').' ('. esc_html($upvote).')</a>';
    }

    return $html;
}

add_shortcode( 'bespoke-comment-upvote', 'bespoke_upvote_shortcode' );


function bespoke_meks_disable_srcset( $sources ) {
    return false;
}
add_filter( 'wp_calculate_image_srcset', 'bespoke_meks_disable_srcset' );



function bespoke_gf_new_urls_generator($font){
    return '@import url(http://fonts.googleapis.com/css?family='.$font.':400,100,300,300italic,400italic,500,500italic,700,700italic,900,900italic); '."\n";
}