<?php
/**
 * The template for displaying all single posts
 */

get_header(); 

$is_author = 1;
$is_single_share = 2;
$posts_sidebar = 3;
$is_sp_navigation = 2;
if(defined('FW')){
    $is_author = fw_get_db_settings_option('is_author', 1);
    $is_single_share = fw_get_db_settings_option('is_single_share', 2);
    $posts_sidebar = fw_get_db_settings_option('posts_sidebar', 3);
    $is_sp_navigation = fw_get_db_settings_option('is_sp_navigation', 2);
}

while(have_posts()): the_post();

$authorurl =  get_author_posts_url(get_the_author_meta('ID'));
$gal = '';

$audio_src = '';
$video_src = '';
$gallery_images = array();
if(defined('FW')){
    $audio_src = fw_get_db_post_option(get_the_ID(), 'audio_src', '');
    $video_src = fw_get_db_post_option(get_the_ID(), 'video_src', '');
    $gallery_images = fw_get_db_post_option(get_the_ID(), 'gallery_images', array());
}

if(get_post_format() == 'gallery' && is_array($gallery_images) && count($gallery_images) > 0){
$i = 1;
foreach($gallery_images as $gals){
    $imgs = $gals['url'];
    if($i == count($gallery_images))
    {
        $gal .= $imgs;
    }
    else
    {
        $gal .= $imgs.',';
    }
    $i++;
}

if(has_post_thumbnail()){
    $imgs = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
    $gal .= ','.$imgs[0];
}
}else{
    if(has_post_thumbnail()){
        $imgs = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
        $gal = $imgs[0];
    }else{
        $gal = '';
    }
}

$terms = get_the_terms(get_the_ID(), 'category');
$cates = '';
if(is_array($terms))
{
    $c = 1;
    foreach ( $terms as $term ) 
    {
        if(count($terms) == $c)
        {
            $cates .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
        }
        else
        {
            $cates .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>, ';
        }
        $c++;
    }
}
$nomberofcomment = get_comments_number(get_the_ID());
?>
<!--BLOG BANNAR START-->
<section class="workDetailHead bdetail">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="wdhContent bdetail">
                    <?php if($is_author == 1): ?>
                    <h6><?php echo esc_html__('By', 'bespoke'); ?> <a href="<?php echo esc_url($authorurl); ?>"><?php echo get_the_author(); ?></a></h6>
                    <?php endif; ?>
                    <h3><?php echo get_the_title(); ?></h3>
                </div>
            </div>
        </div>
    </div>
</section>
<!--BLOG BANNAR END-->
<?php if($gal != ''): ?>
<section class="featcureImage3">
    <div class="wdFeactureImage <?php if($gal != '') {echo 'gallSliders';} ?>" 
         data-galls="<?php echo esc_attr($gal); ?>"></div>
    <?php if(get_post_format() == 'audio' && $audio_src != ''): ?>
        <a href="<?php echo esc_url($audio_src); ?>" class="single_folio_video"><i class="icon-control-play"></i></a>
    <?php elseif(get_post_format() == 'video' && $video_src != ''): ?>
        <a href="<?php echo esc_url($video_src); ?>" class="single_folio_video"><i class="icon-control-play"></i></a>
    <?php endif; ?>
</section>
<?php elseif(get_post_format() == 'audio' && $audio_src != '' && !has_post_thumbnail()): ?>
<div class="iframeWraper">
    <iframe src="<?php echo esc_url($audio_src); ?>"></iframe>
</div>
<?php elseif(get_post_format() == 'video' && $video_src != '' && !has_post_thumbnail()): ?>
<div class="iframeWraper">
    <iframe src="<?php echo esc_url($video_src); ?>"></iframe>
</div>
<?php endif; ?>
<!--BLOG CONTENT START-->
<section <?php post_class('commonSection noPaddingTop') ?>>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="journal_wrap">
                    <div class="row">
                        <div class="col-sm-11">
                            <div class="singleJournal_meta">
                                <a class="jon_date" href="#"><?php echo get_the_time(get_option( 'date_format' )); ?></a>
                                <?php echo wp_kses_post($cates); ?>
                            </div>
                        </div>
                        <?php if(comments_open()): ?>
                        <div class="col-sm-1">
                            <a class="jon_comment" href="#comment"><?php echo esc_html($nomberofcomment); ?></a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php if($posts_sidebar == 1): ?>
            <div class="row">
                <div class="col-lg-4">
                    <div class="sidebar blog_sidebar">
                        <?php dynamic_sidebar('sidebar-1'); ?>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="journal_content">
                        <?php if(has_excerpt()): ?>
                        <h2 class="excerpts">
                            <?php echo get_the_excerpt(); ?>
                        </h2>
                        <?php endif; ?>
                        <div class="journal_content journal_main_content_area clearfix">
                            <?php the_content(); ?>
                            <div class="clearfix"></div>
                            <?php
                                $defaults = array(
                                        'before'           => '<div class="PaginInner"><strong>' . esc_html__( 'Pages:', 'bespoke' ).'</strong>',
                                        'after'            => '</div>',
                                        'link_before'      => '<span>',
                                        'link_after'       => '</span>',
                                        'next_or_number'   => 'number',
                                        'separator'        => ' ',
                                        'nextpagelink'     => __( '<i class="fa fa-angle-right"></i>', 'bespoke'),
                                        'previouspagelink' => __( '<i class="fa fa-angle-left"></i>', 'bespoke' ),
                                        'pagelink'         => '%',
                                        'echo'             => 1
                                );

                                wp_link_pages( $defaults );
                            ?>
                            <div class="clearfix"></div>
                            <?php if(has_tag()): ?>
                                <div class="post_tags text-right">
                                    <?php the_tags( '', ' ', '' ); ?> 
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="row" id="comment">
                                <?php if ($nomberofcomment > 0) : ?>
                                    <div class="col-lg-6">
                                        <?php if($nomberofcomment < 2): ?>
                                            <h3 class="commentTitle poppins"><?php echo esc_html($nomberofcomment) ?> <?php echo esc_html__('Comment', 'bespoke'); ?></h3>
                                        <?php else: ?>
                                            <h3 class="commentTitle poppins"><?php echo esc_html($nomberofcomment) ?> <?php echo esc_html__('Comments', 'bespoke'); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($is_single_share == 1): ?>
                                    <div class="col-lg-6 text-right <?php if ($nomberofcomment < 1){ ?> pull-right <?php } ?>">
                                        <div class="socialShare">
                                            <span><?php echo esc_html__('SHARE', 'bespoke'); ?></span>
                                            <a class="fb" href="http://www.facebook.com/share.php?u=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>"><i class="fa fa-facebook"></i></a>
                                            <a class="tw" href="http://twitter.com/intent/tweet?status=<?php echo get_the_title(); ?>+<?php echo get_the_permalink(); ?>"><i class="fa fa-twitter"></i></a>
                                            <a class="gp" href="https://plus.google.com/share?url=<?php echo get_the_permalink(); ?>"><i class="fa fa-google-plus"></i></a>
                                            <a class="pn" href="http://pinterest.com/pin/create/bookmarklet/?url=<?php echo get_the_permalink(); ?>&is_video=false&description=<?php echo get_the_title(); ?>"><i class="fa fa-pinterest"></i></a>
                                            <a class="ln" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>&source=<?php echo esc_url(home_url('/')); ?>"><i class="fa fa-linkedin"></i></a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="clearfix"></div>
                                <div class="col-lg-12">
                                    <?php
                                        if ( comments_open() || get_comments_number() ) :
                                            comments_template();
                                        endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php elseif($posts_sidebar == 2): ?>
            <div class="row">
                <div class="col-lg-8">
                    <div class="journal_content">
                        <?php if(has_excerpt()): ?>
                        <h2 class="excerpts">
                            <?php echo get_the_excerpt(); ?>
                        </h2>
                        <?php endif; ?>
                        <div class="journal_content clearfix">
                            <?php the_content(); ?>
                            <div class="clearfix"></div>
                            <?php
                                $defaults = array(
                                        'before'           => '<div class="PaginInner"><strong>' . esc_html__( 'Pages:', 'bespoke' ).'</strong>',
                                        'after'            => '</div>',
                                        'link_before'      => '<span>',
                                        'link_after'       => '</span>',
                                        'next_or_number'   => 'number',
                                        'separator'        => ' ',
                                        'nextpagelink'     => __( '<i class="fa fa-angle-right"></i>', 'bespoke'),
                                        'previouspagelink' => __( '<i class="fa fa-angle-left"></i>', 'bespoke' ),
                                        'pagelink'         => '%',
                                        'echo'             => 1
                                );

                                wp_link_pages( $defaults );
                            ?>
                            <div class="clearfix"></div>
                            <?php if(has_tag()): ?>
                                <div class="post_tags text-right">
                                    <?php the_tags( '', ' ', '' ); ?> 
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="row" id="comment">
                                <?php if ($nomberofcomment > 0) : ?>
                                    <div class="col-lg-6">
                                        <?php if($nomberofcomment < 2): ?>
                                            <h3 class="commentTitle poppins"><?php echo esc_html($nomberofcomment) ?> <?php echo esc_html__('Comment', 'bespoke'); ?></h3>
                                        <?php else: ?>
                                            <h3 class="commentTitle poppins"><?php echo esc_html($nomberofcomment) ?> <?php echo esc_html__('Comments', 'bespoke'); ?></h3>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <?php if($is_single_share == 1): ?>
                                    <div class="col-lg-6 text-right <?php if ($nomberofcomment < 1){ ?> pull-right <?php } ?>">
                                        <div class="socialShare">
                                            <span><?php echo esc_html__('SHARE', 'bespoke'); ?></span>
                                            <a class="fb" href="http://www.facebook.com/share.php?u=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>"><i class="fa fa-facebook"></i></a>
                                            <a class="tw" href="http://twitter.com/intent/tweet?status=<?php echo get_the_title(); ?>+<?php echo get_the_permalink(); ?>"><i class="fa fa-twitter"></i></a>
                                            <a class="gp" href="https://plus.google.com/share?url=<?php echo get_the_permalink(); ?>"><i class="fa fa-google-plus"></i></a>
                                            <a class="pn" href="http://pinterest.com/pin/create/bookmarklet/?url=<?php echo get_the_permalink(); ?>&is_video=false&description=<?php echo get_the_title(); ?>"><i class="fa fa-pinterest"></i></a>
                                            <a class="ln" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>&source=<?php echo esc_url(home_url('/')); ?>"><i class="fa fa-linkedin"></i></a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="clearfix"></div>
                                <div class="col-lg-12">
                                    <?php
                                        if ( comments_open() || get_comments_number() ) :
                                            comments_template();
                                        endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="sidebar blog_sidebar">
                        <?php dynamic_sidebar('sidebar-1'); ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="row">
                <div class="col-lg-12">
                    <div class="journal_content">
                        <?php if(has_excerpt()): ?>
                        <h2 class="excerpts">
                            <?php echo get_the_excerpt(); ?>
                        </h2>
                        <?php endif; ?>
                        <div class="journal_content clearfix">
                            <?php the_content(); ?>
                            <div class="clearfix"></div>
                            <?php
                                $defaults = array(
                                        'before'           => '<div class="PaginInner"><strong>' . esc_html__( 'Pages:', 'bespoke' ).'</strong>',
                                        'after'            => '</div>',
                                        'link_before'      => '<span>',
                                        'link_after'       => '</span>',
                                        'next_or_number'   => 'number',
                                        'separator'        => ' ',
                                        'nextpagelink'     => __( '<i class="fa fa-angle-right"></i>', 'bespoke'),
                                        'previouspagelink' => __( '<i class="fa fa-angle-left"></i>', 'bespoke' ),
                                        'pagelink'         => '%',
                                        'echo'             => 1
                                );

                                wp_link_pages( $defaults );
                            ?>
                            <div class="clearfix"></div>
                            <?php if(has_tag()): ?>
                                <div class="post_tags text-right">
                                    <?php the_tags( '', ' ', '' ); ?> 
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <!--<div class="col-lg-8 col-xs-12 pull-right">-->
                <div class="col-lg-12 col-xs-12 pull-right">
                    <div class="row" id="comment">
                        <?php if ($nomberofcomment > 0) : ?>
                            <div class="col-lg-6">
                                 <?php if($nomberofcomment < 2): ?>
                                    <h3 class="commentTitle poppins"><?php echo esc_html($nomberofcomment) ?> <?php echo esc_html__('Comment', 'bespoke'); ?></h3>
                                <?php else: ?>
                                    <h3 class="commentTitle poppins"><?php echo esc_html($nomberofcomment) ?> <?php echo esc_html__('Comments', 'bespoke'); ?></h3>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if($is_single_share == 1): ?>
                            <div class="col-lg-6 text-right <?php if ($nomberofcomment < 1){ ?> pull-right <?php } ?>">
                                <div class="socialShare">
                                    <span><?php echo esc_html__('SHARE', 'bespoke'); ?></span>
                                    <a class="fb" href="http://www.facebook.com/share.php?u=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>"><i class="fa fa-facebook"></i></a>
                                    <a class="tw" href="http://twitter.com/intent/tweet?status=<?php echo get_the_title(); ?>+<?php echo get_the_permalink(); ?>"><i class="fa fa-twitter"></i></a>
                                    <a class="gp" href="https://plus.google.com/share?url=<?php echo get_the_permalink(); ?>"><i class="fa fa-google-plus"></i></a>
                                    <a class="pn" href="http://pinterest.com/pin/create/bookmarklet/?url=<?php echo get_the_permalink(); ?>&is_video=false&description=<?php echo get_the_title(); ?>"><i class="fa fa-pinterest"></i></a>
                                    <a class="ln" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>&source=<?php echo esc_url(home_url('/')); ?>"><i class="fa fa-linkedin"></i></a>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="clearfix"></div>
                        <div class="col-lg-12">
                            <?php
                                if ( comments_open() || get_comments_number() ) :
                                    comments_template();
                                endif;
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>
<!--BLOG CONTENT END-->
<div class="clearfix"></div>
    <?php if($is_sp_navigation == 1): ?>
    <?php
        $prevpost = get_previous_post();
        $nextpost = get_next_post();
    ?>
    <!--NEXT PREV START-->
    <section class="nexprevPagination postNextPrevMenu">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6 noPaddingLeft">
                    <?php if(!empty($prevpost)): ?>
                    <div class="paginationnp">
                        <?php if(has_post_thumbnail($prevpost->ID)): ?>
                            <?php echo get_the_post_thumbnail($prevpost->ID, 'bespoke_folio_pagination'); ?>
                        <?php else: ?>
                            <img src="http://themewar.com/placeholder.php?size=200x120" alt="<?php echo esc_attr(get_the_title($prevpost->ID)); ?>">
                        <?php endif; ?>
                        <h6><a href="<?php echo get_the_permalink($prevpost->ID); ?>"><?php esc_html_e('Previous', 'bespoke'); ?></a></h6>
                        <h1><a href="<?php echo get_the_permalink($prevpost->ID); ?>"><?php echo  (strlen(get_the_title($prevpost->ID)) > 25) ? substr(get_the_title($prevpost->ID), 0, strpos(get_the_title($prevpost->ID), ' ', 25)) : get_the_title($prevpost->ID); ?></a></h1>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-sm-6 noPaddingRight">
                    <?php if(!empty($nextpost)): ?>
                    <div class="paginationnp right">
                        <?php if(has_post_thumbnail($nextpost->ID)): ?>
                            <?php echo get_the_post_thumbnail($nextpost->ID, 'bespoke_folio_pagination'); ?>
                        <?php else: ?>
                            <img src="http://themewar.com/placeholder.php?size=200x120" alt="<?php echo esc_attr(get_the_title($nextpost->ID)); ?>">
                        <?php endif; ?>
                        <h6><a href="<?php echo get_the_permalink($nextpost->ID); ?>"><?php esc_html_e('Next', 'bespoke'); ?></a></h6>
                        <h1><a href="<?php echo get_the_permalink($nextpost->ID); ?>"><?php echo (strlen(get_the_title($nextpost->ID)) > 25 ) ? substr(get_the_title($nextpost->ID), 0, strpos(get_the_title($nextpost->ID), ' ', 25)) : get_the_title($nextpost->ID); ?></a></h1>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <!--NEXT PREV END-->
    <?php endif; ?>
<?php 
endwhile;
get_footer();
