<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 */

get_header(); 

$blog_title = esc_html__('Blog', 'bespoke');
$blog_is_cat = 2;
$blog_style = 2;
if(defined('FW')){
    $blog_title = fw_get_db_settings_option('blog_title', esc_html__('Blog', 'bespoke'));
    $blog_is_cat = fw_get_db_settings_option('blog_is_cat', 2);
    $blog_style = fw_get_db_settings_option('blog_style', 2);
}

?>
<!--BLOG BANNAR START-->
<section class="workDetailHead bdetail">
    <div class="container">
        <div class="row">
            <div class="<?php if($blog_is_cat == 1){?> col-lg-8<?php }else{ ?>col-lg-12<?php } ?>">
                <div class="wdhContent bdetail">
                    <h6><?php esc_html_e('Search Results for', 'bespoke'); ?></h6>
                    <h3><?php echo wp_kses(get_search_query(), array()); ?></h3>
                </div>
            </div>
            <?php if($blog_is_cat == 1): ?>
            <div class="col-sm-4">
                <?php 
                    $categories = get_categories( 
                        array(
                            'orderby'       => 'name',
                            'order'         => 'ASC',
                            'hide_empty'    => 0,
                            'hierarchical'  => FALSE
                        ) 
                    );
                    if(is_array($categories) && count($categories) > 0):
                ?>
                    <div class="blogCat pull-right">
                        <h6><?php echo esc_html__('Categories', 'bespoke'); ?> <i class="fa fa-bars"></i></h6>
                        <ul>
                            <?php 
                                foreach($categories as $cat): 
                                    echo '<li><a href="'.  get_category_link($cat->cat_ID).'">'.$cat->cat_name.'</a></li>';
                                endforeach;
                            ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="clearfix"></div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!--BLOG BANNAR END-->
<!--BLOG CONTENT START-->
<section class="blogContents">
    <div class="container">
        <div class="row">
            <?php if($blog_style == 1): ?>
                <div class="col-lg-4 sidebar">
                    <?php dynamic_sidebar('sidebar-1'); ?>
                </div>
                <div class="col-lg-8">
                    <div class="row">
                        <div class="loopcontents">
                            <?php
                                if(have_posts()):
                                    $posts_per_page = get_option('posts_per_page');
                                    $l = 1;
                                    while(have_posts()): the_post();
                                        if($l % 3 == 0 ):
                                            get_template_part('template-parts/content-2col', get_post_format());
                                        else:
                                            get_template_part('template-parts/content-3col', get_post_format());
                                        endif;
                                    $l++;
                                    endwhile;
                                else:
                                    get_template_part('template-parts/content', 'none');
                                endif;
                            ?>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-lg-12">
                            <?php
                                the_posts_pagination( array(
					'prev_text' => esc_html__('Prev', 'bespoke'),
					'next_text' => esc_html__('Next', 'bespoke'),
					'before_page_number' => '',
				));
                            ?>
                        </div>
                    </div>
                </div>
            <?php elseif($blog_style == 3): ?>
                <div class="loopcontents">
                    <?php
                        if(have_posts()):
                            $posts_per_page = get_option('posts_per_page');
                            $l = 1;
                            while(have_posts()): the_post();
                                if($l == 4 || $l == 9 || $l == 14 || $l == 19 || $l == 24):
                                    get_template_part('template-parts/content-2col', get_post_format());
                                else:
                                    get_template_part('template-parts/content-3col', get_post_format());
                                endif;
                            $l++;
                            endwhile;
                        else:
                            get_template_part('template-parts/content', 'none');
                        endif;
                    ?>
                </div>
                <div class="clearfix"></div>
                <div class="col-lg-12">
                    <?php
                        the_posts_pagination( array(
                                'prev_text' => esc_html__('Prev', 'bespoke'),
                                'next_text' => esc_html__('Next', 'bespoke'),
                                'before_page_number' => '',
                        ) );
                    ?>
                </div>
            <?php else: ?>
                <div class="col-lg-8">
                    <div class="row">
                        <div class="loopcontents">
                            <?php
                                if(have_posts()):
                                    $posts_per_page = get_option('posts_per_page');
                                    $l = 1;
                                    while(have_posts()): the_post();
                                        if($l % 3 == 0 ):
                                            get_template_part('template-parts/content-2col', get_post_format());
                                        else:
                                            get_template_part('template-parts/content-3col', get_post_format());
                                        endif;
                                    $l++;
                                    endwhile;
                                else:
                                    get_template_part('template-parts/content', 'none');
                                endif;
                            ?>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-lg-12">
                            <?php
                                the_posts_pagination( array(
					'prev_text' => esc_html__('Prev', 'bespoke'),
					'next_text' => esc_html__('Next', 'bespoke'),
					'before_page_number' => '',
				) );
                            ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 sidebar">
                    <?php dynamic_sidebar('sidebar-1'); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!--BLOG CONTENT START-->

<?php get_footer();
