<?php
/* 
 * Template Name: Portfolio Listing Page
 */

get_header();
$pf_title = get_the_title();
$pf_title = 2;
$pf_number_of_item = 8;
if(defined('FW')){
    $pf_title = fw_get_db_post_option(get_the_ID(), 'pf_title', get_the_title());
    $pf_is_cat = fw_get_db_post_option(get_the_ID(), 'pf_is_cat', 2);
    $pf_number_of_item = fw_get_db_post_option(get_the_ID(), 'pf_number_of_item', 8);
}
?>
<!--BLOG TITLE START-->
<section class="blogTitleSec">
    <div class="container">
        <div class="row">
            <div class="col-sm-8">
                <div class="blogTitleList">
                    <h2><?php echo esc_html($pf_title); ?></h2>
                </div>
            </div>
            <?php if($pf_is_cat == 1): ?>
            <div class="col-sm-4">
                <?php 
                    $filter_cat = array(
                        'orderby' => 'ID',
                        'order' => 'DESC',
                        'hide_empty' => 1,
                        'hierarchical' => 1,
                        'taxonomy' => 'folio_cat'
                    );
                    $categories = get_categories($filter_cat);
                    if(is_array($categories) && count($categories) > 0):
                ?>
                    <div class="blogCat pull-right">
                        <h6><?php echo esc_html__('Categories', 'bespoke'); ?> <i class="fa fa-bars"></i></h6>
                        <ul>
                            <?php 
                                foreach($categories as $cat): 
                                    echo '<li><a href="'. get_term_link($cat->term_id, 'folio_cat').'">'.$cat->name.'</a></li>';
                                endforeach;
                            ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="clearfix"></div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!--BLOG TITLE END-->
<!--BLOG BANNAR END-->
<section class="blogContents">
    <div class="container">
        <div class="row">
            <?php
                $folios = array(
                    'post_type'             => 'folio',
                    'post_status'           => 'publish',
                    'posts_per_page'        => $pf_number_of_item,
                    'orderby'               => 'date',
                    'order'                 => 'DESC'
                );
                $wp_query = new WP_Query($folios);
                if($wp_query->have_posts()):
                    $arr = array(1, 6, 11, 16, 21, 26, 31, 36, 41, 46);
                    $needle = 1;
                    while($wp_query->have_posts()):
                        $wp_query->the_post();
                        $terms = get_the_terms(get_the_ID(), 'folio_cat');
                        $cats = '';
                        if (is_array($terms) && count($terms) > 0) 
                        {
                            $p = 1;
                            $c = count($terms);
                            foreach ($terms as $term) 
                            {
                                if($p == $c)
                                {
                                    $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>';
                                }
                                else
                                {
                                    $cats .= '<a href="'.  get_category_link($term->term_id).'">'.$term->name.'</a>/';
                                }
                                $p++;
                            }
                        }

                        $folio_is_video = 2;
                        $folio_video = '';
                        if(defined('FW')){
                            $folio_is_video = fw_get_db_post_option(get_the_ID(), 'folio_is_video', 2);
                            $folio_video = fw_get_db_post_option(get_the_ID(), 'folio_video', '');
                        }
                        if(in_array($needle, $arr)):
                            ?>
                            <div class="col-sm-8 noPadding">
                                <div class="single_folio single_folio2">
                                    <a href="<?php echo get_the_permalink(); ?>">
                                        <div class="polioThumb">
                                            <div class="overlayHover"></div>
                                            <?php if(has_post_thumbnail()): ?>
                                                <?php echo get_the_post_thumbnail(get_the_ID(), 'bespoke_folio_fixed'); ?>
                                            <?php else: ?>
                                                <img src="http://placehold.it/1280x803" alt="<?php echo esc_attr(get_the_title()); ?>">
                                            <?php endif; ?>
                                        </div>
                                    </a>
                                    <div class="folio_hover2">
                                            <h3 class="lead color_white semi_Bold"><?php echo get_the_title(); ?></h3>
                                        <div class="workTag">
                                            <?php echo wp_kses_post($cats); ?>
                                        </div>
                                        <a class="work_btn" href="<?php echo get_the_permalink(); ?>"><i class="flaticon-arrows"></i></a>
                                        <?php if($folio_is_video == 1): ?>
                                            <a href="<?php echo esc_url($folio_video); ?>" class="folio_video"><i class="icon-control-play"></i></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        else:
                            ?>
                            <div class="col-sm-4 noPadding">
                                <div class="single_folio single_folio2">
                                    <a href="<?php echo get_the_permalink(); ?>">
                                        <div class="polioThumb">
                                            <div class="overlayHover"></div>
                                            <?php if(has_post_thumbnail()): ?>
                                                <?php echo get_the_post_thumbnail(get_the_ID(), 'bespoke_folio_fixed2'); ?>
                                            <?php else: ?>
                                                <img src="http://placehold.it/640x803" alt="<?php echo esc_attr(get_the_title()); ?>">
                                            <?php endif; ?>
                                        </div>
                                    </a>
                                    <div class="folio_hover2">
                                        <h3 class="lead color_white semi_Bold"><?php echo get_the_title(); ?></h3>
                                        <div class="workTag">
                                            <?php echo wp_kses_post($cats); ?>
                                        </div>
                                        <a class="work_btn" href="<?php echo get_the_permalink(); ?>"><i class="flaticon-arrows"></i></a>
                                        <?php if($folio_is_video == 1): ?>
                                            <a href="<?php echo esc_url($folio_video); ?>" class="folio_video"><i class="icon-control-play"></i></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        endif;
                        
                        if($needle == 2 || $needle == 5 || $needle == 7 || $needle == 10 || $needle == 12 || $needle == 15 || $needle == 17 || $needle == 20 || $needle == 22){
                            echo '<div class="clearfix"></div>';
                        }
                        $needle++;
                    endwhile;
                endif;
            ?>
            <div class="clearfix"></div>
            <div class="col-lg-12">
                <?php
                    the_posts_pagination( array(
                            'prev_text' => esc_html__('Prev', 'bespoke'),
                            'next_text' => esc_html__('Next', 'bespoke'),
                            'before_page_number' => '',
                    ) );
                ?>
            </div>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</section>
<?php
get_footer();