<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_Working_Hours extends WP_Widget {

	/**
	 * @internal
	 */
	public function __construct() {
		$widget_ops = array( 'description' => esc_html__('Sharpshot Working Hourst.', 'bespoke') );
		parent::__construct( false, __( 'ThemeWar Working Hours', 'bespoke' ), $widget_ops );
	}

	/**
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		extract( $args );
		$title = ( $instance['title'] != '' ) ? wp_kses_post( $instance['title'] ) : '';
		$workingdays = ( $instance['workingdays'] != '' ) ? esc_attr( $instance['workingdays'] ) : '';
                $before_widget = str_replace( 'class="', 'class=" ', $before_widget );
		$title         = str_replace( 'class="', 'class=" ',
				$before_title ) . $title . $after_title;

		$filepath = dirname( __FILE__ ).'/views/widget.php';
		if ( file_exists( $filepath ) ) {
			include( $filepath );
		}
	}

	/**
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	/**
	 * @param array $instance
	 *
	 * @return string|void
	 */
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'title' => '', 'workingdays' => '') );
		$title   = esc_attr( $instance['title'] );
		$workingdays   = esc_attr( $instance['workingdays'] );
		?>
		<p>
			<label for="<?php echo wp_kses_post($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title', 'bespoke' ); ?>:</label>
			<input type="text" name="<?php echo wp_kses_post($this->get_field_name( 'title' )); ?>" value="<?php echo wp_kses_post($title); ?>"
			       class="widefat" id="<?php echo wp_kses_post($this->get_field_id( 'title' )); ?>"/>
		</p>
		<p>
			<label for="<?php echo wp_kses_post($this->get_field_id( 'workingdays' )); ?>"><?php esc_html_e( 'Working Days', 'bespoke' ); ?>:</label><br/>
			<textarea name="<?php echo wp_kses_post($this->get_field_name( 'workingdays' )); ?>" class="widefat" id="<?php echo wp_kses_post($this->get_field_id( 'workingdays' )); ?>" ><?php echo wp_kses_post($workingdays); ?></textarea>
                        <small>
                            <?php echo esc_html__('Please use this formate : Monday - Friday = 09:00 - 17:00 | Saturday = 09:00 - 20:00 | Sunday = 10:00 - 15:00 .', 'bespoke') ?>
                        </small>
		</p>
	<?php
	}
}
