<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_Social extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'description' => esc_html__( 'Social profile links.', 'bespoke' ) );

		parent::__construct( false, esc_html__( 'ThemeWar Social', 'bespoke' ), $widget_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );
		$params = array();

		foreach ( $instance as $key => $value ) {
			$params[ $key ] = $value;
		}

		$title = $before_title . $params['widget-title'] . $after_title;
		unset( $params['widget-title'] );

		$filepath = dirname( __FILE__ ) . '/views/widget.php';

		$instance      = $params;
		$before_widget = str_replace( 'class="', 'class="widget_social_links ', $before_widget );

		if ( file_exists( $filepath ) ) {
			include( $filepath );
		}
	}

	function update( $new_instance, $old_instance ) {
		$instance = wp_parse_args( (array) $new_instance, $old_instance );

		return $instance;
	}

	function form( $instance ) {

		$titles = array(
			'widget-title' => esc_html__( 'Social Title:', 'bespoke' ),
			'facebook'     => esc_html__( 'Facebook URL:', 'bespoke' ),
			'twitter'      => esc_html__( 'Twitter URL:', 'bespoke' ),
			'google'       => esc_html__( 'Google URL:', 'bespoke' ),
			'instagram'    => esc_html__( 'Instagram URL:', 'bespoke' ),
			'linkedin'     => esc_html__( 'Linkedin URL:', 'bespoke' ),
			'pinterest'    => esc_html__( 'Pinterest URL:', 'bespoke' ),
			'flickr'    => esc_html__( 'Flickr URL:', 'bespoke' ),
			'tumblr'    => esc_html__( 'Tumblr URL:', 'bespoke' ),
			'dribbble'     => esc_html__( 'Dribbble URL:', 'bespoke' ),
			'youtube'        => esc_html__( 'Youtube URL:', 'bespoke' ),
		);

		$instance = wp_parse_args( (array) $instance, $titles );

		foreach ( $instance as $key => $value ) {
                        $vals = ( $instance[ $key ] === $titles[ $key ] ) ? '' : $instance[ $key ];
			?>
                        <p>
                            <label><?php echo wp_kses_post($titles[ $key ]) ?></label>
				<input class="widefat widget_social_link widget_link_field"
                                       name="<?php echo esc_attr($this->get_field_name( $key )); ?>" type="text"
				       value="<?php echo esc_attr($vals); ?>"/>
			</p>
		<?php
		}
	}
}
