<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_Recent_Work extends WP_Widget {

	/**
	 * @internal
	 */
	public function __construct() {
		$widget_ops = array( 'description' => 'Recent Work.' );
		parent::__construct( false, esc_html__( 'ThemeWar Recent Work', 'bespoke' ), $widget_ops );
	}

	/**
	 * @param array $args
	 * @param array $instance
	 */
	public function widget( $args, $instance ) {
		extract( $args );
                
                $title   = (isset($instance['title']) && $instance['title'] != '') ? $instance['title'] : '';
		$number   = (isset($instance['number']) && $instance['number'] != '') ? $instance['number'] : 3;
		$orderby   = (isset($instance['orderby']) && $instance['orderby'] != '') ? $instance['orderby'] : 'date';
		$order   = (isset($instance['order']) && $instance['order'] != '') ? $instance['order'] : 'DESC';
		$usedin  = (isset($instance['usedin']) && $instance['usedin'] != '') ? $instance['usedin'] : 1;

		$title = $before_title . $title . $after_title;

		
		$before_widget = str_replace( 'class="', 'class="twblogposts ', $before_widget );
                
                echo wp_kses_post($before_widget);
                    echo wp_kses_post($title);
                    
                    $data = array(
                            'post_type'         => array('folio'),
                            'post_status'       => array('publish'),
                            'posts_per_page'    => $number,
                            'orderby'           => $orderby,
                            'order'             => $order
                    );

                    $item = new WP_Query($data);
                    echo '<div class="instaFeed">';
                    if($item->have_posts()):
                        $l = 1;
                        while($item->have_posts()):
                            $item->the_post();
                            ?>
                            <a href="<?php echo get_the_permalink(); ?>">
                                <?php if(has_post_thumbnail()): ?>
                                    <?php echo get_the_post_thumbnail(get_the_ID(), 'bespoke_comment_author'); ?>
                                <?php else: ?>
                                    <img src="http://themewar.com/placeholder.php?size=100x100" alt="<?php echo esc_attr(get_the_title()); ?>">
                                <?php endif; ?>
                            </a>
                            <?php
                        endwhile;
                    else:
                        echo '<div class="alert alert-warning" role="alert">
                                No Data Found!
                              </div>';
                    endif;
                    echo '</div>';
                
                echo wp_kses_post($after_widget);
	}


	/**
	 * @param array $new_instance
	 * @param array $old_instance
	 *
	 * @return array
	 */
	public function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	/**
	 * @param array $instance
	 *
	 * @return string|void
	 */
	public function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'number' => 6, 'title' => '','orderby' => 'date', 'order' => 'DESC') );
		$title   = esc_attr( $instance['title'] );
		$number   = esc_attr( $instance['number'] );
		$orderby   = esc_attr( $instance['orderby'] );
		$order   = esc_attr( $instance['order'] );
		?>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title', 'bespoke' ); ?>
				:</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo wp_kses_post($title); ?>"
			       class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of Blog posts', 'bespoke' ); ?>
				:</label>
			<input type="number" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" value="<?php echo wp_kses_post($number); ?>"
			       class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>"><?php esc_html_e( 'Post Order', 'bespoke' ); ?>
				:</label>
			<select name="<?php echo esc_attr($this->get_field_name( 'orderby' )); ?>"
			       class="widefat" id="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>">
                            <option value="date">Date</option>
                            <option <?php if($orderby == 'ID') { echo 'Selected'; } ?> value="ID"><?php echo esc_html__('ID', 'bespoke') ?></option>
                            <option <?php if($orderby == 'title') { echo 'Selected'; } ?> value="title"><?php echo esc_html__('Title', 'bespoke') ?></option>
                            <option <?php if($orderby == 'comment_count') { echo 'Selected'; } ?> value="comment_count"><?php echo esc_html__('Comment Count', 'bespoke') ?></option>
                            <option <?php if($orderby == 'rand') { echo 'Selected'; } ?> value="rand"><?php echo esc_html__('Random Post', 'bespoke') ?></option>
                        </select>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'order' )); ?>"><?php esc_html_e( 'Order', 'bespoke' ); ?>
				:</label>
			<select name="<?php echo esc_attr($this->get_field_name( 'order' )); ?>"
			       class="widefat" id="<?php echo esc_attr($this->get_field_id( 'order' )); ?>">
                            <option <?php if($orderby == 'DESC') { echo 'Selected'; } ?> value="DESC"><?php echo esc_html__('Descending', 'bespoke') ?></option>
                            <option <?php if($orderby == 'ASC') { echo 'Selected'; } ?> value="ASC"><?php echo esc_html__('Ascending', 'bespoke') ?></option>
                        </select>
		</p>
	<?php
	}
}
