<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_newsletter extends WP_Widget {

	/**
	 * @internal
	 */
	function __construct() {
		$widget_ops = array( 'description' => esc_html__('ThemeWar Newsletter and Address Widget.', 'bespoke') );
		parent::__construct( false, esc_html__( 'ThemeWar Newsletter', 'bespoke' ), $widget_ops );
	}

	/**
	 * @param array $args
	 * @param array $instance
	 */
	function widget( $args, $instance ) {
		extract( $args );

		$title     = (isset($instance['title']) && $instance['title'] != '') ? wp_kses_post( $instance['title'] ) : '';
		$short     = (isset($instance['short']) && $instance['short'] != '') ? wp_kses_post( $instance['short'] ) : '';
		$office     = (isset($instance['office']) && $instance['office'] != '') ? wp_kses_post( $instance['office'] ) : '';
		$address     = (isset($instance['address']) && $instance['address'] != '') ? wp_kses_post( $instance['address'] ) : '';
		$phone     = (isset($instance['phone']) && $instance['phone'] != '') ? wp_kses_post( $instance['phone'] ) : '';
		
		
		$before_widget = str_replace( 'class="', 'class="tw_widet_neletter ', $before_widget );
		$title         = str_replace( 'class="', 'class="tw_widet_neletter_head ',
				$before_title ) . $title . $after_title;
                
                $filepath = dirname( __FILE__ ) . '/views/widget.php';

		if ( file_exists( $filepath ) ) {
			include( $filepath );
		}
                
	}

	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 
                    'title'         => '', 
                    'short'         => '', 
                    'office'         => '', 
                    'address'         => '', 
                    'phone'         => '', 
                ));
		?>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title', 'bespoke' ); ?> </label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>"
                           value="<?php echo wp_kses_post( $instance['title'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'short' )); ?>"><?php esc_html_e( 'Shortcode', 'bespoke' ); ?>
                            :</label>
                    <textarea name="<?php echo esc_attr($this->get_field_name( 'short' )); ?>"
                              class="widefat" id="<?php echo esc_attr($this->get_field_id( 'short' )); ?>"><?php echo wp_kses_post( $instance['short'] ); ?></textarea>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'office' )); ?>"><?php esc_html_e( 'Office Name', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'office' )); ?>"
                           value="<?php echo esc_attr( $instance['office'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'office' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'address' )); ?>"><?php esc_html_e( 'Office Address', 'bespoke' ); ?>
                            :</label>
                    <textarea name="<?php echo esc_attr($this->get_field_name( 'address' )); ?>"
                              class="widefat" id="<?php echo esc_attr($this->get_field_id( 'address' )); ?>"><?php echo wp_kses_post( $instance['address'] ); ?></textarea>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'phone' )); ?>"><?php esc_html_e( 'Phone Number', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'phone' )); ?>"
                           value="<?php echo esc_attr( $instance['phone'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'phone' )); ?>"/>
		</p>
	<?php
	}
}
