<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_Flickr extends WP_Widget {

	/**
	 * @internal
	 */
	function __construct() {
		$widget_ops = array( 'description' => esc_html__('Flickr photo gallery.', 'bespoke') );
		parent::__construct( false, esc_html__( 'ThemeWar Flickr', 'bespoke' ), $widget_ops );
	}

	/**
	 * @param array $args
	 * @param array $instance
	 */
	function widget( $args, $instance ) {
		extract( $args );

		$flickr_id = esc_attr( $instance['flickr_id'] );
		$title     = wp_kses_post( $instance['title'] );
		$number    = ( (int) ( esc_attr( $instance['number'] ) ) > 0 ) ? esc_attr( $instance['number'] ) : 6;
		$before_widget = str_replace( 'class="', 'class="widget_flickr_image_gallery ', $before_widget );
		$title         = str_replace( 'class="', 'class="widget_flickr_image_gallery ',
				$before_title ) . $title . $after_title;
                $photos = $this->get_photos( $flickr_id, $number );
		$filepath = dirname( __FILE__ ) . '/views/widget.php';

		if ( file_exists( $filepath ) ) {
			include( $filepath );
		}
	}

	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'flickr_id' => '', 'number' => '', 'title' => '' ) );
		?>
		<p>
                        <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title', 'bespoke' ); ?> </label>
			<input type="text" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>"
			       value="<?php echo esc_attr( $instance['title'] ); ?>" class="widefat"
			       id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'flickr_id' )); ?>"><?php esc_html_e( 'Flickr ID', 'bespoke' ); ?> (<a
					href="http://www.idgettr.com" target="_blank">idGettr</a>):</label>
			<input type="text" name="<?php echo esc_attr($this->get_field_name( 'flickr_id' )); ?>"
			       value="<?php echo esc_attr( $instance['flickr_id'] ); ?>" class="widefat"
			       id="<?php echo esc_attr($this->get_field_id( 'flickr_id' )); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of photos', 'bespoke' ); ?>
				:</label>
			<input type="text" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>"
			       value="<?php echo esc_attr( $instance['number'] ); ?>" class="widefat"
			       id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"/>
		</p>
	<?php
	}
        
        function get_photos( $id, $count = 6 ) {
		if ( empty( $id ) )
			return false;

		$transient_key = md5( 'mks_flickr_cache_' . $id . $count );
		$cached = get_transient( $transient_key );
		if ( !empty( $cached ) ) {
			return $cached;
		}

		$output = array();
		$rss = 'http://api.flickr.com/services/feeds/photos_public.gne?id='.$id.'&lang=en-us';
		$rss = fetch_feed( $rss );

		if ( is_wp_error( $rss ) ) {
			//check for group feed
			$rss = 'http://api.flickr.com/services/feeds/groups_pool.gne?id='.$id.'&lang=en-us';
			$rss = fetch_feed( $rss );
		}

		if ( !is_wp_error( $rss ) ) {
			$maxitems = $rss->get_item_quantity( $count );
			$rss_items = $rss->get_items( 0, $maxitems );
			foreach ( $rss_items as $item ) {
				$temp = array();
				$temp['img_url'] = esc_url( $item->get_permalink() );
				$temp['title'] = esc_html( $item->get_title() );
				$content =  $item->get_content();
				preg_match_all( "/<IMG.+?SRC=[\"']([^\"']+)/si", $content, $sub, PREG_SET_ORDER );
				$photo_url = str_replace( "_m.jpg", "_n.jpg", $sub[0][1] );
				$temp['img_src'] = esc_url( $photo_url );
				$output[] = $temp;
			}

			set_transient( $transient_key, $output, 60 * 60 * 24 );
		}


		return $output;
	}
}
