<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

class Widget_aboutus extends WP_Widget {

	/**
	 * @internal
	 */
	function __construct() {
		$widget_ops = array( 'description' => esc_html__('ThemeWar About Us Widget.', 'bespoke') );
		parent::__construct( false, esc_html__( 'ThemeWar About Us', 'bespoke' ), $widget_ops );
	}

	/**
	 * @param array $args
	 * @param array $instance
	 */
	function widget( $args, $instance ) {
		extract( $args );

		$title     = (isset($instance['title']) && $instance['title'] != '') ? wp_kses_post( $instance['title'] ) : '';
		$aboutdesc     = (isset($instance['aboutdesc']) && $instance['aboutdesc'] != '') ? wp_kses_post( $instance['aboutdesc'] ) : '';
		$fac     = (isset($instance['fac']) && $instance['fac'] != '') ? wp_kses_post( $instance['fac'] ) : '';
		$twi     = (isset($instance['twi']) && $instance['twi'] != '') ? wp_kses_post( $instance['twi'] ) : '';
		$goo     = (isset($instance['goo']) && $instance['goo'] != '') ? wp_kses_post( $instance['goo'] ) : '';
		$dri     = (isset($instance['dri']) && $instance['dri'] != '') ? wp_kses_post( $instance['dri'] ) : '';
		$beh     = (isset($instance['beh']) && $instance['beh'] != '') ? wp_kses_post( $instance['beh'] ) : '';
		$lin     = (isset($instance['lin']) && $instance['lin'] != '') ? wp_kses_post( $instance['lin'] ) : '';
		
		$before_widget = str_replace( 'class="', 'class="widget_flickr_image_gallery ', $before_widget );
		$title         = str_replace( 'class="', 'class="widget_flickr_image_gallery ',
				$before_title ) . $title . $after_title;
                
                $filepath = dirname( __FILE__ ) . '/views/widget.php';

		if ( file_exists( $filepath ) ) {
			include( $filepath );
		}
                
	}

	function update( $new_instance, $old_instance ) {
		return $new_instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 
                    'title'         => '',
                    'aboutdesc'     => '',
                    'fac'           => '',
                    'twi'           => '',
                    'goo'           => '',
                    'dri'           => '',
                    'beh'           => '',
                    'lin'           => '',
                ));
		?>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title', 'bespoke' ); ?> </label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>"
                           value="<?php echo wp_kses_post( $instance['title'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'aboutdesc' )); ?>"><?php esc_html_e( 'Description', 'bespoke' ); ?>
                            :</label>
                    <textarea name="<?php echo esc_attr($this->get_field_name( 'aboutdesc' )); ?>"
                              class="widefat" id="<?php echo esc_attr($this->get_field_id( 'aboutdesc' )); ?>"><?php echo esc_attr( $instance['aboutdesc'] ); ?></textarea>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'fac' )); ?>"><?php esc_html_e( 'Facebook URL', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'fac' )); ?>"
                           value="<?php echo esc_attr( $instance['fac'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'fac' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'twi' )); ?>"><?php esc_html_e( 'Twitter URL', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'twi' )); ?>"
                           value="<?php echo esc_attr( $instance['twi'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'twi' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'goo' )); ?>"><?php esc_html_e( 'Google+ URL', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'goo' )); ?>"
                           value="<?php echo esc_attr( $instance['goo'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'goo' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'dri' )); ?>"><?php esc_html_e( 'Dribbble URL', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'dri' )); ?>"
                           value="<?php echo esc_attr( $instance['dri'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'dri' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'beh' )); ?>"><?php esc_html_e( 'Behance URL', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'beh' )); ?>"
                           value="<?php echo esc_attr( $instance['beh'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'beh' )); ?>"/>
		</p>
		<p>
                    <label for="<?php echo esc_attr($this->get_field_id( 'lin' )); ?>"><?php esc_html_e( 'Linkedin URL', 'bespoke' ); ?>
                            :</label>
                    <input type="text" name="<?php echo esc_attr($this->get_field_name( 'lin' )); ?>"
                           value="<?php echo esc_attr( $instance['lin'] ); ?>" class="widefat"
                           id="<?php echo esc_attr($this->get_field_id( 'lin' )); ?>"/>
		</p>
	<?php
	}
}
