<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/**
 * Include static files: javascript and css
 */

if ( is_admin() ) {
	return;
}

/**
 * Enqueue scripts and styles for the front end.
 */

/*===============================================================
/ Add All CSS Here
=================================================================*/
wp_enqueue_style( 'bespoke-theme-fonts', bespoke_theme_font_url(), array(), '' );
wp_enqueue_style( 'bespoke-theme-style', get_stylesheet_uri(), array( ), '' );
wp_enqueue_style( 'bootstrap', BESPOKE_ASSETS_CSS_URL. '/bootstrap.css');
wp_enqueue_style( 'bespoke-icon', BESPOKE_ASSETS_CSS_URL. '/icon.css');
wp_enqueue_style( 'owl-carousel', BESPOKE_ASSETS_CSS_URL. '/owl.carousel.css');
wp_enqueue_style( 'owl-theme', BESPOKE_ASSETS_CSS_URL. '/owl.theme.css');
wp_enqueue_style( 'animate', BESPOKE_ASSETS_CSS_URL. '/animate.css');
wp_enqueue_style( 'slick', BESPOKE_ASSETS_CSS_URL. '/slick.css');
wp_enqueue_style( 'magnific-popup', BESPOKE_ASSETS_CSS_URL. '/magnific-popup.css');
wp_enqueue_style( 'vegas-min', BESPOKE_ASSETS_CSS_URL. '/vegas.min.css');
wp_enqueue_style( 'bespoke-preloader', BESPOKE_ASSETS_CSS_URL. '/preloader.css');
wp_enqueue_style( 'bespoke-preset', BESPOKE_ASSETS_CSS_URL. '/preset.css');
wp_enqueue_style( 'bespoke-styles', BESPOKE_ASSETS_CSS_URL. '/style.css');
wp_enqueue_style( 'bespoke-responsive', BESPOKE_ASSETS_CSS_URL. '/responsive.css');

wp_enqueue_style( 'bespoke-fonts', BESPOKE_ASSETS_CSS_URL. '/fonts.css');
wp_enqueue_style( 'bespoke-custom', BESPOKE_ASSETS_CSS_URL. '/custom.css');

$default_accent = 'color1';
$is_custome_accent = 2;
$primary_hex = '';
if(defined('FW')){
    $default_accent = fw_get_db_settings_option('default_accent', 'color1');
    $is_custome_accent = fw_get_db_settings_option('is_custome_accent', 2);
    $primary_hex = fw_get_db_settings_option('primary_hex', '');
}

if($is_custome_accent == 1 && $primary_hex != ''){
    wp_enqueue_style( 'bespoke-custom-accent', BESPOKE_ASSETS_CSS_URL. '/preset/custom_accent.css');
}else{
    wp_enqueue_style( 'bespoke-default-accent', BESPOKE_ASSETS_CSS_URL. '/preset/'.$default_accent.'.css');
}


/*===============================================================
/ Add All JS Here
=================================================================*/
if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) 
{
    wp_enqueue_script( 'comment-reply' );
}

$google_api = '';
if(defined('FW')){
    $google_api = '?key='.fw_get_db_settings_option('google_api', '');
}

wp_enqueue_script( 'bootstrap-min', BESPOKE_ASSETS_JS_URL . '/bootstrap.js', array( 'jquery' ), '', TRUE );
wp_enqueue_script( 'owl-carousel', BESPOKE_ASSETS_JS_URL . '/owl.carousel.js', array( 'bootstrap-min' ), '', TRUE );
wp_enqueue_script( 'googleapis', 'https://maps.googleapis.com/maps/api/js'.$google_api, array( 'owl-carousel' ), '', TRUE );
wp_enqueue_script( 'gmaps', BESPOKE_ASSETS_JS_URL . '/gmaps.js', array( 'googleapis' ), '', TRUE );
wp_enqueue_script( 'slick', BESPOKE_ASSETS_JS_URL . '/slick.js', array( 'gmaps' ), '', TRUE );
wp_enqueue_script( 'jquery-parallax', BESPOKE_ASSETS_JS_URL . '/jquery.parallax-1.1.3.js', array( 'slick' ), '', TRUE );
wp_enqueue_script( 'parallax', BESPOKE_ASSETS_JS_URL . '/parallax.js', array( 'jquery-parallax' ), '', TRUE );
wp_enqueue_script( 'jquery-magnific-popup', BESPOKE_ASSETS_JS_URL . '/jquery.magnific-popup.min.js', array( 'parallax' ), '', TRUE );
wp_enqueue_script( 'vegas-min', BESPOKE_ASSETS_JS_URL . '/vegas.min.js', array( 'jquery-magnific-popup' ), '', TRUE );
wp_enqueue_script( 'jquery-plugin', BESPOKE_ASSETS_JS_URL . '/jquery.plugin.min.js', array( 'vegas-min' ), '', TRUE );
wp_enqueue_script( 'jquery-countdown', BESPOKE_ASSETS_JS_URL . '/jquery.countdown.min.js', array( 'jquery-plugin' ), '', TRUE );
wp_enqueue_script( 'jquery-appear', BESPOKE_ASSETS_JS_URL . '/jquery.appear.js', array( 'jquery-countdown' ), '', TRUE );
wp_enqueue_script( 'jquery-vide-min', BESPOKE_ASSETS_JS_URL . '/jquery.vide.min.js', array( 'jquery-appear' ), '', TRUE );
wp_enqueue_script( 'masonry-pkgd', BESPOKE_ASSETS_JS_URL . '/masonry.pkgd.min.js', array( 'jquery-vide-min' ), '', TRUE );
wp_enqueue_script( 'bespoke-theme-js', BESPOKE_ASSETS_JS_URL . '/theme.js', array( 'masonry-pkgd' ), '', TRUE );
wp_enqueue_script( 'bespoke-ajax-request', BESPOKE_ASSETS_JS_URL . '/bespoke_ajax_request.js', array( 'bespoke-theme-js' ), '', TRUE );
wp_localize_script('bespoke-ajax-request', 'bespoke_ajax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
