<?php
require_once(ABSPATH . 'wp-admin/includes/file.php');

if(defined('FW'))
{
    
    function bespoke_theme_process_google_fonts()
    {
        $base_font1 = fw_get_db_settings_option('base_font', '');
        $base_font = $base_font1['family'];
        $base_font_style = $base_font1['style'];
        
        $font = str_replace(' ', '+', $base_font);
        
        $css = '';
        $baseFonts = '';
        $importa1 = '';
        if($base_font != '' && $base_font != 'Poppins')
        {
            $importa1 = '';
            if(function_exists('bespoke_gf_new_urls_generator')):
                $importa1 .= bespoke_gf_new_urls_generator($font);
            endif;
            $baseFonts .= 'body, html, .sidebar aside .widgetTitle, .shop_sidebar aside .widgetTitle{
                                    font-family: '.$base_font.' !important;
                                    font-weight: '.$base_font_style.';
                                }'."\n";
            $baseFonts .= 'h1, h2, h3, h4, h5, h6{
                                    font-family: '.$base_font.' !important;
                                }'."\n";
        }
        else
        {
            $importa1 .= '';
            $baseFonts .= '';
        }
        
        
        if($importa1 != '')
        {
            $css .= $importa1;
        }
        
        
        if($baseFonts != '')
        {
            $css .= $baseFonts;
        }
        
        if($css != '')
        {

            $css_file = 'fonts.css';

            WP_Filesystem();
            global $wp_filesystem;
            if(!$wp_filesystem->put_contents(get_template_directory().'/assets/css/'.$css_file, $css, FS_CHMOD_FILE)) {
                echo 'Generating CSS error!';
            }
        }
        else
        {
            $css_file = 'fonts.css';

            WP_Filesystem();
            global $wp_filesystem;
            if(!$wp_filesystem->put_contents(get_template_directory().'/assets/css/'.$css_file, $css, FS_CHMOD_FILE)) {
                echo 'Generating CSS error!';
            }
        }
        
        
        
    }
    add_action('fw_settings_form_saved', 'bespoke_theme_process_google_fonts', 999, 2);
    
    
    
    function bespoke_custom_css_generator()
    {
        $custom_css = fw_get_db_settings_option('custom_css', '');
        if($custom_css != '')
        {
            $css_file = 'custom.css';
            $css = $custom_css;

            WP_Filesystem();
            global $wp_filesystem;
            if(!$wp_filesystem->put_contents(get_template_directory().'/assets/css/'.$css_file, $css, FS_CHMOD_FILE)) {
                echo 'Generating CSS error!';
            }
        }
        else
        {
            $css_file = 'custom.css';
            $css = '';

            WP_Filesystem();
            global $wp_filesystem;
            if(!$wp_filesystem->put_contents(get_template_directory().'/assets/css/'.$css_file, $css, FS_CHMOD_FILE)) {
                echo 'Generating CSS error!';
            }
        }
    }
    
    add_action('fw_settings_form_saved', 'bespoke_custom_css_generator', 999, 2);
    
    
    
    function bespoke_custom_accent_color_generator()
    {
        $is_custome_accent = fw_get_db_settings_option('is_custome_accent', 2);
        $primary_hex = fw_get_db_settings_option('primary_hex', '');
        
        if($is_custome_accent == 1 && $primary_hex != '')
        {
            $custom_css = "/************************* Text Color **********************************/
                            .mainMenu ul li.current-menu-item a, .mainMenu ul li.active a, .mainMenu ul li a:hover, .mainMenu ul li:hover > a, 
                            .isSticky.fixedHeader .mainMenu ul li.active a, .isSticky.fixedHeader .mainMenu ul li a:hover, 
                            .isSticky.fixedHeader .logo h1 a, .singleService a.learn:hover, .teamDeg h4.magenta, 
                            .singleTestm::after, .workTag a:hover, .signatureandname h4, .testAut h4, .blogDate, 
                            .blogThumb .carousel-control-prev, .blogThumb .carousel-control-next, .blogThumb .iframeplay:hover, 
                            .wdFeactureImage .iframeplay:hover, .blogTitle a:hover, .blogComs a:hover, .bauthor,
                            .bauthor a, .subsNotice i, .consNotice i, .testmonialCaro.home_page2::before, .wdContent h5, .rewdContent h5, 
                            .blogCat ul li a:hover, .singleJournal_meta a.jon_date:hover, .singleJournal_meta a, 
                            .journalmeta a:hover, .authorName a:hover, .j_contentRel h3 a:hover, .commentTitle a#cancel-comment-reply-link, 
                            .comDate, .comAutReply a:hover, .comAutReply a.comment-reply-link, .comAutReply a.upvote, 
                            .sidebar aside ul li a:hover, .magenta, .isSticky.fixedHeader .mainMenu ul li.active a, 
                            .isSticky.fixedHeader .mainMenu ul li a:hover, .newsletter input[type='submit'], 
                            .slider2 .tp-leftarrow.default:hover.round:before,
                            .slider2 .tp-rightarrow.default:hover.round:after{
                                color: $primary_hex;
                            }
                            .mainMenu ul li:hover > a{
                                color: $primary_hex !important;
                            }
                            /************************* Background Color **********************************/
                            .singleTestm::before, #workCarousel .slick-prev:hover, #workCarousel .slick-next:hover, 
                            .testcarousel.owl-theme .owl-dots .owl-dot.active span, .socialIcon a:hover, .showit, .jon_comment, 
                            .tagcloud a:hover, .work_btn:hover, .bes_button4:hover, .light_form .bes_button, .bes_button2, 
                            .navigation.pagination a:hover, .navigation.pagination span.current, .bes_button3, .bes_button4:hover{
                                background: $primary_hex;
                            }
                            /************************* Border Color **********************************/
                            .mouseSlider:hover, .mouseSlider2:hover, .blogThumb .iframeplay:hover, .wdFeactureImage .iframeplay:hover, 
                            .single_form input.reqError, .single_form textarea.reqError, .jon_comment::before, 
                            .tagcloud a:hover{
                                border-color: $primary_hex;
                            }
                            .fixedHeader .mainMenu ul ul.sub-menu::before{
                                border-bottom: 5px solid $primary_hex;
                            }
                            .journalmeta a.jnalDate{
                                border-bottom: 2px solid $primary_hex;
                            }
                            blockquote{
                                border-left-color: $primary_hex;
                            }";
            
            $css_file = 'custom_accent.css';
            $css = $custom_css;

            WP_Filesystem();
            global $wp_filesystem;
            if(!$wp_filesystem->put_contents(get_template_directory().'/assets/css/preset/'.$css_file, $css, FS_CHMOD_FILE)) {
                echo 'Generating CSS error!';
            }
        }
        else
        {
            $css_file = 'custom_accent.css';
            $css = '';

            WP_Filesystem();
            global $wp_filesystem;
            if(!$wp_filesystem->put_contents(get_template_directory().'/assets/css/preset/'.$css_file, $css, FS_CHMOD_FILE)) {
                echo 'Generating CSS error!';
            }
        }
    }
    add_action('fw_settings_form_saved', 'bespoke_custom_accent_color_generator', 999, 2);
    
}