<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	<?php wp_head(); ?>
</head>
    <?php
        error_reporting(0);
        $main_bg = array();
        $main_heading = '';
        $main_desc = '';
        $main_date = '2019-01-01';
        $is_main_social = 1;
        $main_social = array();
        if(defined('FW')){
            $main_bg = fw_get_db_settings_option('main_bg', array());
            $main_heading = fw_get_db_settings_option('main_heading', '');
            $main_desc = fw_get_db_settings_option('main_desc', '');
            $main_date = fw_get_db_settings_option('main_date', '2019-01-01');
            $is_main_social = fw_get_db_settings_option('is_main_social', 1);
            $main_social = fw_get_db_settings_option('main_social', array());
        }
        
        $bg = '';
        $ov = '';
        if(is_array($main_bg) && isset($main_bg['url']) && $main_bg['url'] != ''){
            $bgimg = $main_bg['url'];
            $bg = 'background-image: url('.$bgimg.'); background-position: center center; background-size: cover;';
        }
        
        $d = ($main_date != '') ? date('j', strtotime($main_date)) : 1;
        $m = ($main_date != '') ? date('n', strtotime($main_date)) : 1;
        $y = ($main_date != '') ? date('Y', strtotime($main_date)) : 2019;
        
    ?>
    <body <?php body_class('maintaenance_modes'); ?>>
        <!--BreadCrump start-->
        <section class="comingPage" style="<?php echo esc_attr($bg); ?>">
            <div class="overlayDiv"></div>
            <div class="comingContent text-left">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="comingTitle text-center">
                                <?php if($main_heading != ''): ?>
                                    <h2><?php echo wp_kses_post($main_heading); ?></h2>
                                <?php endif; ?>
                                <?php if($main_desc != ''): ?>
                                    <p><?php echo wp_kses_post($main_desc); ?></p>
                                <?php endif; ?>
                                <?php if($is_main_social == 1 && is_array($main_social) && count($main_social) > 0): ?>
                                <div class="comingSocial text-center">
                                    <?php
                                        foreach($main_social as $soc):
                                            $sc_name = (isset($soc['sc_name']) && $soc['sc_name'] != '') ? $soc['sc_name'] : '';
                                            $sc_icon = (isset($soc['sc_icon']) && $soc['sc_icon'] != '') ? $soc['sc_icon'] : '';
                                            $sc_url = (isset($soc['sc_url']) && $soc['sc_url'] != '') ? $soc['sc_url'] : '';
                                            
                                            if($sc_url != ''):
                                                ?>
                                                <a target="_blank" title="<?php echo esc_attr($sc_name); ?>" href="<?php echo esc_url($sc_url); ?>"><i class="<?php echo esc_attr($sc_icon); ?>"></i></a>
                                                <?php
                                            endif;
                                        endforeach;
                                    ?>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div id="countdown_dashboard" data-day="<?php echo esc_attr($d); ?>" data-month="<?php echo esc_attr($m); ?>" data-year="<?php echo esc_attr($y); ?>"></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--BreadCrump End-->
        <?php wp_footer(); ?>
    </body>
</html>