<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

//======================================
// Enque JS For Admin
//======================================
function bespoke_enquey_admin_js()
{
    
    if(function_exists( 'wp_enqueue_media' ))
    {
        wp_enqueue_media();
    }
    else
    {
        wp_enqueue_style('thickbox');
        wp_enqueue_script('media-upload');
        wp_enqueue_script('thickbox');
    }
    wp_enqueue_script('veno_admin_js', BESPOKE_ASSETS_JS_URL.'/themewar_admin_js.js');
}
add_action( 'admin_enqueue_scripts', 'bespoke_enquey_admin_js' );

//======================================
// Load Css For WP Login
//======================================
add_action( 'login_enqueue_scripts', 'bespoke_wp_login_css', 10 );
function bespoke_wp_login_css()
{
    wp_enqueue_style( 'theme-core', BESPOKE_ASSETS_CSS_URL.'/login_style.css', false ); 
}


/*==============================================================================
/ Theme Setup
/==============================================================================*/
if ( ! function_exists( 'bespoke_action_theme_setup' ) ) : 
{
	function bespoke_action_theme_setup() {
                
		load_theme_textdomain( 'bespoke', get_template_directory() . '/languages' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1920, 1000, true );
		add_image_size( 'bespoke_single_page', 1920, 1000, true );
		add_image_size('bespoke_folio_slide', 1292, 800, true );
		add_image_size('bespoke_folio_slide2', 1170,450, true );
		add_image_size('bespoke_folio_fixed', 1280, 803, true );
		add_image_size('bespoke_folio_fixed2', 640, 803, true );
		add_image_size('bespoke_folio_blog', 420, 280, true );
		add_image_size('bespoke_folio_blog2', 856, 340, true );
		add_image_size('bespoke_blog_related', 370, 300, true );
		add_image_size('bespoke_comment_author', 110, 110, true );
                
		add_image_size('bespoke_folio_gall', 1920, 800, true );
		add_image_size('bespoke_folio_gall2', 960, 800, true );
		add_image_size('bespoke_folio_pagination', 200, 120, true );
                
                add_theme_support('title-tag');
                
		add_theme_support('html5', array('search-form', 'comment-form', 'comment-list',));
                add_theme_support('post-formats', array('audio', 'video', 'gallery'));
	}
}
endif;
add_action( 'init', 'bespoke_action_theme_setup' );



/*==============================================================================
/ Content Width
/==============================================================================*/
function bespoke_action_theme_content_width() {
	if ( is_attachment() && wp_attachment_is_image() ) {
		$GLOBALS['content_width'] = 1170;
	}
}
add_action( 'template_redirect', 'bespoke_action_theme_content_width' );

/*==============================================================================
/ Body class
/==============================================================================*/
function bespoke_filter_theme_body_classes( $classes ) {
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	if ( get_header_image() ) {
		$classes[] = 'header-image';
	} else {
		$classes[] = 'masthead-fixed';
	}

	if ( is_archive() || is_search() || is_home() ) {
		$classes[] = 'list-view';
	}

	if ( function_exists('fw_ext_sidebars_get_current_position') ) {
		$current_position = fw_ext_sidebars_get_current_position();
		if ( in_array( $current_position, array( 'full', 'left' ) )
		     || empty($current_position)
		     || is_page_template( 'page-templates/full-width.php' )
		     || is_page_template( 'page-templates/contributors.php' )
		     || is_attachment()
		) {
			$classes[] = 'full-width';
		}
	} else {
		$classes[] = 'full-width';
	}

	if ( is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'footer-widgets';
	}

	if ( is_singular() && ! is_front_page() ) {
		$classes[] = 'singular';
	}

	if ( is_front_page() && 'slider' == get_theme_mod( 'featured_content_layout' ) ) {
		$classes[] = 'slider';
	} elseif ( is_front_page() ) {
		$classes[] = 'grid';
	}

	return $classes;
}

add_filter( 'body_class', 'bespoke_filter_theme_body_classes' );

/*==============================================================================
/ Post Class
/==============================================================================*/
function bespoke_filter_theme_post_classes( $classes ) {
	if ( ! post_password_required() && ! is_attachment() && has_post_thumbnail() ) {
		$classes[] = 'has-post-thumbnail';
	}

	return $classes;
}
add_filter( 'post_class', 'bespoke_filter_theme_post_classes' );


/*==============================================================================
/ Sidebar Settings
/==============================================================================*/
function bespoke_widgets_init()
{
    bespoke_register_widget_areas(array(
            'sidebar-1' => array('name' => esc_html__('Blog Sidebar', 'bespoke'), 'description' => esc_html__('Blog sidebar, Only for blog pages.', 'bespoke')),
            'sidebar-2' => array('name' => esc_html__('Page Sidebar', 'bespoke'), 'description' => esc_html__('Page sidebar, Only for Pages.', 'bespoke')),
            'sidebar-3' => array('name' => esc_html__('Footer 1 (Default Style)', 'bespoke'), 'description' => esc_html__('Footer default sidebar 1.', 'bespoke')),
            'sidebar-4' => array('name' => esc_html__('Footer 2 (Default Style)', 'bespoke'), 'description' => esc_html__('Footer default sidebar 2.', 'bespoke')),
        
            'sidebar-5' => array('name' => esc_html__('Footer 1 (Extended Style)', 'bespoke'), 'description' => esc_html__('Footer extended sidebar 1.', 'bespoke')),
            'sidebar-6' => array('name' => esc_html__('Footer 2 (Extended Style)', 'bespoke'), 'description' => esc_html__('Footer extended sidebar 2.', 'bespoke')),
            'sidebar-7' => array('name' => esc_html__('Footer 2 (Extended Style)', 'bespoke'), 'description' => esc_html__('Footer extended sidebar 3.', 'bespoke')),
        ), array(
            'before_widget' => '<aside id="%1$s" class="widget %2$s wow fadeInUp" data-wow-duration="700ms" data-wow-delay="300ms">',
            'after_widget' => "</aside>",
            'before_title' => '<h3 class="widgetTitle">',
            'after_title' => '</h3>',
        )
    );
}
add_action('widgets_init', 'bespoke_widgets_init');



/*==============================================================================
/ User Custom Meta Box
/==============================================================================*/
add_action( 'show_user_profile', 'bespoke_user_avater' );
add_action( 'edit_user_profile', 'bespoke_user_avater' );

function bespoke_user_avater( $user )
{
    $user_facebook = get_user_meta($user->ID, 'user_facebook', TRUE);
    $user_twitter = get_user_meta($user->ID, 'user_twitter', TRUE);
    $user_google_plus = get_user_meta($user->ID, 'user_google_plus', TRUE);
    $user_dribbble = get_user_meta($user->ID, 'user_dribbble', TRUE);
    ?>

        <table class="form-table">
            <tr>
                <th><h3>User Avatar</h3></th>
                <td>
                    <?php
                        $avater_src = get_the_author_meta( 'user_avatar', $user->ID );
                        $user_av_ID = get_the_author_meta( 'user_av_ID', $user->ID );
                        if($avater_src != '')
                        {
                            $av = $avater_src;
                            $vis = 'block';
                        }
                        else
                        {
                            $av = '';
                            $vis = 'none';
                        }
                    ?>
                    <img class="user_logo upImg" src="<?php echo esc_url($av); ?>" height="100" width="100" style="display: <?php echo esc_attr($vis); ?>;"/>
                    <div class="clear"></div>
                    <input type="text" name="user_avatar" value="<?php echo esc_url($av); ?>" class="regular-text user_avater_url" />
                    <input type="hidden" name="user_av_ID" value="<?php echo esc_attr($user_av_ID); ?>" id="user_av_ID"/>
                    <a href="#" class="useravatar_upload button">Upload</a>
                </td>
            </tr>
            <tr>
                <th>
                    <h3><?php echo esc_html__('Facebook Link', 'bespoke'); ?></h3>
                </th>
                <td><input type="text" name="user_facebook" value="<?php echo esc_attr($user_facebook); ?>"/></td>
            </tr>
            <tr>
                <th>
                    <h3><?php echo esc_html__('Twitter Link', 'bespoke'); ?></h3>
                </th>
                <td><input type="text" name="user_twitter" value="<?php echo esc_attr($user_twitter); ?>"/></td>
            </tr>
            <tr>
                <th>
                    <h3><?php echo esc_html__('Google+ Link', 'bespoke'); ?></h3>
                </th>
                <td><input type="text" name="user_google_plus" value="<?php echo esc_attr($user_google_plus); ?>"/></td>
            </tr>
            <tr>
                <th>
                    <h3><?php echo esc_html__('Dribbble Link', 'bespoke'); ?></h3>
                </th>
                <td><input type="text" name="user_dribbble" value="<?php echo esc_attr($user_dribbble); ?>"/></td>
            </tr>
        </table>
    <?php
}

add_action( 'personal_options_update', 'bespoke_user_avatar_src' );
add_action( 'edit_user_profile_update', 'bespoke_user_avatar_src' );

function bespoke_user_avatar_src( $user_id )
{
    update_user_meta( $user_id,'user_avatar', sanitize_text_field( $_POST['user_avatar'] ) );
    update_user_meta( $user_id,'user_av_ID', sanitize_text_field( $_POST['user_av_ID'] ) );
    update_user_meta( $user_id,'user_facebook', sanitize_text_field( $_POST['user_facebook'] ) );
    update_user_meta( $user_id,'user_twitter', sanitize_text_field( $_POST['user_twitter'] ) );
    update_user_meta( $user_id,'user_google_plus', sanitize_text_field( $_POST['user_google_plus'] ) );
    update_user_meta( $user_id,'user_dribbble', sanitize_text_field( $_POST['user_dribbble'] ) );
}

/*==============================================================================
/ Larg Hook Files
/==============================================================================*/
require_once BESPOKE_ASSETS_INC_DIR.'/includes/tw_custom_icon_set_unyson.php';
require_once BESPOKE_ASSETS_INC_DIR.'/includes/tw_option_saving_hooks.php';

/*=================================
// Load More Blog Post AJAX
======================================= */
add_action( 'wp_ajax_load_more_post', 'bespoke_ajax_load_more_post' );
add_action( 'wp_ajax_nopriv_load_more_post', 'bespoke_ajax_load_more_post' );


/*==============================================================================
/ Site Preloader
/=============================================================================*/
function bespoke_preloader_creator($loader_status, $loaders)
{
    
    $preHTML = '';
    if($loader_status == 1){
        $preHTML .= '<div class="preloader">';
        switch ($loaders){
            case 1:
                $preHTML .= '<div class="loader">';
                    $preHTML .= '<img src="'.esc_url(BESPOKE_ASSETS_IMAGES_URL).'/loader.gif" alt="'.esc_attr(get_bloginfo('name')).'">';
                $preHTML .= '</div>';
                break;
            case 2:
                $preHTML .= '<div class="la-ball-circus la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 3:
                $preHTML .= '<div class="la-ball-climbing-dot la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 4:
                $preHTML .= '<div class="la-ball-clip-rotate la-2x">
                    <div></div>
                </div>';
                break;
            case 5:
                $preHTML .= '<div class="la-ball-clip-rotate-multiple la-2x">
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 6:
                $preHTML .= '<div class="la-ball-clip-rotate-pulse la-2x">
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 7:
                $preHTML .= '<div class="la-ball-newton-cradle la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>>';
                break;
            case 8:
                $preHTML .= '<div class="la-ball-rotate la-2x">
                    <div></div>
                </div>';
                break;
            case 9:
                $preHTML .= '<div class="la-ball-scale-multiple la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 10:
                $preHTML .= '<div class="la-ball-scale-ripple-multiple la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 11:
                $preHTML .= '<div class="la-ball-zig-zag la-2x">
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 12:
                $preHTML .= '<div class="la-fire la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 13:
                $preHTML .= '<div class="la-line-scale la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 14:
                $preHTML .= '<div class="la-line-scale-party la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 15:
                $preHTML .= '<div class="la-line-scale-pulse-out la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 16:
                $preHTML .= '<div class="la-line-spin-clockwise-fade-rotating la-2x">
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 17:
                $preHTML .= '<div class="la-square-jelly-box la-2x">
                    <div></div>
                    <div></div>
                </div>';
                break;
            case 18:
                $preHTML .= '<div class="la-square-spin la-2x">
                    <div></div>
                </div>';
                break;
            case 19:
                $preHTML .= '<div class="loader-inner sk-folding-cube">
                    <div class="sk-cube1 sk-cube"></div>
                    <div class="sk-cube2 sk-cube"></div>
                    <div class="sk-cube4 sk-cube"></div>
                    <div class="sk-cube3 sk-cube"></div>
                </div>';
                break;
            case 20:
                $preHTML .= '<div class="la-timer la-2x">
                    <div></div>
                </div>';
                break;
                
        }
        $preHTML .= '</div>';
    }
    
    echo wp_kses_post($preHTML);
}