<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/**
 * Helper functions and classes with static methods for usage in theme
 */

/**
 * Register Lato Google font.
 *
 * @return string
 */
function bespoke_theme_font_url() {
	$fonts_url = '';
        $font_families = array();

        $Poppins = _x( 'on', 'Poppins font: on or off', 'bespoke' );
        $Poiret = _x( 'on', 'Poiret One font: on or off', 'bespoke' );
        $Droid = _x( 'on', 'Droid Serif font: on or off', 'bespoke' );

        if ( 'off' !== $Poppins ) 
        {
            $font_families[] = 'Poppins:300,400,500,600,700';
        }

        if ( 'off' !== $Poiret ) 
        {
            $font_families[] = 'Poiret One:400';
        }

        if ( 'off' !== $Droid ) 
        {
            $font_families[] = 'Droid Serif:100,100i,300,300i,400,400i';
        }

        if ( $font_families) 
        {
            $query_args = array(
                'family' => urlencode( implode( '|', $font_families ) ),
                'subset' => urlencode( 'latin,latin-ext' ),
            );

            $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
        }

        return esc_url_raw( $fonts_url );
}


//======================================
// Load Widgets Areas
//======================================
function bespoke_register_widget_areas($areas, $defaultParams = array())
{
	if(empty($defaultParams)){
		$defaultParams = array(
			'before_widget' => '<div id="%1$s" class="box widget-container %2$s"><div class="box-wrapper">',
			'after_widget' => "</div></div>",
			'before_title' => '<h2 class="widget-title">',
			'after_title' => '</h2>',
		);
	}

	foreach($areas as $id => $area){
		$params = array_merge($defaultParams, $area, array('id' => $id));
		register_sidebar($params);
	}
}

//=======================================
// Set View Counter
//=======================================
function bespoke_post_views($postID)
{
   $count_key = 'post_views_count';
   $count = get_post_meta($postID, $count_key, true);
   if ($count == '')
   {
      $count = 0;
      delete_post_meta($postID, $count_key);
      add_post_meta($postID, $count_key, '0');
   } else
   {
      $count += 1;
      update_post_meta($postID, $count_key, $count);
   }
}


//=======================================
// Pagination
//=======================================
if ( ! function_exists( 'bespoke_post_pageing_nav' ) ) :
    function bespoke_post_pageing_nav() 
    {
	global $wp_query, $wp_rewrite;

	// Don't print empty markup if there's only one page.
	if ( $wp_query->max_num_pages < 2 ) {
		return;
	}
        $paged = 1;
        if(get_query_var( 'paged' )) {$paged = get_query_var( 'paged' );}
        if(get_query_var( 'page' )) {$paged = get_query_var( 'page' );}
	$pagenum_link = html_entity_decode( get_pagenum_link() );
	$query_args   = array();
	$url_parts    = explode( '?', $pagenum_link );

	if ( isset( $url_parts[1] ) ) {
		wp_parse_str( $url_parts[1], $query_args );
	}

	$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
	$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

	$format  = $wp_rewrite->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
	$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit( $wp_rewrite->pagination_base . '/%#%', 'paged' ) : '?paged=%#%';

	// Set up paginated links.
	$links = paginate_links( array(
		'base'     => $pagenum_link,
		'format'   => $format,
		'total'    => $wp_query->max_num_pages,
		'current'  => $paged,
		'mid_size' => 1,
		'add_args' => array_map( 'urlencode', $query_args ),
		'prev_text' => esc_html__( 'Prev', 'bespoke' ),
		'next_text' => esc_html__( 'Next', 'bespoke' ),
	) );
        
        $twPaging = '';
	if ( $links ) :
            $twPaging .= '<div class="paginations">';
                $twPaging .= $links;
            $twPaging .= '</div>';
	endif;
        
        return $twPaging;
    }
endif;



function bespoke_ajax_load_more_post(){
    $offsets = $_POST['offsets'];
    $posts_per_page = get_option('posts_per_page');
    
    $result = array();
    $argu = array(
        'post_type'         => array('post'),
        'post_status'       => 'publish',
        'posts_per_page'    => $posts_per_page,
        'orderby'           => 'date',
        'order'             => 'DESC',
        'offset'            => $offsets
    );
    
    $loop = new WP_Query($argu);
    if($loop->have_posts()){
        $l = 1;
        ob_start();
        while($loop->have_posts()):
            $loop->the_post();
            if($l == 4 || $l == 9 || $l == 14 || $l == 19 || $l == 24):
                get_template_part('template-parts/content-2col', get_post_format());
            else:
                get_template_part('template-parts/content-3col', get_post_format());
            endif;
        endwhile;
        $html = ob_get_contents();
        ob_end_clean();
        $result['succ'] = 1;
        $result['content'] = $html;
    }else{
        $result['succ'] = 2;
        $result['content'] = '';
    }
    wp_reset_postdata();
    
    echo json_encode($result);
    exit();
}

//=======================================
// Comment Listing Modification
//=======================================
function bespoke_comment_listing($comment, $args, $depth)
{
    $GLOBALS['comment'] = $comment;
    $avater = get_avatar_url($comment->comment_author_email);
    if($comment->user_id != '' && $comment->user_id != 0)
    {
        $userId = $comment->user_id;
        $avID = get_the_author_meta('user_av_ID', $userId);
        if($avID != '')
        {
            $thumb = wp_get_attachment_image_src( $avID, 'bespoke_comment_author' );
            $userAvater = $thumb[0];
        }
        else
        {
            $userAvater = $avater;
        }
    }
    else
    {
        $userAvater = $avater;
    }
    $authorurl = (isset($comment->comment_author_url) && $comment->comment_author_url != '') ? $comment->comment_author_url : '#';
    $dateformate = get_option( 'date_format' );
     ?>
    <li id="comment-<?php echo esc_attr($comment->comment_ID); ?>" class="<?php if(isset($comment->comment_type) && $comment->comment_type == 'pingback') { echo 'pingbackli'; } ?> clearfix">
        <div class="singleCom clearfix">
            <?php if(isset($comment->comment_type) && $comment->comment_type == 'pingback'): ?>
                <span class="pingbacks"><?php echo esc_html__('Pingback:', 'bespoke'); ?></span>
            <?php else: ?>
                <img src="<?php echo esc_url($userAvater); ?>" alt="<?php echo esc_attr($comment->comment_author); ?>">
            <?php endif; ?>
            <div class="comHead">
                <a class="comDate" href="<?php echo esc_url($authorurl); ?>"><?php echo get_comment_time($dateformate); ?></a>
                <div class="comAutReply">
                    <a href="<?php echo esc_url($authorurl); ?>"><?php echo esc_html($comment->comment_author); ?></a>
                    <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                    <?php if(bespoke_check_plugin_active('bespoke_assistance')): ?>
                        <?php echo do_shortcode('[bespoke-comment-upvote comment_id="'.$comment->comment_ID.'"]'); ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="commentsContents">
                <?php comment_text(); ?>
            </div>
        </div>
     <?php
}

//=======================================
// Boddy Class
//=======================================
function bespoke_body_class($classes = 'workDetail'){
    $class = '';
    if(!is_front_page() || is_home()){
        $class = $classes;
    }
    
    echo wp_kses($class, array());
}

//=======================================
// Theme Menu Walker
//=======================================

if (!function_exists('Bespoke_Menu_Walker::start_el')) {


    class Bespoke_Menu_Walker extends Walker_Nav_Menu {

        function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {

            global $wp_query;

            $indent = ( $depth ) ? str_repeat("\t", $depth) : '';

            $class_names = $value = '';

            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;

            // add submenu class if current item is a top menu item
            $menu_link_class = '"';
            $bIsTopMenuItem = false;
            if (in_array("menu-item-has-children", $classes)) {
                $menu_link_class = ' "';
                $bIsTopMenuItem = true;
            }

            if ((in_array("current-menu-item", $classes)) || (in_array("current_page_item", $classes))) {

                $classes[] = 'active';
            }

            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));


            $id = apply_filters('nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args);
            $id = $id ? ' id="' . esc_attr($id) . '"' : '';

            $atts = array();
            $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';

            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args);

            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }

            if ($item->object == 'page') {
                $page_post = get_post($item->object_id);
                $section_page = (get_post_meta($item->object_id, "section_status", true) == 'yes');
                $disable_menu = (get_post_meta($item->object_id, "menu_status", true) == 'yes');
                $main_page_id = get_option('page_on_front');

                if (!$disable_menu || ( $page_post->ID == $main_page_id )) {

                    
                        if (!$section_page)
                            $attributes .=!empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';
                        else {
                            if (is_front_page())
                                $attributes .= ' href="#' . $item->object_id . '"';
                            else
                                $attributes .= ' href="' . home_url() . '#' . $item->object_id . '"';
                        }
                    

                    $item_output = $args->before;
                    
                        if ($section_page && is_front_page())
                            $item_output .= '<a class="collapse_menu1' . $menu_link_class . ' ' . $attributes . '>';
                        else
                            $item_output .= '<a class="external' . $menu_link_class . ' ' . $attributes . '>';
                    
                    

                    $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                    $item_output .= '</a>';
                    $item_output .= $args->after;

                    if ($section_page || ($page_post->ID == $main_page_id)) {
                        if(is_front_page()):
                            if(($page_post->ID != $main_page_id)):
                                $class_names = $class_names ? ' scroll '.esc_attr($class_names) : '';
                            else:
                                $class_names = $class_names ? esc_attr($class_names) : ''; 
                            endif;
                        endif;
                    } else {
                        $class_names = $class_names ? esc_attr($class_names) : '';
                    }

                    $output .= $indent . '<li' . $id . $value . ' class="'.esc_attr($class_names).'">';
                    $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
                }
            } else {
                $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
                
                $attributes .=!empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';

                $item_output = $args->before;
                $item_output .= '<a class="externala' . $menu_link_class . ' ' . $attributes . '>';

                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                $item_output .= '</a>';
                $item_output .= $args->after;

                $output .= $indent . '<li' . $id . $value . $class_names . '>';
                $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
            }
        }

        function start_lvl(&$output, $depth = 0, $args = array()) {
            $indent = str_repeat("\t", $depth);
            $output .= "\n$indent<ul class=\"sub-menu dropMenu\">\n";
        }
        
        
        function end_el(&$output, $item, $depth=0, $args=array()) {
            if ($item->object == 'page')
            {
                $disable_menu = (get_post_meta($item->object_id, "menu_status", true) == 'yes');
                if(!$disable_menu)
                {
                    $output .= "</li>\n";
                }
            }
            else
            {
                $output .= "</li>\n";
            }
        }

    }

}


//=================================================
// Check Plugin Activity
//=================================================

function bespoke_check_plugin_active( $plugin ) 
{
    $plugin = $plugin.'/'.$plugin.'.php';
    return in_array( $plugin, (array) get_option( 'active_plugins', array() ) );
}