<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">

<?php
    if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) 
    {
        $favicon = '';
        if(defined('FW')){
            $favicons = fw_get_db_settings_option('favicon', '');
            $favicon = (isset($favicons['url']) && $favicons['url'] != '') ? $favicons['url'] : '';
        }
        if($favicon != ''):
        ?>
            <link rel="icon"  type="image/png" href="<?php echo esc_url($favicon); ?>">
        <?php else: ?>
            <link rel="icon"  type="image/png" href="<?php echo esc_url(BESPOKE_ASSETS_IMAGES_URL).'/favicon.png'; ?>">
        <?php 
        endif;
    }
?>

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php
        $header_style = 1;
        $is_sticky = 2;
        $header_position = 1;
        $logo_img = array();
        $logo_img2 = array();
        $logo_fixed = array();
        $logo_height = '';
        $is_phone = 2;
        $phone_title = '';
        $phone_number = '';
        
        $loader_status = 2;
        $loaders = 1;
        if(defined('FW')){
            $header_style = fw_get_db_settings_option('header_style', 1);
            $is_sticky = fw_get_db_settings_option('is_sticky', 2);
            $header_position = fw_get_db_settings_option('header_position', 1);
            $logo_img = fw_get_db_settings_option('logo_img', array());
            $logo_img2 = fw_get_db_settings_option('logo_img2', array());
            $logo_fixed = fw_get_db_settings_option('logo_fixed', array());
            $logo_height = fw_get_db_settings_option('logo_height', '');
            $is_phone = fw_get_db_settings_option('is_phone', 2);
            $phone_title = fw_get_db_settings_option('phone_title', '');
            $phone_number = fw_get_db_settings_option('phone_number', '');
            
            $loader_status = fw_get_db_settings_option('loader_status', 2);
            $loaders = fw_get_db_settings_option('loaders', 1);
        }
        
        bespoke_preloader_creator($loader_status, $loaders);
    ?>
    <?php
        if($header_style == 2){
            get_template_part('template-parts/header/header', 'fullwidth-one');
        }elseif($header_style == 3){
            get_template_part('template-parts/header/header', 'fullwidth-two');
        }elseif($header_style == 4){
            get_template_part('template-parts/header/header', 'photography');
        }else{
            get_template_part('template-parts/header/header-in', 'container');
        }
    ?>
    