<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

/**
 * Theme Constants
 */
define('BESPOKE_THEME_DIR', get_template_directory());
define('BESPOKE_THEME_URL', get_template_directory_uri());
define('BESPOKE_STYLESHEET_URL', get_stylesheet_uri());

define('BESPOKE_THEME_STYLESHEET_URL', get_bloginfo('stylesheet_url'));
define('BESPOKE_THEME_STYLESHEET_FILE', BESPOKE_THEME_DIR . '/style.css');

define('BESPOKE_ASSETS_DIR', BESPOKE_THEME_DIR . '/assets');
define('BESPOKE_ASSETS_URL', BESPOKE_THEME_URL . '/assets');

define('BESPOKE_ASSETS_CSS_DIR', BESPOKE_ASSETS_DIR . '/css');
define('BESPOKE_ASSETS_CSS_URL', BESPOKE_ASSETS_URL . '/css');

define('BESPOKE_ASSETS_JS_DIR', BESPOKE_ASSETS_DIR . '/js');
define('BESPOKE_ASSETS_JS_URL', BESPOKE_ASSETS_URL . '/js');

define('BESPOKE_ASSETS_IMAGES_DIR', BESPOKE_ASSETS_DIR . '/images');
define('BESPOKE_ASSETS_IMAGES_URL', BESPOKE_ASSETS_URL . '/images');

define('BESPOKE_ASSETS_INC_DIR', BESPOKE_THEME_DIR . '/inc');
define('BESPOKE_ASSETS_INC_URL', BESPOKE_THEME_URL . '/inc');

define('BESPOKE_SHORT_DIR', BESPOKE_THEME_DIR . '/framework-customizations/extensions/shortcodes/shortcodes');
define('BESPOKE_SHORT_URL', BESPOKE_THEME_URL . '/framework-customizations/extensions/shortcodes/shortcodes');

/**
 * Theme Includes
 */
require_once BESPOKE_ASSETS_INC_DIR .'/init.php';

/**
 * TGM Plugin Activation
 */
{
	require_once BESPOKE_ASSETS_INC_DIR . '/class-tgm-plugin-activation.php';

	/** @internal */
	add_action( 'tgmpa_register', 'bespoke_plugin_activation_notive' );
        if(!function_exists('bespoke_plugin_activation_notive'))
        {
            function bespoke_plugin_activation_notive()
            {
                $plugins = array(
                    array(
                            'name'      => esc_html__('Unyson', 'bespoke'),
                            'slug'      => 'unyson',
                            'required'  => TRUE,
                    ),
                    array(
                            'name'      => esc_html__('Contact Form 7', 'bespoke'),
                            'slug'      => 'contact-form-7',
                            'required'  => TRUE,
                    ),
                    array(
                            'name'      => esc_html__('MailChimp for WordPress', 'bespoke'),
                            'slug'      => 'mailchimp-for-wp',
                            'required'  => false,
                    ),
                    array(
                            'name'               => esc_html__('Revolution Slider', 'bespoke'), 
                            'slug'               => 'revslider', 
                            'source'             => esc_url('http://themewar.com/plugins/revslider.zip'),
                            'required'           => TRUE, 
                            'version'            => '', 
                            'force_activation'   => false, 
                            'force_deactivation' => false, 
                            'external_url'       => '',
                    ),
                    array(
                            'name'               => esc_html__('Bespoke Assistance', 'bespoke'), 
                            'slug'               => 'bespoke_assistance', 
                            'source'             => esc_url('http://themewar.com/plugins/bespoke_assistance.zip'),
                            'required'           => TRUE, 
                            'version'            => '', 
                            'force_activation'   => false, 
                            'force_deactivation' => false, 
                            'external_url'       => '',
                    ),

                );

                $config = array(
                        'id'           => 'bespoke',                 
                        'default_path' => '',                      
                        'menu'         => 'tgmpa-install-plugins', 
                        'has_notices'  => true,                    
                        'dismissable'  => true,                    
                        'dismiss_msg'  => '',                      
                        'is_automatic' => false,                   
                        'message'      => '',                      
                );

                    tgmpa( $plugins, $config );
                }
        }
}

/*==============================================================================
/ Site Maintenance Mode Manager
/=============================================================================*/
$is_maintenance = get_option('is_maintenance_mode', 2);

if($is_maintenance == 1 ){
    add_action( 'wp_loaded', 'bespoke_maintenance_mode_controller' );
}

function bespoke_maintenance_mode_controller() 
{
    global $pagenow;
    if ( $pagenow !== 'wp-login.php' && ! current_user_can( 'manage_options' ) && ! is_admin() ) 
    {
            header( 'Content-Type: text/html; charset=utf-8' );
            if ( file_exists( BESPOKE_ASSETS_INC_DIR . '/includes/tw_maintenance_mode_view.php' ) ) 
            {
                require_once( BESPOKE_ASSETS_INC_DIR . '/includes/tw_maintenance_mode_view.php' );
            }
            die();
    }
}