<?php if ( ! defined( 'FW' ) ) { die( 'Forbidden' ); }

$options = array(
    'maintenance' => array(
        'title'   => esc_html__( 'Maintenance Settings', 'bespoke' ),
        'type'    => 'tab',
        'options' => array(
            'maintenance-box' => array(
                'title'   => esc_html__( 'Maintenance Settings', 'bespoke' ),
                'type'    => 'box',
                'options' => array(
                        'is_maintenance_mode'                    => array(
                                'label'        => esc_html__( 'Is Maintenance?', 'bespoke' ),
                                'type'         => 'switch',
                                'right-choice' => array(
                                        'value' => '1',
                                        'label' => esc_html__( 'Yes', 'bespoke' )
                                ),
                                'left-choice'  => array(
                                        'value' => '2',
                                        'label' => esc_html__( 'No', 'bespoke' )
                                ),
                                'value'        => '2',
                                'desc'         => esc_html__( 'Do you want to enable maintenance mode?', 'bespoke' ),
                                'fw-storage' => array(
                                        'type' => 'wp-option',
                                        'wp-option' => 'is_maintenance_mode',
                                ),
                        ),
                        'main_bg'             => array(
                                'label' => esc_html__( 'BG Image', 'bespoke' ),
                                'desc'  => esc_html__('Upload your maintenance BG image.', 'bespoke'),
                                'type'  => 'upload'
                        ),
                        'main_heading'      => array(
                                'type'      => 'text',
                                'label'     => esc_html__('Heading', 'bespoke'),
                                'desc'      => esc_html__('Please insert your maintenance page heading here.', 'bespoke'),
                        ),
                        'main_desc'         => array(
                                'type'      => 'textarea',
                                'label'     => esc_html__('Short Desc', 'bespoke'),
                                'desc'      => esc_html__('Please insert your maintenance page short description here.', 'bespoke'),
                        ),
                        'main_date'           => array(
                                'type'            => 'datetime-picker',
                                'value'           => '',
                                'attr'            => array(),
                                'label'           => esc_html__( 'Opening Date', 'bespoke' ),
                                'desc'            => esc_html__('Please insert your site opening date with this formate (YYYY-MM-DD).', 'bespoke'),
                                'datetime-picker' => array(
                                        'format'        => 'Y-m-d',
                                        'extra-formats' => array(),
                                        'moment-format' => 'YYYY-MM-DD',
                                        'scrollInput'   => false,
                                        'maxDate'       => false,
                                        'minDate'       => false,
                                        'timepicker'    => FALSE,
                                        'datepicker'    => true,
                                        'defaultTime'   => '12:00'
                                )
                        ),
                        'is_main_social'                    => array(
                                'label'        => esc_html__( 'Is Social?', 'bespoke' ),
                                'type'         => 'switch',
                                'right-choice' => array(
                                        'value' => '1',
                                        'label' => esc_html__( 'Yes', 'bespoke' )
                                ),
                                'left-choice'  => array(
                                        'value' => '2',
                                        'label' => esc_html__( 'No', 'bespoke' )
                                ),
                                'value'        => '1',
                                'desc'         => esc_html__( 'Do you want to show social in coming soon page?', 'bespoke' ),
                        ),
                        'main_social' => array(
                                'label'         => esc_html__( 'Socials', 'bespoke' ),
                                'popup-title'   => esc_html__( 'Add/Edit Socials', 'bespoke' ),
                                'desc'          => esc_html__( 'Here you can add, remove and edit your Socials.', 'bespoke' ),
                                'type'          => 'addable-popup',
                                'template'      => '{{=sc_name}}',
                                'popup-options' => array(
                                        'sc_name'       => array(
                                                'label' => esc_html__( 'Name', 'bespoke' ),
                                                'desc'  => esc_html__( 'Enter social media name here.', 'bespoke' ),
                                                'type'  => 'text'
                                        ),
                                        'sc_icon'       => array(
                                                'type' => 'icon',
                                                'label' => esc_html__( 'Social Icon', 'bespoke' ),
                                                'desc' => esc_html__( 'Please select your social icon.', 'bespoke' ),
                                        ),
                                        'sc_url'   => array(
                                                'label' => esc_html__( 'Profile URL', 'bespoke' ),
                                                'desc'  => esc_html__( 'Please insert your profile URL here.', 'bespoke' ),
                                                'type'  => 'text'
                                        )
                                )
                        )
                )
            ),
        )
    )
);