<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'sliders' => array(
		'label'         => esc_html__( 'Sliders', 'bespoke' ),
		'popup-title'   => esc_html__( 'Add/Edit Sliders', 'bespoke' ),
		'desc'          => esc_html__( 'Here you can add, remove and edit your Sliders.', 'bespoke' ),
		'type'          => 'addable-popup',
		'template'      => '{{=sec_title}}',
		'popup-options' => array(
			'sub_title_group'       => array(
                                'type'          => 'group',
                                'options'       => array(
                                        'sec_sub_title'         => array(
                                                'label'     => esc_html__('Sub Title', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert your sub title here.', 'bespoke'),
                                        ),
                                        'sec_scolor'        => array(
                                                'label'     => esc_html__('Color', 'bespoke'),
                                                'type'      => 'color-picker',
                                                'desc'      => esc_html__('Insert your sub title color. Default color is #fd0060.', 'bespoke'),
                                        ),
                                        'sec_sub_size'         => array(
                                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert sub title font size. Default font size is 16px.', 'bespoke'),
                                        ),
                                        'sec_sub_space'         => array(
                                                'label'     => esc_html__('Letter Spacing', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert sub title letter spacing. Default space is 6.4px.', 'bespoke'),
                                        ),
                                        'sec_sub_height'         => array(
                                                'label'     => esc_html__('Line Height', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert sub title line height. Default height is 20px.', 'bespoke'),
                                        ),
                                        'sec_sub_weight'                    => array(
                                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                                'type'    => 'select',
                                                'value'   => 700,
                                                'desc'    => esc_html__( 'Select your sub title font weight.', 'bespoke' ),
                                                'choices' => array(
                                                        100     => esc_html__( '100', 'bespoke' ),
                                                        300     => esc_html__( '300', 'bespoke' ),
                                                        400     => esc_html__( '400', 'bespoke' ),
                                                        500     => esc_html__( '500', 'bespoke' ),
                                                        600     => esc_html__( '600', 'bespoke' ),
                                                        700     => esc_html__( '700', 'bespoke' ),
                                                        900     => esc_html__( '900', 'bespoke' ),
                                                ),
                                        ),
                                        'sec_sub_margin'         => array(
                                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert sub title margin bottom. Default margin is 39px.', 'bespoke'),
                                        ),
                                )
                        ),
			'title_group'           => array(
                                'type'          => 'group',
                                'options'       => array(
                                        'sec_title'         => array(
                                                'label'     => esc_html__('Content', 'bespoke'),
                                                'type'      => 'textarea',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert your content here.', 'bespoke'),
                                        ),
                                        'sec_tcolor'        => array(
                                                'label'     => esc_html__('Color', 'bespoke'),
                                                'type'      => 'color-picker',
                                                'desc'      => esc_html__('Insert your content color. Default color is #000000.', 'bespoke'),
                                        ),
                                        'sec_tsize'         => array(
                                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert title font size. Default font size is 50px.', 'bespoke'),
                                        ),
                                        'sec_theight'         => array(
                                                'label'     => esc_html__('Line Height', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert title line height.', 'bespoke'),
                                        ),
                                        'sec_tweight'                    => array(
                                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                                'type'    => 'select',
                                                'value'   => 700,
                                                'desc'    => esc_html__( 'Select your title font weight.', 'bespoke' ),
                                                'choices' => array(
                                                        100     => esc_html__( '100', 'bespoke' ),
                                                        300     => esc_html__( '300', 'bespoke' ),
                                                        400     => esc_html__( '400', 'bespoke' ),
                                                        500     => esc_html__( '500', 'bespoke' ),
                                                        600     => esc_html__( '600', 'bespoke' ),
                                                        700     => esc_html__( '700', 'bespoke' ),
                                                        900     => esc_html__( '900', 'bespoke' ),
                                                ),
                                        ),
                                        'sec_margin'         => array(
                                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert margin bottom. Default margin is 29px.', 'bespoke'),
                                        ),
                                )
                        ),
			'btns_group'           => array(
                                'type'          => 'group',
                                'options'       => array(
                                        'btn_style'                    => array(
                                                'label'   => esc_html__( 'Btn Style', 'bespoke' ),
                                                'type'    => 'select',
                                                'value'   => 1,
                                                'desc'    => esc_html__( 'Select your Btn style.', 'bespoke' ),
                                                'choices' => array(
                                                        1     => esc_html__( 'Gradient', 'bespoke' ),
                                                        2     => esc_html__( 'Normal', 'bespoke' ),
                                                ),
                                        ),
                                        'btn_title'         => array(
                                                'label'     => esc_html__('Btn Label', 'bespoke'),
                                                'type'      => 'text',
                                                'value'     => '',
                                                'desc'      => esc_html__('Insert your button label here.', 'bespoke'),
                                        ),
                                        'btn_url'        => array(
                                                'label'     => esc_html__('Btn Url', 'bespoke'),
                                                'type'      => 'text',
                                                'desc'      => esc_html__('Insert btn url here.', 'bespoke'),
                                        )
                                )
                        ),
		)
	),
        'is_dots'       => array(
                'label'        => esc_html__('Is Controls?', 'bespoke'),
                'type'         => 'switch',
                'right-choice' => array(
                        'value' => '1',
                        'label' => esc_html__('Yes', 'bespoke')
                ),
                'left-choice'  => array(
                        'value' => '2',
                        'label' => esc_html__('No', 'bespoke')
                ),
                'value'        => '2',
                'desc'         => esc_html__('Do you want to show slider dot controls?.', 'bespoke'),
        ),
);