<?php

if(!defined('FW'))
{
    die('Forbidden');
}

$options = array(
        'content'        => array(
                'type'  => 'textarea',
                'label' => esc_html__('Content', 'bespoke'),
                'desc'  => esc_html__('Insert your block content here.', 'bespoke')
        ),
        'color'          => array(
                'label' => esc_html__('Color', 'bespoke'),
                'type'  => 'color-picker',
                'desc'  => esc_html__('Insert your content custom color. Default color is #999999.', 'bespoke'),
        ),
        'size'           => array(
                'label' => esc_html__('Font Size', 'bespoke'),
                'type'  => 'text',
                'desc'  => esc_html__('Insert your content font size. Default size is 18px.', 'bespoke'),
        ),
        'height'         => array(
                'label' => esc_html__('Line Height', 'bespoke'),
                'type'  => 'text',
                'value' => '',
                'desc'  => esc_html__('Insert content line height. Default line height is 36px.', 'bespoke'),
        ),
        'weight'         => array(
                'label'   => esc_html__('Font Weight', 'bespoke'),
                'type'    => 'select',
                'value'   => 400,
                'desc'    => esc_html__('Select your content font weight.', 'bespoke'),
                'choices' => array(
                        100 => esc_html__('100', 'bespoke'),
                        300 => esc_html__('300', 'bespoke'),
                        400 => esc_html__('400', 'bespoke'),
                        500 => esc_html__('500', 'bespoke'),
                        600 => esc_html__('600', 'bespoke'),
                        700 => esc_html__('700', 'bespoke'),
                        900 => esc_html__('900', 'bespoke'),
                ),
        ),
        'style'          => array(
                'label'   => esc_html__('Font Style', 'bespoke'),
                'type'    => 'select',
                'value'   => 'font-normal',
                'desc'    => esc_html__('Select your content font style.', 'bespoke'),
                'choices' => array(
                        'font-normal' => esc_html__('Normal', 'bespoke'),
                        'font-italic' => esc_html__('Italic', 'bespoke'),
                ),
        ),
        'padding_group'  => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'     => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Padding', 'bespoke'),
                                'html'  => '',
                        ),
                        'padding_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                )
        ),
        'margin_group'   => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'    => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Margin', 'bespoke'),
                                'html'  => '',
                        ),
                        'margin_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                                'value' => 10,
                        ),
                        'margin_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                )
        ),
        'area_alignment' => array(
                'label'   => esc_html__('Text Alignment', 'bespoke'),
                'type'    => 'select',
                'value'   => 'text-left',
                'desc'    => esc_html__('Select your content text alignment.', 'bespoke'),
                'choices' => array(
                        'text-left'   => esc_html__('Left Align', 'bespoke'),
                        'text-center' => esc_html__('Center Align', 'bespoke'),
                        'text-right'  => esc_html__('Right Align', 'bespoke'),
                ),
        ),
);
