<?php

if(!defined('FW'))
{
    die('Forbidden');
}

$options = array(
        'sub_title_group'       => array(
                'type'          => 'group',
		'options'       => array(
                        'sec_sub_title'         => array(
                                'label'     => esc_html__('Sec. Sub Title', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert your section sub title here.', 'bespoke'),
                        ),
                        'sec_scolor'        => array(
                                'label'     => esc_html__('Color', 'bespoke'),
                                'type'      => 'color-picker',
                                'desc'      => esc_html__('Insert your section sub title color. Default color is #fd0060.', 'bespoke'),
                        ),
                        'sec_sub_size'         => array(
                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert sub title font size. Default font size is 16px.', 'bespoke'),
                        ),
                        'sec_sub_space'         => array(
                                'label'     => esc_html__('Letter Spacing', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert sub title letter spacing. Default space is 6.4px.', 'bespoke'),
                        ),
                        'sec_sub_height'         => array(
                                'label'     => esc_html__('Line Height', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert sub title line height. Default height is 20px.', 'bespoke'),
                        ),
                        'sec_sub_weight'                    => array(
                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 700,
                                'desc'    => esc_html__( 'Select your sub title font weight.', 'bespoke' ),
                                'choices' => array(
                                        100     => esc_html__( '100', 'bespoke' ),
                                        300     => esc_html__( '300', 'bespoke' ),
                                        400     => esc_html__( '400', 'bespoke' ),
                                        500     => esc_html__( '500', 'bespoke' ),
                                        600     => esc_html__( '600', 'bespoke' ),
                                        700     => esc_html__( '700', 'bespoke' ),
                                        900     => esc_html__( '900', 'bespoke' ),
                                ),
                        ),
                        'sec_sub_margin'         => array(
                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert sub title margin bottom. Default margin is 20px.', 'bespoke'),
                        ),
                )
        ),
        'title_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'sec_title'         => array(
                                'label'     => esc_html__('Sec. Title', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert your section title here.', 'bespoke'),
                        ),
                        'sec_tcolor'        => array(
                                'label'     => esc_html__('Color', 'bespoke'),
                                'type'      => 'color-picker',
                                'desc'      => esc_html__('Insert your section title color. Default color is #000000.', 'bespoke'),
                        ),
                        'sec_tsize'         => array(
                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title font size. Default font size is 50px.', 'bespoke'),
                        ),
                        'sec_theight'         => array(
                                'label'     => esc_html__('Line Height', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title line height.', 'bespoke'),
                        ),
                        'sec_tweight'                    => array(
                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 300,
                                'desc'    => esc_html__( 'Select your title font weight.', 'bespoke' ),
                                'choices' => array(
                                        100     => esc_html__( '100', 'bespoke' ),
                                        300     => esc_html__( '300', 'bespoke' ),
                                        400     => esc_html__( '400', 'bespoke' ),
                                        500     => esc_html__( '500', 'bespoke' ),
                                        600     => esc_html__( '600', 'bespoke' ),
                                        700     => esc_html__( '700', 'bespoke' ),
                                        900     => esc_html__( '900', 'bespoke' ),
                                ),
                        ),
                )
        ),
        'margin_group'   => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'    => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Area Margining', 'bespoke'),
                                'html'  => '',
                                'desc'  => esc_html__('Default margin bottom is 33px.', 'bespoke')
                        ),
                        'margin_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                                'value' => '',
                        ),
                        'margin_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                )
        ),
        'area_group'       => array(
                'type'          => 'group',
		'options'       => array(
                        'area_alignment'                    => array(
                                'label'   => esc_html__( 'Text Alignment', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 'text-center',
                                'desc'    => esc_html__( 'Select your section title area text alignment.', 'bespoke' ),
                                'choices' => array(
                                        'text-left'         => esc_html__( 'Left Align', 'bespoke' ),
                                        'text-center'       => esc_html__( 'Center Align', 'bespoke' ),
                                        'text-right'        => esc_html__( 'Right Align', 'bespoke' ),
                                ),
                        ),
                )
        )
);
