<?php

if(!defined('FW'))
{
    die('Forbidden');
}

$options = array(
        'is_fullwidth'       => array(
                'label'        => esc_html__('Is Full Width ?', 'bespoke'),
                'type'         => 'switch',
                'right-choice' => array(
                        'value' => '1',
                        'label' => esc_html__('Yes', 'bespoke')
                ),
                'left-choice'  => array(
                        'value' => '2',
                        'label' => esc_html__('No', 'bespoke')
                ),
                'value'        => '2',
                'desc'         => esc_html__('Do you want to make full width you section? Then please make it Yes.', 'bespoke'),
        ),
        'background_options' => array(
                'type'    => 'multi-picker',
                'label'   => false,
                'desc'    => false,
                'picker'  => array(
                        'background' => array(
                                'label'   => esc_html__('Background', 'bespoke'),
                                'desc'    => esc_html__('Select the background type for your section', 'bespoke'),
                                'attr'    => array('class' => 'fw-checkbox-float-left'),
                                'type'    => 'radio',
                                'choices' => array(
                                        '1' => esc_html__('None', 'bespoke'),
                                        '2' => esc_html__('Color BG', 'bespoke'),
                                        '3' => esc_html__('Image BG', 'bespoke'),
                                        '4' => esc_html__('Paralax BG', 'bespoke'),
                                        '5' => esc_html__('Video BG', 'bespoke'),
                                ),
                                'value'   => '1'
                        ),
                ),
                'choices' => array(
                        '1' => array(),
                        '2' => array(
                                'background_color' => array(
                                        'label' => esc_html__('', 'bespoke'),
                                        'desc'  => esc_html__('Select the background color', 'bespoke'),
                                        'value' => '',
                                        'type'  => 'rgba-color-picker'
                                ),
                        ),
                        '3' => array(
                                'bg_image'      => array(
                                        'label' => esc_html__('', 'bespoke'),
                                        'type'  => 'upload',
                                ),
                                'bg_repeat'     => array(
                                        'label'   => '',
                                        'type'    => 'short-select',
                                        'value'   => 'no-repeat',
                                        'desc'    => esc_html__('Select Background size.', 'bespoke'),
                                        'choices' => array(
                                                'no-repeat' => 'No Repeat',
                                                'repeat'    => 'Repeat'
                                        ),
                                ),
                                'bg_attachment' => array(
                                        'label'   => '',
                                        'type'    => 'short-select',
                                        'value'   => 'scroll',
                                        'desc'    => esc_html__('Select Background Attachment.', 'bespoke'),
                                        'choices' => array(
                                                'scroll' => 'Scroll',
                                                'fixed'  => 'Fixed'
                                        ),
                                ),
                                'bg_position'   => array(
                                        'label'   => '',
                                        'type'    => 'short-select',
                                        'value'   => '',
                                        'desc'    => esc_html__('Select Background Position.', 'bespoke'),
                                        'choices' => array(
                                                '0 0'           => 'None',
                                                'left top'      => 'left top',
                                                'left center'   => 'left center',
                                                'left bottom'   => 'left bottom',
                                                'right top'     => 'right top',
                                                'right center'  => 'right center',
                                                'right bottom'  => 'right bottom',
                                                'center top'    => 'center top',
                                                'center center' => 'center center',
                                                'center bottom' => 'center bottom'
                                        ),
                                ),
                                'bg_size'       => array(
                                        'label'   => '',
                                        'type'    => 'short-select',
                                        'value'   => '',
                                        'desc'    => esc_html__('Select Background size.', 'bespoke'),
                                        'choices' => array(
                                                'auto'      => 'Auto',
                                                'cover'     => 'Cover',
                                                '100% 100%' => '100% 100%'
                                        ),
                                ),
                        ),
                        '4' => array(
                                'is_fullheight'                    => array(
                                        'label'        => esc_html__( 'Is Full Height', 'bespoke' ),
                                        'type'         => 'switch',
                                        'right-choice' => array(
                                                'value' => '1',
                                                'label' => esc_html__( 'Yes', 'bespoke' )
                                        ),
                                        'left-choice'  => array(
                                                'value' => '2',
                                                'label' => esc_html__( 'No', 'bespoke' )
                                        ),
                                        'value'        => '2',
                                        'desc'         => esc_html__('Do you want to make this paralax section full height?', 'bespoke'),
                                ),
                                'is_middle'                    => array(
                                        'label'        => esc_html__( 'Is Content Middle', 'bespoke' ),
                                        'type'         => 'switch',
                                        'right-choice' => array(
                                                'value' => '1',
                                                'label' => esc_html__( 'Yes', 'bespoke' )
                                        ),
                                        'left-choice'  => array(
                                                'value' => '2',
                                                'label' => esc_html__( 'No', 'bespoke' )
                                        ),
                                        'value'        => '1',
                                        'desc'         => esc_html__('Do you want to position your section content in verticaly middle?', 'bespoke'),
                                ),
                                'par_bg_image'      => array(
                                        'label' => esc_html__('', 'bespoke'),
                                        'type'  => 'upload',
                                ),
                        ),
                        '5' => array(
                                'video_bg'                    => array(
                                        'label'       => esc_html__( 'Upload Video', 'bespoke' ),
                                        'desc'        => esc_html__( 'Please upload your video with Mp4 format. Otherwise video will not work.', 'bespoke' ),
                                        'type'        => 'upload',
                                        'images_only' => false
                                ),
                                'video_poster'             => array(
                                        'label' => esc_html__( 'Poster', 'bespoke' ),
                                        'desc'  => esc_html__( 'Upload a poster image for this video. Please use JPG format image for poster.', 'bespoke' ),
                                        'type'  => 'upload'
                                ),
                                'is_vd_fullheight'                    => array(
                                        'label'        => esc_html__( 'Is Full Height', 'bespoke' ),
                                        'type'         => 'switch',
                                        'right-choice' => array(
                                                'value' => '1',
                                                'label' => esc_html__( 'Yes', 'bespoke' )
                                        ),
                                        'left-choice'  => array(
                                                'value' => '2',
                                                'label' => esc_html__( 'No', 'bespoke' )
                                        ),
                                        'value'        => '2',
                                        'desc'         => esc_html__('Do you want to make this section full height?', 'bespoke'),
                                ),
                                'is_vd_middle'                    => array(
                                        'label'        => esc_html__( 'Is Content Middle', 'bespoke' ),
                                        'type'         => 'switch',
                                        'right-choice' => array(
                                                'value' => '1',
                                                'label' => esc_html__( 'Yes', 'bespoke' )
                                        ),
                                        'left-choice'  => array(
                                                'value' => '2',
                                                'label' => esc_html__( 'No', 'bespoke' )
                                        ),
                                        'value'        => '2',
                                        'desc'         => esc_html__('Do you want to position your section content in verticaly middle?', 'bespoke'),
                                ),
                        )
                ),
        ),
        'is_paralax'         => array(
                'type'    => 'multi-picker',
                'label'   => false,
                'desc'    => false,
                'value'   => array(
                        'option' => '2',
                ),
                'picker'  => array(
                        'option' => array(
                                'label'        => esc_html__('Is Paralax?', 'bespoke'),
                                'type'         => 'switch',
                                'right-choice' => array(
                                        'value' => '1',
                                        'label' => esc_html__('Yes', 'bespoke')
                                ),
                                'left-choice'  => array(
                                        'value' => '2',
                                        'label' => esc_html__('No', 'bespoke')
                                ),
                                'value'        => '2',
                        )
                ),
                'choices' => array(
                        '1' => array(
                                'sec_number'      => array(
                                        'label' => esc_html__('Section Number', 'bespoke'),
                                        'type'  => 'short-text',
                                        'desc'  => esc_html__('Insert your paralax section Sl number. Number should be unique', 'bespoke')
                                ),
                                'para_image'      => array(
                                        'label' => esc_html__('Paralax Img', 'bespoke'),
                                        'type'  => 'upload',
                                ),
                        ),
                ),
        ),
        'is_overlay'         => array(
                'type'    => 'multi-picker',
                'label'   => false,
                'desc'    => false,
                'value'   => array(
                        'option' => '2',
                ),
                'picker'  => array(
                        'option' => array(
                                'label'        => esc_html__('Is Overlay ?', 'bespoke'),
                                'type'         => 'switch',
                                'right-choice' => array(
                                        'value' => '1',
                                        'label' => esc_html__('Yes', 'bespoke')
                                ),
                                'left-choice'  => array(
                                        'value' => '2',
                                        'label' => esc_html__('No', 'bespoke')
                                ),
                                'value'        => '2',
                        )
                ),
                'choices' => array(
                        '1' => array(
                                'overlay_color' => array(
                                        'label' => '',
                                        'type'  => 'rgba-color-picker',
                                        'value' => '',
                                        'desc'  => esc_html__('Select your overlay RGBA color.', 'bespoke'),
                                ),
                        ),
                ),
        ),
        'is_absolute'         => array(
                'type'    => 'multi-picker',
                'label'   => false,
                'desc'    => false,
                'value'   => array(
                        'option' => '2',
                ),
                'picker'  => array(
                        'ab_option' => array(
                                'label'        => esc_html__('Absolute Container?', 'bespoke'),
                                'type'         => 'switch',
                                'right-choice' => array(
                                        'value' => '1',
                                        'label' => esc_html__('Yes', 'bespoke')
                                ),
                                'left-choice'  => array(
                                        'value' => '2',
                                        'label' => esc_html__('No', 'bespoke')
                                ),
                                'value'        => '2',
                        )
                ),
                'choices' => array(
                        '1' => array(
                                'ab_top' => array(
                                        'label' => esc_html__('Top Offset', 'bespoke'),
                                        'type'  => 'text',
                                        'value' => '',
                                        'desc'  => esc_html__('Insert position top.', 'bespoke'),
                                ),
                                'ab_bottom' => array(
                                        'label' => esc_html__('Bottom Offset', 'bespoke'),
                                        'type'  => 'text',
                                        'value' => '',
                                        'desc'  => esc_html__('Insert position bottom.', 'bespoke'),
                                ),
                        ),
                ),
        ),
        'z_index_group'      => array(
                'type'    => 'group',
                'options' => array(
                        'z_indexs'   => array(
                                'label' => esc_html__('Z Index', 'bespoke'),
                                'desc'  => esc_html__('Insert z index. Default z index is none.', 'bespoke'),
                                'type'  => 'text',
                        ),

                )
        ),
        'is_scrolldown'         => array(
                'type'    => 'multi-picker',
                'label'   => false,
                'desc'    => FALSE,
                'value'   => array(
                        'option' => '2',
                ),
                'picker'  => array(
                        'option' => array(
                                'label'        => esc_html__('Is Scroll Down?', 'bespoke'),
                                'type'         => 'switch',
                                'desc'         => esc_html__('Do you want to show scrool down circle button? Then please turn it to Yes and Insert your scrool to section ID.', 'bespoke'),
                                'right-choice' => array(
                                        'value' => '1',
                                        'label' => esc_html__('Yes', 'bespoke')
                                ),
                                'left-choice'  => array(
                                        'value' => '2',
                                        'label' => esc_html__('No', 'bespoke')
                                ),
                                'value'        => '2',
                        )
                ),
                'choices' => array(
                        '1' => array(
                                'sec_ids' => array(
                                        'label' => '',
                                        'type'  => 'text',
                                        'value' => '',
                                        'desc'  => esc_html__('Insert your scrool to section ID.', 'bespoke'),
                                ),
                                'btn_style'   => array(
                                        'label'   => '',
                                        'type'    => 'short-select',
                                        'value'   => 1,
                                        'desc'    => esc_html__('Select your scroll btn style.', 'bespoke'),
                                        'choices' => array(
                                                1      => 'Normal',
                                                2      => 'Gradient',
                                        ),
                                ),
                        ),
                ),
        ),
        'padding_group'      => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'     => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Padding', 'bespoke'),
                                'html'  => '',
                        ),
                        'padding_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('bottom', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('left', 'bespoke'),
                                'type'  => 'short-text',
                        ),

                )
        ),
        'margin_group'       => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'    => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Margin', 'bespoke'),
                                'html'  => '',
                        ),
                        'margin_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('bottom', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('left', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                )
        ),
        'custom_class'       => array(
                'label' => esc_html__('Custom Class', 'bespoke'),
                'desc'  => esc_html__('Insert custom Class name for extra css if you need.', 'bespoke'),
                'type'  => 'text',
        ),
        'custom_id'          => array(
                'label' => esc_html__('Custom ID', 'bespoke'),
                'desc'  => esc_html__('Insert custom ID name for extra css if you need.', 'bespoke'),
                'type'  => 'text',
        ),
);
