<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

/**
 * @var array $atts
 */

if ( empty( $atts['image'] ) ) {
	return;
}

$css = '';
$area_alignment = 'text-left';
if($atts['area_alignment'] != ''){
    $area_alignment = $atts['area_alignment'];
}

if ( isset($atts['image']['url']) && !empty($atts['image']['url']) ) {
	$image = $atts['image']['url'];
} 

$alt = get_post_meta($atts['image']['attachment_id'], '_wp_attachment_image_alt', true);

$img_attributes = array(
	'src' => $image,
	'alt' => $alt ? $alt : $image
);

$css .= ($atts['padding_top'] != '') ? 'padding-top: '.$atts['padding_top'].'px; ' : '';
$css .= ($atts['padding_right'] != '') ? 'padding-right: '.$atts['padding_right'].'px; ' : '';
$css .= ($atts['padding_bottom'] != '') ? 'padding-bottom: '.$atts['padding_bottom'].'px; ' : '';
$css .= ($atts['padding_left'] != '') ? 'padding-left: '.$atts['padding_left'].'px; ' : '';
$css .= ($atts['margin_top'] != '') ? 'margin-top: '.$atts['margin_top'].'px; ' : '';
$css .= ($atts['margin_right'] != '') ? 'margin-right: '.$atts['margin_right'].'px; ' : '';
$css .= ($atts['margin_bottom'] != '') ? 'margin-bottom: '.$atts['margin_bottom'].'px; ' : '';
$css .= ($atts['margin_left'] != '') ? 'margin-left: '.$atts['margin_left'].'px; ' : '';



if ( empty( $atts['link'] ) ) {
        echo '<div class="imagesDiv '.$area_alignment.'" style="'.  esc_attr($css).'">';
            echo fw_html_tag('img', $img_attributes);
        echo '</div>';
} else {
        echo '<div class="imagesDiv '.$area_alignment.'" style="'.  esc_attr($css).'">';
	echo fw_html_tag('a', array(
		'href' => $atts['link'],
		'target' => $atts['target']
	), fw_html_tag('img',$img_attributes));
        echo '</div>';
}
