<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
	'image'            => array(
		'type'  => 'upload',
		'label' => esc_html__( 'Choose Image', 'bespoke' ),
		'desc'  => esc_html__( 'Either upload a new, or choose an existing image from your media library', 'bespoke' )
	),
	'image-link-group' => array(
		'type'    => 'group',
		'options' => array(
			'link'   => array(
				'type'  => 'text',
				'label' => esc_html__( 'Image Link', 'bespoke' ),
				'desc'  => esc_html__( 'Where should your image link to?', 'bespoke' )
			),
			'target' => array(
				'type'         => 'switch',
				'label'        => esc_html__( 'Open Link in New Window', 'bespoke' ),
				'desc'         => esc_html__( 'Select here if you want to open the linked page in a new window', 'bespoke' ),
				'right-choice' => array(
					'value' => '_blank',
					'label' => esc_html__( 'Yes', 'bespoke' ),
				),
				'left-choice'  => array(
					'value' => '_self',
					'label' => esc_html__( 'No', 'bespoke' ),
				),
			),
		)
	),
        'padding_group'      => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'     => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Padding', 'bespoke'),
                                'html'  => '',
                        ),
                        'padding_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),

                )
        ),
        'margin_group'      => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'     => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Margin', 'bespoke'),
                                'html'  => '',
                        ),
                        'margin_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                                'value' => '',
                        ),
                        'margin_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),

                )
        ),
        'area_alignment'                    => array(
                'label'   => esc_html__( 'Text Alignment', 'bespoke' ),
                'type'    => 'select',
                'value'   => 'text-left',
                'desc'    => esc_html__( 'Select your heading alignment.', 'bespoke' ),
                'choices' => array(
                        'text-left'         => esc_html__( 'Left Align', 'bespoke' ),
                        'text-center'       => esc_html__( 'Center Align', 'bespoke' ),
                        'text-right'        => esc_html__( 'Right Align', 'bespoke' ),
                ),
        ),
);

