<?php
if (!defined('FW')) {
    die('Forbidden');
}

$orderby = 'date'; $order = 'DESC'; $number_of_item = 3;

extract($atts);

?>
<div class="row">
    <?php
        $recent = array(
            'post_type'         => 'post',
            'post_status'       => 'publish',
            'posts_per_page'    => $number_of_item,
            'orderby'           => $orderby,
            'order'             => $order
        );
        
        $loop = new WP_Query($recent);
        if($loop->have_posts()):
            while($loop->have_posts()):
                $loop->the_post();
                $authorurl =  get_author_posts_url(get_the_author_meta('ID'));
                
                $audio_src = '';
                $video_src = '';
                $gallery_images = array();
                if(defined('FW')){
                    $audio_src = fw_get_db_post_option(get_the_ID(), 'audio_src', '');
                    $video_src = fw_get_db_post_option(get_the_ID(), 'video_src', '');
                    $gallery_images = fw_get_db_post_option(get_the_ID(), 'gallery_images', array());
                }
                ?>
                <div class="col-sm-4 noPadding">
                    <div class="singleBlog">
                        <div class="blogThumb shortcodeThumb">
                            <?php if(is_array($gallery_images) && count($gallery_images) > 0): ?>
                                <div id="loopblog_<?php echo get_the_ID(); ?>" class="carousel slide loopblogcarousel" data-ride="carousel">
                                    <div class="carousel-inner">
                                        <?php $i = 1; foreach($gallery_images as $gall): ?>
                                            <div class="item <?php if($i == 1): echo 'active'; endif; ?>">
                                                <?php
                                                    $imgs = wp_get_attachment_image_src($gall['attachment_id'], 'bespoke_folio_blog');
                                                    echo '<img src="'.$imgs[0].'" alt="'.esc_attr(get_the_title()).'"/>';
                                                ?>
                                            </div>
                                        <?php $i++; endforeach; ?>
                                    </div>
                                    <a class="carousel-control-prev" href="#loopblog_<?php echo get_the_ID(); ?>" role="button" data-slide="prev">
                                        <i class="fa fa-angle-left"></i>
                                    </a>
                                    <a class="carousel-control-next" href="#loopblog_<?php echo get_the_ID(); ?>" role="button" data-slide="next">
                                        <i class="fa fa-angle-right"></i>
                                    </a>
                                </div>
                            <?php else: ?>
                                <?php if(has_post_thumbnail()): ?>
                                    <?php echo get_the_post_thumbnail(get_the_ID(), 'bespoke_folio_blog'); ?>
                                <?php else: ?>
                                    <img src="http://themewar.com/placeholder.php?size=420x280" alt="<?php echo esc_attr(get_the_title()); ?>">
                                <?php endif; ?>
                                <?php if(get_post_format() == 'audio' && $audio_src != ''): ?>
                                    <a href="<?php echo esc_url($audio_src) ?>" class="iframeplay"><i class="pe-7s-volume"></i></a>
                                <?php elseif(get_post_format() == 'video' && $video_src != ''): ?>
                                    <a href="<?php echo esc_url($video_src) ?>" class="iframeplay"><i class="pe-7s-video"></i></a>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="blogDec">
                            <div class="blogDate"><?php echo get_the_time('F, d, Y'); ?></div>
                            <h2 class="blogTitle"><a href="<?php echo get_the_permalink(); ?>">
                                <?php
                                     echo wp_kses(get_the_title(), array());
                                ?>
                            </a></h2>
                            <div class="bperaDiv clearfix">
                                <p>
                                    <?php 
                                        if(strlen(wp_kses(get_the_content(), array())) > 130)
                                        {
                                            $lcount = 130;
                                            $contents = wp_kses(get_the_content(), array());
                                            echo substr($contents, 0, ($spos = strpos($contents, ' ', $lcount = strlen($contents) > 130 ? $lcount : 130)) ? $spos : $lcount ); 
                                        }
                                        else
                                        {
                                            echo wp_kses(get_the_content(), array());
                                        }
                                    ?>
                                </p>
                            </div>
                            <div class="blogBott">
                                <div class="bauthor"><?php echo esc_html__('By', 'bespoke') ?><a href="<?php echo esc_url($authorurl); ?>"><?php echo get_the_author(); ?></a></div>
                                <div class="blogComs"><img src="<?php echo BESPOKE_ASSETS_IMAGES_URL; ?>/comment.png" alt="<?php echo esc_attr(get_the_title()); ?>"><a href="<?php echo get_the_permalink(); ?>"><?php comments_number( esc_html__('0 Comment', 'bespoke'), esc_html__('1 Comment', 'bespoke'), '% '.esc_html__('Comments', 'bespoke') ); ?></a></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            endwhile;
        endif;
        wp_reset_postdata();
    ?>
</div>