<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
        'icon_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'box_img'             => array(
                                'label' =>esc_html__( 'Image', 'bespoke' ),
                                'desc'  => esc_html('Upload your box image. Image size should be 537x250px.'),
                                'type'  => 'upload'
                        ),
                        'box_img_margin'         => array(
                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert your box image margin bottom. Default margin is 64px.', 'bespoke'),
                        ),
                )
        ),
        'title_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'title'         => array(
                                'label'     => esc_html__('Title', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert your box title here.', 'bespoke'),
                        ),
                        't_color'        => array(
                                'label'     => esc_html__('Color', 'bespoke'),
                                'type'      => 'color-picker',
                                'desc'      => esc_html__('Insert your box title color. Default color is #000.', 'bespoke'),
                        ),
                        't_size'         => array(
                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title font size. Default font size is 20px.', 'bespoke'),
                        ),
                        't_space'         => array(
                                'label'     => esc_html__('Fotn Spacing', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title font spacing. Default font spacing is 8px.', 'bespoke'),
                        ),
                        't_weight'                    => array(
                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 700,
                                'desc'    => esc_html__( 'Select your title font weight.', 'bespoke' ),
                                'choices' => array(
                                        100     => esc_html__( '100', 'bespoke' ),
                                        300     => esc_html__( '300', 'bespoke' ),
                                        400     => esc_html__( '400', 'bespoke' ),
                                        500     => esc_html__( '500', 'bespoke' ),
                                        600     => esc_html__( '600', 'bespoke' ),
                                        700     => esc_html__( '700', 'bespoke' ),
                                        900     => esc_html__( '900', 'bespoke' ),
                                ),
                        ),
                        't_margin'         => array(
                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title margin bottom. Default margin bottom is 30px.', 'bespoke'),
                        ),
                )
        ),
        'content_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'content'         => array(
                                'label'     => esc_html__('Content', 'bespoke'),
                                'type'      => 'textarea',
                                'value'     => '',
                                'desc'      => esc_html__('Insert your box content here.', 'bespoke'),
                        ),
                        'c_color'        => array(
                                'label'     => esc_html__('Color', 'bespoke'),
                                'type'      => 'color-picker',
                                'desc'      => esc_html__('Insert your box content color. Default color is #999999.', 'bespoke'),
                        ),
                        'c_size'         => array(
                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert content font size. Default font size is 20px.', 'bespoke'),
                        ),
                        'c_height'         => array(
                                'label'     => esc_html__('Line Height', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert content line height. Default height is 36px.', 'bespoke'),
                        ),
                        'c_weight'                    => array(
                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 300,
                                'desc'    => esc_html__( 'Select your box content font weight.', 'bespoke' ),
                                'choices' => array(
                                        100     => esc_html__( '100', 'bespoke' ),
                                        300     => esc_html__( '300', 'bespoke' ),
                                        400     => esc_html__( '400', 'bespoke' ),
                                        500     => esc_html__( '500', 'bespoke' ),
                                        600     => esc_html__( '600', 'bespoke' ),
                                        700     => esc_html__( '700', 'bespoke' ),
                                        900     => esc_html__( '900', 'bespoke' ),
                                ),
                        ),
                )
        ),
	'margin_group'   => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'    => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Area Margin', 'bespoke'),
                                'html'  => '',
                                'desc'  => esc_html__('', 'bespoke')
                        ),
                        'margin_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                                'value' => '',
                        ),
                        'margin_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                )
        ),
	'align_group'   => array(
                'type'    => 'group',
                'options' => array(
                        'area_alginment'                    => array(
                                'label'   => esc_html__( 'Area Alignment', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 'text-center',
                                'desc'    => esc_html__( 'Select your area text alignment.', 'bespoke' ),
                                'choices' => array(
                                        'text-left'     => esc_html__( 'Left Alignment', 'bespoke' ),
                                        'text-center'     => esc_html__( 'Center Alignment', 'bespoke' ),
                                        'text-right'     => esc_html__( 'Right Alignment', 'bespoke' ),
                                ),
                        ),
                )
        )
);