<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
        'icon_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'icon_or_img'       => array(
                                'type'         => 'multi-picker',
                                'label'        => false,
                                'desc'         => false,
                                'picker'       => array(
                                        'iorimg' => array(
                                                'label'        =>esc_html__( 'Icon Or Image', 'bespoke' ),
                                                'type'         => 'switch',
                                                'right-choice' => array(
                                                        'value' => '1',
                                                        'label' =>esc_html__( 'Image', 'bespoke' )
                                                ),
                                                'left-choice'  => array(
                                                        'value' => '2',
                                                        'label' =>esc_html__( 'Icon', 'bespoke' )
                                                ),
                                                'value'        => '1',
                                                'desc'         => esc_html__('Choose whatever you want to use, icon or image?', 'bespoke'),
                                        )
                                ),
                                'choices'      => array(
                                        '1'  => array(
                                                'icon_image'             => array(
                                                        'label' =>esc_html__( 'Image', 'bespoke' ),
                                                        'desc'  => esc_html('Upload your box image. Image size should be 90x90px.'),
                                                        'type'  => 'upload'
                                                ),
                                                'icon_img_bottom'             => array(
                                                        'label' =>esc_html__( 'Margin Bottom', 'bespoke' ),
                                                        'desc'  => esc_html('Insert your image margin bottom. Default margin bottom is 40px.'),
                                                        'type'  => 'text'
                                                ),
                                        ),
                                        '2' => array(
                                                'icon'    => array(
                                                        'type'  => 'icon',
                                                        'label' => esc_html__('Choose an Icon', 'bespoke'),
                                                        'set'  => 'tw_line_icon_set',
                                                ),
                                                'i_color'        => array(
                                                        'label'     => esc_html__('Color', 'bespoke'),
                                                        'type'      => 'color-picker',
                                                        'desc'      => esc_html__('Insert your icon color. Default color is #fd0060.', 'bespoke'),
                                                ),
                                                'i_size'         => array(
                                                        'label'     => esc_html__('Fotn Size', 'bespoke'),
                                                        'type'      => 'text',
                                                        'value'     => '',
                                                        'desc'      => esc_html__('Insert icon font size.', 'bespoke'),
                                                ),
                                                'i_bottom'             => array(
                                                        'label' =>esc_html__( 'Margin Bottom', 'bespoke' ),
                                                        'desc'  => esc_html('Insert your icon margin bottom. Default margin bottom is 40px.'),
                                                        'type'  => 'text'
                                                ),
                                        ),
                                ),
                                'show_borders' => false,
                        )
                )
        ),
        'title_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'title'         => array(
                                'label'     => esc_html__('Title', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert your box title here.', 'bespoke'),
                        ),
                        't_color'        => array(
                                'label'     => esc_html__('Color', 'bespoke'),
                                'type'      => 'color-picker',
                                'desc'      => esc_html__('Insert your box title color. Default color is #000.', 'bespoke'),
                        ),
                        't_size'         => array(
                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title font size. Default font size is 20px.', 'bespoke'),
                        ),
                        't_space'         => array(
                                'label'     => esc_html__('Fotn Spacing', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title font spacing. Default font spacing is 8px.', 'bespoke'),
                        ),
                        't_weight'                    => array(
                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 700,
                                'desc'    => esc_html__( 'Select your title font weight.', 'bespoke' ),
                                'choices' => array(
                                        100     => esc_html__( '100', 'bespoke' ),
                                        300     => esc_html__( '300', 'bespoke' ),
                                        400     => esc_html__( '400', 'bespoke' ),
                                        500     => esc_html__( '500', 'bespoke' ),
                                        600     => esc_html__( '600', 'bespoke' ),
                                        700     => esc_html__( '700', 'bespoke' ),
                                        900     => esc_html__( '900', 'bespoke' ),
                                ),
                        ),
                        't_margin'         => array(
                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert title margin bottom. Default margin bottom is 65px.', 'bespoke'),
                        ),
                )
        ),
        'content_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'content'         => array(
                                'label'     => esc_html__('Content', 'bespoke'),
                                'type'      => 'textarea',
                                'value'     => '',
                                'desc'      => esc_html__('Insert your box content here.', 'bespoke'),
                        ),
                        'c_color'        => array(
                                'label'     => esc_html__('Color', 'bespoke'),
                                'type'      => 'color-picker',
                                'desc'      => esc_html__('Insert your box content color. Default color is #999999.', 'bespoke'),
                        ),
                        'c_size'         => array(
                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert content font size. Default font size is 20px.', 'bespoke'),
                        ),
                        'c_height'         => array(
                                'label'     => esc_html__('Line Height', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert content line height. Default height is 36px.', 'bespoke'),
                        ),
                        'c_weight'                    => array(
                                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                                'type'    => 'select',
                                'value'   => 300,
                                'desc'    => esc_html__( 'Select your box content font weight.', 'bespoke' ),
                                'choices' => array(
                                        100     => esc_html__( '100', 'bespoke' ),
                                        300     => esc_html__( '300', 'bespoke' ),
                                        400     => esc_html__( '400', 'bespoke' ),
                                        500     => esc_html__( '500', 'bespoke' ),
                                        600     => esc_html__( '600', 'bespoke' ),
                                        700     => esc_html__( '700', 'bespoke' ),
                                        900     => esc_html__( '900', 'bespoke' ),
                                ),
                        ),
                        'c_margin'         => array(
                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert content margin bottom. Default margin bottom is 36px.', 'bespoke'),
                        ),
                )
        ),
        'list_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'lists' => array(
                                'label'         => esc_html__( 'List Item', 'bespoke' ),
                                'popup-title'   => esc_html__( 'Add/Edit List Item', 'bespoke' ),
                                'desc'          => esc_html__( 'Here you can add, remove and edit your List Item.', 'bespoke' ),
                                'type'          => 'addable-popup',
                                'template'      => '{{=list_content}}',
                                'popup-options' => array(
                                        'list_content'       => array(
                                                'label' => esc_html__( 'List Item Content', 'bespoke' ),
                                                'desc'  => esc_html__( 'Insert your list content here.', 'bespoke' ),
                                                'type'  => 'textarea',
                                                'teeny' => true
                                        )
                                )
                        ),
                        'l_color'        => array(
                                'label'     => esc_html__('Color', 'bespoke'),
                                'type'      => 'color-picker',
                                'desc'      => esc_html__('Insert your list content color. Default color is #333333.', 'bespoke'),
                        ),
                        'l_size'         => array(
                                'label'     => esc_html__('Fotn Size', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert list content font size. Default font size is 20px.', 'bespoke'),
                        ),
                        'list_margin'         => array(
                                'label'     => esc_html__('Margin Bottom', 'bespoke'),
                                'type'      => 'text',
                                'value'     => '',
                                'desc'      => esc_html__('Insert list margin bottom. Default margin bottom is 58px.', 'bespoke'),
                        ),
                )
        ),
        'link_group'           => array(
                'type'          => 'group',
		'options'       => array(
                        'l_label'         => array(
                                'label'     => esc_html__('Link Label', 'bespoke'),
                                'type'      => 'text',
                                'value'     => 'Learn More',
                                'desc'      => esc_html__('Insert your box link lebel. Leave blank if you dont want to show the link.', 'bespoke'),
                        ),
                        'l_link'        => array(
                                'label'     => esc_html__('Link URL', 'bespoke'),
                                'type'      => 'text',
                                'desc'      => esc_html__('Insert your link URL.', 'bespoke'),
                        ),
                )
        ),
	'margin_group'   => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'    => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Area Margin', 'bespoke'),
                                'html'  => '',
                                'desc'  => esc_html__('', 'bespoke')
                        ),
                        'margin_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                                'value' => '',
                        ),
                        'margin_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                )
        )
);