<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
        'tag'                    => array(
                'label'   => esc_html__( 'Tag', 'bespoke' ),
                'type'    => 'select',
                'value'   => 2,
                'desc'    => esc_html__( 'Please select your heading tag. By Default we used H2 Tag.', 'bespoke' ),
                'choices' => array(
                        1     => esc_html__( 'H1', 'bespoke' ),
                        2     => esc_html__( 'H2', 'bespoke' ),
                        3     => esc_html__( 'H3', 'bespoke' ),
                        4     => esc_html__( 'H4', 'bespoke' ),
                        5     => esc_html__( 'H5', 'bespoke' ),
                        6     => esc_html__( 'H6', 'bespoke' ),
                ),
        ),
        'heading' => array(
		'type'   => 'text',
		'label'  => esc_html__( 'Your Heading', 'bespoke' ),
		'desc'   => esc_html__( 'Insert your heading text.', 'bespoke' )
	),
        'size' => array(
		'type'   => 'text',
		'label'  => esc_html__( 'Font Size', 'bespoke' ),
		'desc'   => esc_html__( 'Default font size is 26px. Insert just numeric value. Don\'t need to insert "px".', 'bespoke' )
	),
        'color_or_gradient'       => array(
		'type'         => 'multi-picker',
		'label'        => false,
		'desc'         => false,
		'picker'       => array(
			'gadget' => array(
				'label'   =>esc_html__( 'Color or Gradient', 'bespoke' ),
				'type'    => 'select',
				'choices' => array(
					'1'  =>esc_html__( 'Color', 'bespoke' ),
					'2' =>esc_html__( 'Gradient', 'bespoke' )
				),
				'desc'    => esc_html__('Please choose your header color format.', 'bespoke'),
			)
		),
		'choices'      => array(
			'1'  => array(
				'color' => array(
                                        'label' => esc_html__('Heading Color', 'bespoke'),
                                        'desc'  => esc_html__('Insert your Heading color. Default color is #000000.', 'bespoke'),
                                        'type'  => 'color-picker',
                                        'value' => ''
                                ),
			),
			'2' => array(
				'color1' => array(
                                        'label' => esc_html__('Start Color', 'bespoke'),
                                        'desc'  => esc_html__('Insert your gradient start color.', 'bespoke'),
                                        'type'  => 'color-picker',
                                        'value' => '#ff00de'
                                ),
				'color2' => array(
                                        'label' => esc_html__('Mid Color', 'bespoke'),
                                        'desc'  => esc_html__('Insert your radient mid color.', 'bespoke'),
                                        'type'  => 'color-picker',
                                        'value' => '#FF696F'
                                ),
				'color3' => array(
                                        'label' => esc_html__('End Color', 'bespoke'),
                                        'desc'  => esc_html__('Insert your gradient end color.', 'bespoke'),
                                        'type'  => 'color-picker',
                                        'value' => '#ffd200'
                                ),
			),
		),
		'show_borders' => false,
	),
        'shadow' => array(
		'type'   => 'text',
		'label'  => esc_html__( 'Text Shadow', 'bespoke' ),
		'desc'   => esc_html__( 'Please insert text shadow if you want. Format should look like this 0px 0px 0px rgba(0, 0, 0, 0).', 'bespoke' )
	),
        'spacing' => array(
		'type'   => 'text',
		'label'  => esc_html__( 'Letter Spacing', 'bespoke' ),
		'desc'   => esc_html__( 'Please insert your letter spacing. Default spacing is 0px.', 'bespoke' )
	),
        'height' => array(
		'type'   => 'text',
		'label'  => esc_html__( 'Line Height', 'bespoke' ),
		'desc'   => esc_html__( 'Please insert your line height.', 'bespoke' )
	),
        'weight'                    => array(
                'label'   => esc_html__( 'Font Weight', 'bespoke' ),
                'type'    => 'select',
                'value'   => 700,
                'desc'    => esc_html__( 'Select your content font weight.', 'bespoke' ),
                'choices' => array(
                        100     => esc_html__( '100', 'bespoke' ),
                        300     => esc_html__( '300', 'bespoke' ),
                        400     => esc_html__( '400', 'bespoke' ),
                        500     => esc_html__( '500', 'bespoke' ),
                        600     => esc_html__( '600', 'bespoke' ),
                        700     => esc_html__( '700', 'bespoke' ),
                        900     => esc_html__( '900', 'bespoke' ),
                ),
        ),
        'style'                    => array(
                'label'   => esc_html__( 'Font Style', 'bespoke' ),
                'type'    => 'select',
                'value'   => 'font-normal',
                'desc'    => esc_html__( 'Select your desc font style.', 'bespoke' ),
                'choices' => array(
                        'font-normal'     => esc_html__( 'Normal', 'bespoke' ),
                        'font-italic'     => esc_html__( 'Italic', 'bespoke' ),
                ),
        ),
        'padding_group'      => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'     => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Padding', 'bespoke'),
                                'html'  => '',
                        ),
                        'padding_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'padding_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),

                )
        ),
        'margin_group'      => array(
                'type'    => 'group',
                'options' => array(
                        'html_label'     => array(
                                'type'  => 'html',
                                'value' => '',
                                'label' => esc_html__('Margin', 'bespoke'),
                                'html'  => '',
                        ),
                        'margin_top'    => array(
                                'label' => false,
                                'desc'  => esc_html__('Top', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_right'  => array(
                                'label' => false,
                                'desc'  => esc_html__('Right', 'bespoke'),
                                'type'  => 'short-text',
                        ),
                        'margin_bottom' => array(
                                'label' => false,
                                'desc'  => esc_html__('Bottom', 'bespoke'),
                                'type'  => 'short-text',
                                'value' => '',
                        ),
                        'margin_left'   => array(
                                'label' => false,
                                'desc'  => esc_html__('Left', 'bespoke'),
                                'type'  => 'short-text',
                        ),

                )
        ),
        'area_alignment'                    => array(
                'label'   => esc_html__( 'Text Alignment', 'bespoke' ),
                'type'    => 'select',
                'value'   => 'text-left',
                'desc'    => esc_html__( 'Select your heading alignment.', 'bespoke' ),
                'choices' => array(
                        'text-left'         => esc_html__( 'Left Align', 'bespoke' ),
                        'text-center'       => esc_html__( 'Center Align', 'bespoke' ),
                        'text-right'        => esc_html__( 'Right Align', 'bespoke' ),
                ),
        ),
        
);
