<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$options = array(
    'button_label'                    => array(
            'label'        => esc_html__( 'Button Label', 'bespoke' ),
            'type'         => 'text',
            'value'        => '',
            'desc'         => esc_html__( 'Insert your button label here.', 'bespoke' ),
    ),
    'icon'    => array(
            'type'  => 'icon',
            'label' => esc_html__('Choose an Icon', 'bespoke'),
            'set'  => 'tw_line_icon_set',
    ),
    'is_vd_btns'                    => array(
            'label'        => esc_html__( 'Is Video Btn', 'bespoke' ),
            'type'         => 'switch',
            'right-choice' => array(
                    'value' => '1',
                    'label' => esc_html__( 'Yes', 'bespoke' )
            ),
            'left-choice'  => array(
                    'value' => '2',
                    'label' => esc_html__( 'No', 'bespoke' )
            ),
            'value'        => '2',
            'desc'         => esc_html__( 'Do you want to open video popup onclick this button? Turn it to yes and Insert a video link to Button Link field.', 'bespoke' ),
    ),
    'button_link'                    => array(
            'label'        => esc_html__( 'Button Link', 'bespoke' ),
            'type'         => 'text',
            'value'        => '',
            'desc'         => esc_html__( 'Insert your button link here. External, Internal or Video', 'bespoke' ),
    ),
    'color_group'  => array(
            'type'    => 'group',
            'options' => array(
                    'btn_colors'        => array(
                            'label'     => esc_html__('Text Color', 'bespoke'),
                            'type'      => 'color-picker',
                            'desc'      => esc_html__('Insert your button normal text color. Default text color is #FFFFFF.', 'bespoke'),
                    ),
                    'btn_h_colors'        => array(
                            'label'     => esc_html__('Hover Text Color', 'bespoke'),
                            'type'      => 'color-picker',
                            'desc'      => esc_html__('Insert your button hover text color. Default text color is #FFFFFF.', 'bespoke'),
                    ),
                    'btn_i_colors'        => array(
                            'label'     => esc_html__('Icon Color', 'bespoke'),
                            'type'      => 'color-picker',
                            'desc'      => esc_html__('Insert your button normal icon color. Default text color is #FFFFFF.', 'bespoke'),
                    ),
                    'btn_i_h_colors'        => array(
                            'label'     => esc_html__('Hover Icon Color', 'bespoke'),
                            'type'      => 'color-picker',
                            'desc'      => esc_html__('Insert your button hover icon color. Default text color is #FFFFFF.', 'bespoke'),
                    ),
            )
    ),
    'icon_group'           => array(
            'type'          => 'group',
            'options'       => array(
                    'color_or_grad'       => array(
                            'type'         => 'multi-picker',
                            'label'        => false,
                            'desc'         => false,
                            'picker'       => array(
                                    'corg' => array(
                                            'label'        =>esc_html__( 'Color Or Gradient BG', 'bespoke' ),
                                            'type'         => 'switch',
                                            'right-choice' => array(
                                                    'value' => '1',
                                                    'label' =>esc_html__( 'Color BG', 'bespoke' )
                                            ),
                                            'left-choice'  => array(
                                                    'value' => '2',
                                                    'label' =>esc_html__( 'Gradient BG', 'bespoke' )
                                            ),
                                            'value'        => '1',
                                            'desc'         => esc_html__('Select your button BG type.', 'bespoke'),
                                    )
                            ),
                            'choices'      => array(
                                    '1'  => array(
                                            'b_bg_color'        => array(
                                                    'label'     => esc_html__('BG Color', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'desc'      => esc_html__('Insert your button normal bg color. Default BG color is #fb0060.', 'bespoke'),
                                            ),
                                            'b_bg_h_color'        => array(
                                                    'label'     => esc_html__('Hover BG Color', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'desc'      => esc_html__('Insert your button hover bg color. Default hover BG color is #1d1d1d.', 'bespoke'),
                                            ),
                                    ),
                                    '2' => array(
                                            'b_g_1'        => array(
                                                    'label'     => esc_html__('Gradient Color 1', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'value'     => '#36146a',
                                                    'desc'      => esc_html__('Insert your button gradient bg color point 1 ( 0% - 35% ). Default color is #36146a.', 'bespoke'),
                                            ),
                                            'b_g_2'        => array(
                                                    'label'     => esc_html__('Gradient Color 2', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'value'     => '#581068',
                                                    'desc'      => esc_html__('Insert your button gradient bg color point 2 ( 36% - 46% ). Default color is #581068.', 'bespoke'),
                                            ),
                                            'b_g_3'        => array(
                                                    'label'     => esc_html__('Gradient Color 3', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'value'     => '#640E67',
                                                    'desc'      => esc_html__('Insert your button gradient bg color point 3 ( 47% - 50% ). Default color is #640E67.', 'bespoke'),
                                            ),
                                            'b_g_4'        => array(
                                                    'label'     => esc_html__('Gradient Color 4', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'value'     => '#ff0060',
                                                    'desc'      => esc_html__('Insert your button gradient bg color point 4 ( 51% - 100% ). Default color is #ff0060.', 'bespoke'),
                                            ),
                                            'b_h_g_1'        => array(
                                                    'label'     => esc_html__('Hover Gradient Color 1', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'value'     => '#fd0060',
                                                    'desc'      => esc_html__('Insert your button hover gradient bg color point 1 ( 0% ). Default color is #fd0060.', 'bespoke'),
                                            ),
                                            'b_h_g_2'        => array(
                                                    'label'     => esc_html__('Hover Gradient Color 2', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'value'     => '#9B0A65',
                                                    'desc'      => esc_html__('Insert your button hover gradient bg color point 2 ( 1% - 50% ). Default color is #9B0A65.', 'bespoke'),
                                            ),
                                            'b_h_g_3'        => array(
                                                    'label'     => esc_html__('Hover Gradient Color 3', 'bespoke'),
                                                    'type'      => 'color-picker',
                                                    'value'     => '#3a146a',
                                                    'desc'      => esc_html__('Insert your button hover gradient bg color point 3 ( 51% - 100% ). Default color is #3a146a.', 'bespoke'),
                                            )
                                    ),
                            ),
                            'show_borders' => false,
                    )
            )
    ),
    'padding_group'  => array(
            'type'    => 'group',
            'options' => array(
                    'html_label'     => array(
                            'type'  => 'html',
                            'value' => '',
                            'label' => esc_html__('Padding', 'bespoke'),
                            'html'  => '',
                    ),
                    'padding_top'    => array(
                            'label' => false,
                            'desc'  => esc_html__('Top', 'bespoke'),
                            'type'  => 'short-text',
                    ),
                    'padding_right'  => array(
                            'label' => false,
                            'desc'  => esc_html__('Right', 'bespoke'),
                            'type'  => 'short-text',
                    ),
                    'padding_bottom' => array(
                            'label' => false,
                            'desc'  => esc_html__('Bottom', 'bespoke'),
                            'type'  => 'short-text',
                    ),
                    'padding_left'   => array(
                            'label' => false,
                            'desc'  => esc_html__('Left', 'bespoke'),
                            'type'  => 'short-text',
                    ),
            )
        ),
        'margin_group'   => array(
            'type'    => 'group',
            'options' => array(
                    'html_label'    => array(
                            'type'  => 'html',
                            'value' => '',
                            'label' => esc_html__('Margin', 'bespoke'),
                            'html'  => '',
                    ),
                    'margin_top'    => array(
                            'label' => false,
                            'desc'  => esc_html__('Top', 'bespoke'),
                            'type'  => 'short-text',
                    ),
                    'margin_right'  => array(
                            'label' => false,
                            'desc'  => esc_html__('Right', 'bespoke'),
                            'type'  => 'short-text',
                    ),
                    'margin_bottom' => array(
                            'label' => false,
                            'desc'  => esc_html__('Bottom', 'bespoke'),
                            'type'  => 'short-text',
                            'value' => '',
                    ),
                    'margin_left'   => array(
                            'label' => false,
                            'desc'  => esc_html__('Left', 'bespoke'),
                            'type'  => 'short-text',
                    ),
            )
        ),

);