<?php
/**
 * The template for displaying the footer
 */
$footer_style = 1;
$footer_color = 1;
$footer_logo = array();
$site_info = wp_kses_post('© '.date('Y').' BESPOKE. ALL RIGHTS RESERVED. THEMEWAR.COM');
if(defined('FW')){
    $footer_logo = fw_get_db_settings_option('footer_logo', array());
    $footer_style = fw_get_db_settings_option('footer_style', 1);
    $footer_color = fw_get_db_settings_option('footer_color', 1);
    $site_info = fw_get_db_settings_option('site_info', wp_kses_post('© '.date('Y').' BESPOKE. ALL RIGHTS RESERVED. THEMEWAR.COM'));
}
$footer_class = 'bggreay';
$copy_class = '';
if($footer_color == 2){
    $footer_class = 'bgblack footer2';
    $copy_class = 'copyright2';
}

$logo = '';
if(isset($footer_logo['url']) && $footer_logo['url'] != ''){
    $logo = $footer_logo['url'];
}

?>
    <?php if($footer_style == 2): ?>
        <?php if(is_active_sidebar('sidebar-5') || is_active_sidebar('sidebar-6') || is_active_sidebar('sidebar-7')): ?>
            <footer class="footerEx <?php echo esc_attr($footer_class); ?>" id="footerEx">
                <div class="container-fluid">
                    <?php if($logo != ''): ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="fotLogo">
                                <img src="<?php echo esc_url($logo); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"/>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="row">
                        <?php if(is_active_sidebar('sidebar-5')): ?>
                        <div class="col-sm-6 col-md-4">
                            <?php dynamic_sidebar('sidebar-5'); ?>
                        </div>
                        <?php endif; ?>
                        <?php if(is_active_sidebar('sidebar-6')): ?>
                        <div class="col-sm-6 col-md-4">
                            <?php dynamic_sidebar('sidebar-6'); ?>
                        </div>
                        <?php endif; ?>
                        <?php if(is_active_sidebar('sidebar-7')): ?>
                        <div class="col-sm-6 col-md-4">
                            <?php dynamic_sidebar('sidebar-7'); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </footer>
        <?php endif; ?>
    <?php else: ?>
        <?php if(is_active_sidebar('sidebar-3') || is_active_sidebar('sidebar-4')): ?>
        <!--FOOTER START-->
            <footer class="footer <?php echo esc_attr($footer_class); ?>" id="footer">
                <div class="container-fluid">
                    <?php if($logo != ''): ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="fotLogo">
                                <img src="<?php echo esc_url($logo); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>"/>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="row">
                        <?php if(is_active_sidebar('sidebar-3')): ?>
                        <div class="col-sm-6">
                            <?php dynamic_sidebar('sidebar-3'); ?>
                        </div>
                        <?php endif; ?>
                        <?php if(is_active_sidebar('sidebar-4')): ?>
                        <div class="col-sm-6">
                            <?php dynamic_sidebar('sidebar-4'); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </footer>
            <!--FOOTER END-->
            <?php endif; ?>
    <?php endif; ?>        
        <?php if($site_info != ''): ?>
        <!--COPY RIGHT START-->
        <section class="copyright <?php echo esc_attr($copy_class); ?>">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12 text-center">
                        <p class="copyPera"><?php echo wp_kses_post($site_info); ?></p>
                    </div>
                </div>
            </div>
        </section>
        <!--COPY RIGHT END-->
        <?php endif; ?>

        <a id="backToTop" href="#"><i class="fa fa-angle-double-up"></i></a>
<?php wp_footer(); ?>

</body>
</html>
