<?php
/**
 * The template for displaying comments
 */

if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">
        <div class="commentList">
            <?php if ( have_comments() ) : ?>
                <ol class="comment-list">
                    <?php wp_list_comments(array('callback'=> 'bespoke_comment_listing')); ?>
                </ol>
                <?php
                    the_comments_pagination( array(
                        'prev_text' => '<i class="fa fa-angel-left"></i>',
                        'next_text' => '<i class="fa fa-angel-right"></i>'
                    ));
                ?>
            <?php endif; ?>
        </div>
	<?php
                $class = '';
                if(is_user_logged_in())
                {
                    $class = 'loggedIns';
                }
                $fields = array(
                            'author' =>'<div class="col-lg-6"><div class="single_form home_page2 inputas"><label for="author">'.esc_html__('Name:', 'bespoke').'</label><input id="author" name="author" type="text" value="' .
                                        esc_attr( $commenter['comment_author'] ) . '" size="30" /></div></div>',
                            'email'  => '<div class="col-lg-6"><div class="single_form home_page2 inputas"><label for="email">'.esc_html__('Email:', 'bespoke').'</label><input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) .
                                        '" size="30" /></div></div>',
                            'url'    => '',


                        );
                $fields = apply_filters('comment_form_default_fields', $fields);
                $args = array(
                    'fields'               => $fields,
                    'comment_field'        => '<div class="col-lg-12"><div class="single_form home_page2 textareas"><label for="comment">'.esc_html__('Comment:', 'bespoke').'</label><textarea id="comment" class="com_textarea" name="comment" aria-required="true" required="required"></textarea></div></div>',
                    'logged_in_as'         => '',
                    'comment_notes_before' => '',
                    'comment_notes_after'  => '',
                    'id_form'              => 'commentform',
                    'id_submit'            => 'submit',
                    'class_form'           => 'clearfix',
                    'class_submit'         => 'bes_button',
                    'name_submit'          => 'submit',
                    'title_reply'          => esc_html__( 'Write a response' , 'bespoke'),
                    'title_reply_to'       => __( 'Write a response to %s' , 'bespoke'),
                    'title_reply_before'   => '<div class="col-lg-12"><h3 id="reply-title" class="commentTitle poppins comReplyTitle">',
                    'title_reply_after'    => '</h3></div>',
                    'cancel_reply_before'  => ' <small>',
                    'cancel_reply_after'   => '</small>',
                    'cancel_reply_link'    => esc_html__( 'Cancel reply' , 'bespoke'),
                    'label_submit'         => esc_html__( 'submit' , 'bespoke'),
                    'submit_button'        => '<div class="col-lg-12 text-center"><button name="%1$s" type="submit" id="%2$s" class="%3$s sy_btn">%4$s</button></div>',
                    'submit_field'         => '%1$s %2$s',
                );
                ?>
                <div class="row">
                <?php
                    comment_form($args);
                ?>
                </div>
</div>