/*
 Theme Name: Bespoke - Creative One Page  WordPress Theme
 Theme URL: http://themewar.com/wp/bespoke/
 Author: nasirwd
 Author URI: http://themewar.com/
 Description: Bespoke - Creative One Page WordPress Theme
 Version: 1.0
 */

/*=======================================================================
 [Table of contents]
 =========================================================================
 [01] HEADER
 [02] TESTMONIAL
 [03] TESTMONIAL WITH BG
 [04] WORK CAROUSEL
 [05] STICKY HEADER
 [06] BACK TO TOP
 [07] AJAX CONTACT FORM
 [08] AJAX SUBSCRIPTION FORM
 
 
 
 ==========================================================================*/

(function ($) {
    'use strict';
    /*=======================================================================
     [00] Text SLIDER
     =========================================================================*/
    var wwd_sliders = $('.wwd_sliders');
    if (wwd_sliders.length > 0) {
        var dots = wwd_sliders.attr('data-controlls');
        var dot = false;
        if (dots == 1) {
            dot = true;
        }
        wwd_sliders.owlCarousel({
            items: 1,
            dots: dot,
            autoplay: true,
            nav: false
        });
    }
    ;

    /*=======================================================================
     [01] Clietn SLIDER
     =========================================================================*/
    var clientsliders = $('.clientsliders');
    if (clientsliders.length > 0) {
        clientsliders.owlCarousel({
            items: 4,
            dots: false,
            autoplay: true,
            nav: false,
            responsive: {
                0: {
                    items: 1
                },
                480: {
                    items: 1
                },
                768: {
                    items: 3
                },
                1200: {
                    items: 4
                }
            }
        });
    }
    ;


    /*=======================================================================
     [02] TESTMONIAL
     =========================================================================*/
    var testCarousel = $('#testmonial');
    if (testCarousel.length > 0) {
        testCarousel.owlCarousel({
            items: 1,
            dots: false,
            autoplay: true
        });
    }
    ;


    /*=======================================================================
     [03] TESTMONIAL WITH BG
     =========================================================================*/
    var testmonialCaro = $('.testcarousel');
    if (testmonialCaro.length > 0) {
        testmonialCaro.owlCarousel({
            items: 1,
            dots: true,
            autoplay: false
        });
    }
    ;

    /*=======================================================================
     [04] WORK CAROUSEL
     =========================================================================*/
    var workCarousel = $('#workCarousel');
    if (workCarousel.length > 0) {
        workCarousel.slick({
            centerMode: true,
            slidesToShow: 1,
            centerPadding: '275px',
            dots: false,
            prevArrow: '<div class="slick-prev slick-arrow"><i class="flaticon-arrows-2"></i></div>',
            nextArrow: '<div class="slick-next slick-arrow"><i class="flaticon-arrows-3"></i></div>',
            responsive: [
                {
                    breakpoint: 1440,
                    settings: {
                        slidesToShow: 1,
                        centerPadding: '175px'
                    }
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: 1,
                        centerPadding: '0'
                    }
                },
                {
                    breakpoint: 1280,
                    settings: {
                        slidesToShow: 1,
                        centerPadding: '80px'
                    }
                }
            ]
        });
    }
    ;


    /*=======================================================================
     [05] STICKY HEADER
     =========================================================================*/
    var sticky = $(".isSticky");
    var isSticky2 = $('.isSticky2');
    var isSticky3 = $('.isSticky3');
    $(window).on('scroll', function () {
        if ($(window).scrollTop() > 300)
        {
            sticky.addClass('fixedHeader animated slideInDown');
        } else
        {
            sticky.removeClass('fixedHeader animated slideInDown');
        }
        if ($(window).scrollTop() > 5)
        {
            isSticky2.addClass('fixedHeader_n1 animated slideInDown');
        } else
        {
            isSticky2.removeClass('fixedHeader_n1 animated slideInDown');
        }
        if ($(window).scrollTop() > 5)
        {
            isSticky3.addClass('fixedHeader_n2 animated slideInDown');
            $('.menustyle2').addClass(' fixedMenuStyle');
        } else
        {
            isSticky3.removeClass('fixedHeader_n2 animated slideInDown');
            $('.menustyle2').removeClass(' fixedMenuStyle');
        }

        /*====== Menu Active on Scroll ======*/
        Scroll();
        Scroll2();
        Scroll3();
    });
    
    if ($('.menuBar_n1').length > 0) {
        $('.menuBar_n1').on('click', function () {
            $(this).addClass('hiddeNow');
            $('.menustyle2').toggleClass('active');
        });
    }
    
    $('.menuBarCr').on('click', function(){
        $('.menustyle2').toggleClass('active');
        $('.menuBar_n1').removeClass('hiddeNow');
    });
    
    if ($('.menu2').length > 0) {
        $(".menu2 li.menu-item-has-children > a").on('click', function () {
            var $this = $(this);
            $(this).parent().toggleClass('active');
            $(this).parent().children('.sub-menu').slideToggle('slow');
            
            if($this.parent().hasClass('scroll')){
                $('html, body').animate({scrollTop: $(this.hash).offset().top - 68}, 1000);
            }
            return false;
        });
        $('.menu2 ul li.scroll > a').on('click', function () {
            $('html, body').animate({scrollTop: $(this.hash).offset().top - 68}, 1000);
            return false;
        });
    }
    
    

    $('.mainMenu ul li.scroll > a, .mouseSlider a, .mainMenu_home3 ul li.scroll > a').on('click', function () {
        $('html, body').animate({scrollTop: $(this.hash).offset().top - 68}, 1000);
        return false;
    });

    function Scroll() {

        var contentTop = [];
        var contentBottom = [];
        var winTop = $(window).scrollTop();
        var rangeTop = 200;
        var rangeBottom = 500;

        $('.mainMenu, .menu2, .menu3').find('.scroll > a').each(function () {
            var atr = $(this).attr('href');
            if ($(atr).length > 0)
            {
                contentTop.push($($(this).attr('href')).offset().top);
                contentBottom.push($($(this).attr('href')).offset().top + $($(this).attr('href')).height());
            }
        });

        $.each(contentTop, function (i) {
            if (winTop > contentTop[i] - rangeTop) {
                $('.mainMenu li.scroll, .menu2 li.scroll, .menu3 li.scroll').removeClass('active').eq(i).addClass('active');
            }
        });
    }

    $('.fixednavHeader ul li.scroll > a, .mouseSlider2 > a').on('click', function () {
        
        $('html, body').animate({scrollTop: $(this.hash).offset().top + 10}, 1000);
        return false;
    });



    function Scroll2() {

        var contentTop = [];
        var contentBottom = [];
        var winTop = $(window).scrollTop();
        var rangeTop = 200;
        var rangeBottom = 500;

        $('.fixednavHeader').find('.scroll > a').each(function () {
            var atr = $(this).attr('href');
            if ($(atr).length > 0)
            {
                contentTop.push($($(this).attr('href')).offset().top);
                contentBottom.push($($(this).attr('href')).offset().top + $($(this).attr('href')).height());
            }
        });
        $.each(contentTop, function (i) {
            if (winTop > contentTop[i] - rangeTop) {
                $('.fixednavHeader li.scroll, .mouseSlider2').removeClass('active').eq(i).addClass('active');
            }
        });
    }

    function Scroll3() {

        var contentTop = [];
        var contentBottom = [];
        var winTop = $(window).scrollTop();
        var rangeTop = 200;
        var rangeBottom = 500;

        $('.mainMenu_home3').find('.scroll > a').each(function () {
            var atr = $(this).attr('href');
            if ($(atr).length > 0)
            {
                contentTop.push($($(this).attr('href')).offset().top);
                contentBottom.push($($(this).attr('href')).offset().top + $($(this).attr('href')).height());
            }
        });
        $.each(contentTop, function (i) {
            if (winTop > contentTop[i] - rangeTop) {
                $('.mainMenu_home3 li.scroll').removeClass('active').eq(i).addClass('active');
            }
        });
    }

    /*=======================================================================
     [06] BACK TO TOP
     =========================================================================*/
    var back = $("#backToTop"),
            body = $("body, html");
    $(window).on('scroll', function () {
        if ($(window).scrollTop() > $(window).height())
        {
            back.addClass('showit');
        } else
        {
            back.removeClass('showit');
        }

    });
    body.on("click", "#backToTop", function (e) {
        e.preventDefault();
        body.animate({scrollTop: 0}, 800);
    });

    /*=======================================================================
     [08] PERELAX
     =========================================================================*/
    $(document).ready(function () {
        if ($('.perelaxBg1').length > 0) {
            $('.perelaxBg1').each(function () {
                var id = $(this).attr('data-paraid');
                var paraclass = 'perelaxBG_' + id;

                $('.' + paraclass).parallaxes("0", 0.2);
            });
        }

    });


    /*=======================================================================
     [09] BLOG CAT TOGGLE
     =========================================================================*/
    var bcat = $('.blogCat');
    if (bcat.length > 0) {
        $('.blogCat h6').on('click', function () {
            bcat.toggleClass('active');
        });
    }

    /*=======================================================================
     [10] PRELOADER
     =========================================================================*/
    $(window).load(function () {
        var preload = $('.preloader');
        if (preload.length > 0) {
            preload.delay(800).fadeOut('slow');
        }
    });

    /*=======================================================================
     [11] Single Blog Comment Has Top
     =========================================================================*/
    var jon_comment = $('.jon_comment');
    jon_comment.on('click', function () {
        $('html, body').animate({scrollTop: $(this.hash).offset().top - 100}, 1000);
        return false;
    });

    /*=======================================================================
     [11] Typing Animation
     =========================================================================*/
    var TxtType = function (el, toRotate, period) {
        this.toRotate = toRotate;
        this.el = el;
        this.loopNum = 0;
        this.period = parseInt(period, 10) || 2000;
        this.txt = '';
        this.tick();
        this.isDeleting = false;
    };
    TxtType.prototype.tick = function () {
        var i = this.loopNum % this.toRotate.length;
        var fullTxt = this.toRotate[i];

        if (this.isDeleting) {
            this.txt = fullTxt.substring(0, this.txt.length - 1);
        } else {
            this.txt = fullTxt.substring(0, this.txt.length + 1);
        }

        this.el.innerHTML = '<span class="wrap">' + this.txt + '</span>';

        var that = this;
        var delta = 200 - Math.random() * 100;

        if (this.isDeleting) {
            delta /= 2;
        }
        if (!this.isDeleting && this.txt === fullTxt) {
            delta = this.period;
            this.isDeleting = true;
        } else if (this.isDeleting && this.txt === '') {
            this.isDeleting = false;
            this.loopNum++;
            delta = 500;
        }

        setTimeout(function () {
            that.tick();
        }, delta);
    };
    window.onload = function () {
        var elements = document.getElementsByClassName('typewrite');
        for (var i = 0; i < elements.length; i++) {
            var toRotate = elements[i].getAttribute('data-type');
            var period = elements[i].getAttribute('data-period');
            if (toRotate) {
                new TxtType(elements[i], JSON.parse(toRotate), period);
            }
        }
        var css = document.createElement("style");
        css.type = "text/css";
        css.innerHTML = ".typewrite > .wrap{border-right: 10px solid #fff;}";
        document.body.appendChild(css);
    };

    /*=======================================================================
     [11] Home3 Header Nav
     =========================================================================*/
    $(window).on('scroll', function () {
        var head3 = $(".header3");
        var wh = parseInt($(document).height(), 10) - 1000;
        if ($(this).scrollTop() > wh) {
            head3.addClass('active');
        } else {
            head3.removeClass('active');
        }
    });

    /*=======================================================================
     [12] Mobile Menu
     =========================================================================*/
    var menu_bar = $('.mobileBar');
    if (menu_bar.length > 0) {
        menu_bar.on('click', function () {
            $(this).toggleClass('active');
            $('.mainMenu > ul').slideToggle('slow');
        });
        if ($(window).width() < 990)
        {
            $(".mainMenu li.menu-item-has-children > a").on('click', function () {
                $(this).parent().toggleClass('active');
                $(this).parent().children('.sub-menu').slideToggle('slow');
                return false;
            });
        }
    }

    //=======================================================
    // Home 3 Mobile Menu
    //=======================================================
    var menu_h3 = $(".mainMenu_home3 > .mobileBar"),
            menu_ul = $(".mainMenu_home3 > ul");
    if (menu_h3.length > 0)
    {
        var todg = true;
        menu_h3.on("click", function (e) {
            e.preventDefault();
            if (todg)
            {
                menu_ul.animate({'right': '0px'}, 400);
                todg = false;
            } else
            {
                menu_ul.animate({'right': '-245px'}, 400);
                todg = true;
            }
        });
        $(document).on('mouseup', function (e) {
            var container = menu_ul;

            if (!container.is(e.target) && container.has(e.target).length === 0)
            {
                menu_ul.animate({'right': '-245px'}, 400);
                todg = true;
            }

        });
        if ($(".mainMenu_home3 > ul li.scroll > a").on('click', function (e) {
            e.preventDefault();
            menu_ul.animate({'right': '-245px'}, 400);
        }))
            ;
    }
    ;

    if ($(".iframeplay").length > 0)
    {
        $('.iframeplay, .folio_video').magnificPopup({type: 'iframe'});
    }
    if ($(".popupVideos").length > 0)
    {
        $('.popupVideos').magnificPopup({type: 'iframe'});
    }
    if ($(".folio_video").length > 0)
    {
        $('.folio_video, .single_folio_video').magnificPopup({type: 'iframe'});
    }
    if ($(".single_folio_video").length > 0)
    {
        $('.single_folio_video').magnificPopup({type: 'iframe'});
    }
    if ($(".fgpopup").length > 0)
    {
        $('.fgpopup').magnificPopup({
            type:'image',
            gallery:{
                enabled:true
            }
        });
    }


     /*=======================================================================
     [12] Mobile Menu Style 03
     =========================================================================*/
    var menu_bar = $('.mainNav1_n1 .menuBarnav1_n2');
    if (menu_bar.length > 0) {
        menu_bar.on('click', function () {
            $(this).toggleClass('active');
            $('.mainNav1_n1 > ul').slideToggle('slow');
        });
        if ($(window).width() < 991)
        {
            $(".mainNav1_n1 li.menu-item-has-children > a").on('click', function () {
                $(this).parent().toggleClass('active');
                $(this).parent().children('.sub-menu').slideToggle('slow');
                return false;
            });
        }
    }

    //=======================================================
    // Post BG Slider
    //=======================================================
    if ($(".gallSliders").length > 0) {
        var galls = $(".gallSliders").attr('data-galls');
        var res = galls.split(',');
        var r = [];
        res.forEach(function (item, index, array) {
            r.push({src: item})
        });
        $(".gallSliders").vegas({
            loop: true,
            timer: false,
            overlay: false,
            transition: 'zoomOut',
            slides: r,
            cover: true
        });
    }


    //=======================================================
    // CountDown
    //=======================================================
    var countdown = $('#countdown_dashboard')
    if (countdown.length > 0) {
        var d = $('#countdown_dashboard').attr('data-day');
        var m = $('#countdown_dashboard').attr('data-month');
        var y = $('#countdown_dashboard').attr('data-year');
        $('#countdown_dashboard').countdown({
            until: new Date(y, m - 1, d),
            format: 'DHMS'
        });
    }


    /*==========================================================================
     // Google Map
     =========================================================================*/
    if ($("#map").length > 0)
    {
        var map;
        var lon = $('#map').attr('data-lon');
        var lat = $('#map').attr('data-lat');
        var marker = $('#map').attr('data-marker');

        map = new GMaps({
            el: "#map",
            lat: lat,
            lng: lon,
            scrollwheel: false,
            draggable: false,
            zoom: 16,
            zoomControl: false,
            panControl: false,
            streetViewControl: false,
            mapTypeControl: false,
            overviewMapControl: false,
            clickable: false,
        });
        var image = "";
        map.addMarker({
            lat: lat,
            lng: lon,
            icon: marker,
            animation: google.maps.Animation.DROP,
            verticalAlign: "bottom",
            horizontalAlign: "center",
            backgroundColor: "#222222"
        });
        var styles = [
            {
                "featureType": "road",
                "stylers": [
                    {"color": "#222222"}
                ]
            }, {
                "featureType": "water",
                "stylers": [
                    {"color": "#111111"}
                ]
            }, {
                "featureType": "landscape",
                "stylers": [
                    {"color": "#1d1d1d"}
                ]
            }, {
                "elementType": "labels.text.fill",
                "stylers": [
                    {"color": "#333333"}
                ]
            }, {
                "featureType": "poi",
                "stylers": [
                    {"color": "#222222"}
                ]
            }, {
                "elementType": "labels.text",
                "stylers": [
                    {"saturation": 1},
                    {"weight": 0.1},
                    {"color": "#444444"}
                ]
            }

        ];
        map.addStyle({
            styledMapName: "Styled Map",
            styles: styles,
            mapTypeId: "map_style"
        });

        map.setStyle("map_style");
    }


    //========================
    // Skill
    //========================
    if ($(".singleSkill").length > 0)
    {
        $('.singleSkill').appear();
        $('.singleSkill').on('appear', loadSkills);
    }
    var coun = true;
    function loadSkills()
    {
        $(".singleSkill").each(function () {
            var datacount = $(this).attr("data-limit");
            $(".skillBar", this).animate({'width': datacount + '%'}, 2000);
            $(".skillBar2", this).animate({'width': datacount + '%'}, 2000);
            if (coun)
            {
                $(this).find('.skilPercent').each(function () {
                    var $this = $(this);
                    $({Counter: 0}).animate({Counter: datacount}, {
                        duration: 2000,
                        easing: 'swing',
                        step: function () {
                            $this.text(Math.ceil(this.Counter) + '%');
                        }
                    });
                });

            }
        });
        coun = false;
    }

    //========================================================
    // Fun Fact
    //========================================================
    var skl = true;
    $('.singleFun').appear();
    $('.singleFun').on('appear', function () {
        if (skl)
        {
            $('.counting').each(function () {
                var $this = $(this);
                jQuery({Counter: 0}).animate({Counter: $this.attr('data-counter')}, {
                    duration: 6000,
                    easing: 'swing',
                    step: function () {
                        var num = Math.ceil(this.Counter).toString();
                        if (Number(num) > 999) {
                            while (/(\d+)(\d{3})/.test(num)) {
                                num = num.replace(/(\d+)(\d{3})/, '<span class="countSpan">' + '$1' + ',</span>' + '$2');
                            }
                        }
                        $this.html(num);
                    }
                });
            });
            skl = false;
        }
    });
    
    $(window).on('load', function(){
        $('#gridsam').masonry({
            itemSelector: '.gritem'
        });
    });

})(jQuery);
