<?php
/**
 * The template for displaying 404 pages (not found)
 */

get_header(); 

$fof_bg = array();
$fof_heading = esc_html__('404', 'bespoke');
$four_sub_heading = esc_html__('Opps! page not found.', 'bespoke');
$four_desc = esc_html__('We can’t find what you’re looking for.', 'bespoke');
if(defined('FW')){
    $fof_bg = fw_get_db_settings_option('fof_bg', array());
    $fof_heading = fw_get_db_settings_option('fof_heading', esc_html__('404', 'bespoke'));
    $four_sub_heading = fw_get_db_settings_option('four_sub_heading', esc_html__('Opps! page not found.', 'bespoke'));
    $four_desc = fw_get_db_settings_option('four_desc', esc_html__('We can’t find what you’re looking for.', 'bespoke'));
}

$bg = '';
if(is_array($fof_bg) && isset($fof_bg['url']) && $fof_bg['url'] != ''){
    $bg = 'background-image: url('.$fof_bg["url"].'); background-size: cover; background-position: center center; ';
}

?>

<section class="errorPage" style="<?php echo esc_attr($bg); ?>">
    <div class="errorOv"></div>
    <div class="errorContent text-left">
        <div class="container-fluid shopSectionRow">
            <div class="row shopSectionRoin">
                <?php if($fof_heading != ''): ?>
                    <h1><?php echo wp_kses_post($fof_heading); ?></h1>
                <?php endif; ?>
                <?php if($four_sub_heading != ''): ?>
                    <h3><?php echo wp_kses_post($four_sub_heading); ?></h3>
                <?php endif; ?>
                <?php if($four_desc != ''): ?>
                    <p><?php echo wp_kses_post($four_desc); ?></p>
                <?php endif; ?>
                <div class="search_404">
                    <form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                        <a href="<?php echo esc_url(home_url('/'));?>"><?php echo esc_html__('back to home', 'bespoke') ?></a>
                        <input value="" placeholder="<?php echo esc_attr__('Search...', 'bespoke'); ?>" value="<?php echo get_search_query(); ?>" type="search"> 
                        <input  name="s" value="search" type="submit">
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer();
